/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.service;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.intenso.confluence.plugins.action.FormatedUserPasswordPolicy;
import com.intenso.confluence.plugins.passpolicy.EmailTemplate;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.passpolicy.UserPasswordPolicy;
import com.intenso.confluence.plugins.service.PasswordExpirationNotifierChecker;
import com.intenso.confluence.plugins.service.PasswordExpirationNotifierService;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import com.intenso.confluence.plugins.utils.UserPreferencesUtils;
import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.stereotype.Component;

@Component
public class PasswordExpirationNotifierServiceImpl
implements PasswordExpirationNotifierService {
    public static final String MAIL = "mail";
    private final PluginConfigurationService pluginConfigurationService;
    private final PasswordPolicyService passwordPolicyService;
    private final MultiQueueTaskManager taskManager;
    private final SettingsManager settingsManager;
    private MailServerManager mailServerManager;
    private UserAccessor userAccessor;
    private FormatSettingsManager formatSettingsManager;
    private static LocaleManager localeManager;

    public PasswordExpirationNotifierServiceImpl(PasswordPolicyService passwordPolicyService, PluginConfigurationService pluginConfigurationService, MultiQueueTaskManager taskManager, SettingsManager settingsManager, MailServerManager mailServerManager, LocaleManager localeManager, UserAccessor userAccessor, FormatSettingsManager formatSettingsManager) {
        this.pluginConfigurationService = pluginConfigurationService;
        this.passwordPolicyService = passwordPolicyService;
        this.taskManager = taskManager;
        this.settingsManager = settingsManager;
        this.mailServerManager = mailServerManager;
        PasswordExpirationNotifierServiceImpl.localeManager = localeManager;
        this.userAccessor = userAccessor;
        this.formatSettingsManager = formatSettingsManager;
    }

    @Override
    public void executeNotifier() {
        PluginConfiguration configuration;
        DateTime nowDateTime = new DateTime();
        if (this.pluginConfigurationService.isLicenseValidAndPluginEnabled() && (configuration = this.pluginConfigurationService.getConfiguration()).getPasswordExpirationNotifierEnabled().booleanValue() && configuration.getMaximumPasswordAge() > 0) {
            for (String userName : this.userAccessor.getUserNamesWithConfluenceAccess()) {
                this.sendNotificationIfNeeded(configuration, this.userAccessor.getUserByName(userName), nowDateTime);
            }
            this.pluginConfigurationService.updateLastPasswordExpirationNotifierExecution(nowDateTime.toDate());
        }
    }

    private void sendNotificationIfNeeded(PluginConfiguration configuration, ConfluenceUser user, DateTime nowDateTime) {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        UserPreferences userPreferences = userAccessor.getUserPreferences(user);
        PasswordExpirationNotifierChecker.NotifierData notifierData = this.checkNeedRunNotifier(configuration, userPreferences, nowDateTime);
        if (notifierData != null) {
            UserPasswordPolicy userPasswordPolicy = this.passwordPolicyService.createLazyUserPasswordPolicy(user, configuration);
            FormatedUserPasswordPolicy formatedUserPasswordPolicy = new FormatedUserPasswordPolicy(userPasswordPolicy, notifierData);
            if (notifierData.isNeedRunNotifier()) {
                this.sendPasswordExpirationNotification((User)user, formatedUserPasswordPolicy);
                UserPreferencesUtils.setDate("last_password_expiration_notification_send_date", userPreferences, nowDateTime.toDate());
            } else if (notifierData.isSendPasswordExpiredNotification()) {
                this.sendPasswordExpiredNotification((User)user, formatedUserPasswordPolicy);
                UserPreferencesUtils.setDate("last_password_expired_notification_send_date", userPreferences, nowDateTime.toDate());
            }
        }
    }

    private void sendPasswordExpirationNotification(User user, FormatedUserPasswordPolicy userPasswordPolicy) {
        EmailTemplate emailTemplate = this.pluginConfigurationService.getConfiguration().getPasswordExpirationNotifierEmailTemplate();
        this.sendNotification(user, userPasswordPolicy, emailTemplate);
    }

    private void sendPasswordExpiredNotification(User user, FormatedUserPasswordPolicy userPasswordPolicy) {
        EmailTemplate emailTemplate = this.pluginConfigurationService.getConfiguration().getPasswordExpiredNotifierEmailTemplate();
        this.sendNotification(user, userPasswordPolicy, emailTemplate);
    }

    private void sendNotification(User user, FormatedUserPasswordPolicy userPasswordPolicy, EmailTemplate emailTemplate) {
        if (this.mailServerManager.getDefaultSMTPMailServer() != null) {
            String defaultFrom = this.mailServerManager.getDefaultSMTPMailServer().getDefaultFrom();
            String baseUrl = this.settingsManager.getGlobalSettings().getBaseUrl();
            Locale locale = localeManager.getLocale((User)userPasswordPolicy.getUser());
            Email email = this.createEmail(user.getEmail(), defaultFrom, emailTemplate, userPasswordPolicy, baseUrl, locale);
            SingleMailQueueItem item = new SingleMailQueueItem(email);
            this.taskManager.addTask(MAIL, () -> ((SingleMailQueueItem)item).send());
        }
    }

    private Email createEmail(String recipient, String defaultFrom, EmailTemplate emailTemplate, FormatedUserPasswordPolicy userPasswordPolicy, String baseUrl, Locale locale) {
        ConfluenceUser user = userPasswordPolicy.getUser();
        DateTimeFormatter formatter = DateTimeFormat.shortDateTime().withLocale(localeManager.getLocale((User)user));
        UserPreferences userPreferences = this.userAccessor.getUserPreferences(user);
        DateFormatter dateFormatter = new DateFormatter(userPreferences.getTimeZone(), this.formatSettingsManager, localeManager);
        Email email = new Email(recipient);
        email.setFrom(defaultFrom);
        email.setFromName(emailTemplate.getFromName().getValueForLocale(locale));
        email.setSubject(emailTemplate.getSubject().getValueForLocale(locale));
        email.setBody(emailTemplate.evaluateBody(userPasswordPolicy, baseUrl, dateFormatter, locale));
        email.setMimeType("text/html");
        return email;
    }

    @Override
    public PasswordExpirationNotifierChecker.NotifierData checkNeedRunNotifier(PluginConfiguration configuration, UserPreferences userPreferences, DateTime nowDateTime) {
        DateTime lastPasswordExpiredNotificationSendDateDateTime;
        Date lastPasswordChangeDate = UserPreferencesUtils.getDate("last_password_changed_date_property", userPreferences);
        Date lastPasswordExpirationNotificationSendDate = UserPreferencesUtils.getDate("last_password_expiration_notification_send_date", userPreferences);
        Date lastPasswordExpiredNotificationSendDate = UserPreferencesUtils.getDate("last_password_expired_notification_send_date", userPreferences);
        DateTime lastPasswordChangeDateTime = null;
        Integer maximumPasswordAge = configuration.getMaximumPasswordAge();
        DateTime lastPasswordExpirationNotificationSendDateTime = lastPasswordExpirationNotificationSendDate != null ? new DateTime(lastPasswordExpirationNotificationSendDate) : null;
        DateTime dateTime = lastPasswordExpiredNotificationSendDateDateTime = lastPasswordExpiredNotificationSendDate != null ? new DateTime(lastPasswordExpiredNotificationSendDate) : null;
        if (lastPasswordChangeDate != null) {
            lastPasswordChangeDateTime = new DateTime(lastPasswordChangeDate);
        }
        Boolean isExpiringPolicyEnabledForUser = userPreferences.getBoolean("com.intenso.jira.plugins.passpolicy:expiring-policy-enabled").orElse(false);
        return PasswordExpirationNotifierChecker.checkNeedRunNotifier(nowDateTime, lastPasswordChangeDateTime, maximumPasswordAge, configuration.getPasswordExpirationNotifierDuration(), lastPasswordExpirationNotificationSendDateTime, lastPasswordExpiredNotificationSendDateDateTime, isExpiringPolicyEnabledForUser);
    }
}

