/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.service;

import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;

public class PasswordExpirationNotifierChecker {
    private static final int hoursInDay = 24;
    private final DateTime lastPasswordChangeDate;
    private final Integer maximumPasswordAge;
    private final Integer passwordExpirationNotifierDuration;
    private final DateTime lastPasswordExpirationNotificationSendDate;
    private final DateTime lastPasswordExpiredNotificationSendDate;
    private final NotifierData notifierData;
    private final DateTime nowDateTime;
    private final boolean isExpiringPolicyEnabledForUser;

    private PasswordExpirationNotifierChecker(DateTime nowDateTime, DateTime lastPasswordChangeDate, Integer maximumPasswordAge, Integer passwordExpirationNotifierDuration, DateTime lastPasswordExpirationNotificationSendDate, DateTime lastPasswordExpiredNotificationSendDate, boolean isExpiringPolicyEnabledForUser) {
        this.lastPasswordChangeDate = lastPasswordChangeDate;
        this.maximumPasswordAge = maximumPasswordAge;
        this.passwordExpirationNotifierDuration = passwordExpirationNotifierDuration;
        this.lastPasswordExpirationNotificationSendDate = lastPasswordExpirationNotificationSendDate;
        this.lastPasswordExpiredNotificationSendDate = lastPasswordExpiredNotificationSendDate;
        this.nowDateTime = nowDateTime;
        this.isExpiringPolicyEnabledForUser = isExpiringPolicyEnabledForUser;
        this.notifierData = new NotifierData(this);
    }

    public static NotifierData checkNeedRunNotifier(DateTime nowDateTime, DateTime lastPasswordChangeDate, Integer maximumPasswordAge, Integer passwordExpirationNotifierDuration, DateTime lastPasswordExpirationNotificationSendDate, DateTime lastPasswordExpiredNotificationSendDate, boolean isExpiringPolicyEnabledForUser) {
        PasswordExpirationNotifierChecker checker = new PasswordExpirationNotifierChecker(nowDateTime, lastPasswordChangeDate, maximumPasswordAge, passwordExpirationNotifierDuration, lastPasswordExpirationNotificationSendDate, lastPasswordExpiredNotificationSendDate, isExpiringPolicyEnabledForUser);
        return checker.checkNeedRunNotifier();
    }

    public NotifierData checkNeedRunNotifier() {
        DateTime dateTime = this.notifierData.expirationDate = this.lastPasswordChangeDate != null ? this.lastPasswordChangeDate.plusDays(this.maximumPasswordAge) : null;
        if (this.getIsBeforeExpirationInNotifierDuration()) {
            for (int i = 0; i <= this.passwordExpirationNotifierDuration; ++i) {
                DateTime notificationDay = this.notifierData.expirationDate.minusHours(24 * i);
                DateTime nowDate = this.nowDateTime.withMillisOfDay(0);
                if (!this.isExpiringPolicyEnabledForUser || !notificationDay.withMillisOfDay(0).isEqual(nowDate) || this.lastPasswordExpirationNotificationSendDate != null && (this.lastPasswordExpirationNotificationSendDate.withMillisOfDay(0).equals(nowDate) || !notificationDay.isAfter(this.lastPasswordExpirationNotificationSendDate))) continue;
                this.notifierData.needRunNotifier = true;
            }
        }
        return this.notifierData;
    }

    private boolean getIsBeforeExpirationInNotifierDuration() {
        if (!this.notifierData.passwordExpired) {
            this.notifierData.passwordExpirationNotifierDurationHours = Days.days(this.passwordExpirationNotifierDuration).toStandardHours().getHours();
            this.notifierData.beforeExpirationInNotiferDuration = this.notifierData.passwordExpirationNotifierDurationHours > this.notifierData.hoursToPasswordExpiration;
            return this.notifierData.beforeExpirationInNotiferDuration;
        }
        return false;
    }

    public DateTime getNowDateTime() {
        return this.nowDateTime;
    }

    public NotifierData getNotifierData() {
        return this.notifierData;
    }

    public class NotifierData {
        private Hours passwordAge;
        private int hoursToPasswordExpiration;
        private int daysToPasswordExpiration;
        private int passwordExpirationNotifierDurationHours;
        private boolean beforeExpirationInNotiferDuration;
        private DateTime expirationDate;
        private boolean needRunNotifier = false;
        private boolean passwordExpired = false;
        private boolean sendPasswordExpiredNotification = false;

        public NotifierData(PasswordExpirationNotifierChecker this$0) {
            Integer maximumPasswordAgeInHours = this$0.maximumPasswordAge * 24;
            this.passwordAge = this$0.lastPasswordChangeDate != null ? Hours.hoursBetween(this$0.lastPasswordChangeDate, this$0.nowDateTime) : Hours.hours(maximumPasswordAgeInHours);
            this.hoursToPasswordExpiration = maximumPasswordAgeInHours - this.passwordAge.getHours();
            this.daysToPasswordExpiration = Hours.hours(this.hoursToPasswordExpiration).toStandardDays().getDays();
            this.passwordExpired = this$0.lastPasswordChangeDate == null || this.passwordAge.getHours() > maximumPasswordAgeInHours;
            this.sendPasswordExpiredNotification = this$0.isExpiringPolicyEnabledForUser && this$0.lastPasswordChangeDate != null && this.passwordExpired && this$0.lastPasswordExpiredNotificationSendDate == null;
        }

        public Hours getPasswordAge() {
            return this.passwordAge;
        }

        public int getHoursToPasswordExpiration() {
            return this.hoursToPasswordExpiration;
        }

        public int getPasswordExpirationNotifierDurationHours() {
            return this.passwordExpirationNotifierDurationHours;
        }

        public DateTime getExpirationDate() {
            return this.expirationDate;
        }

        public boolean isNeedRunNotifier() {
            return this.needRunNotifier;
        }

        public boolean isBeforeExpirationInNotiferDuration() {
            return this.beforeExpirationInNotiferDuration;
        }

        public int getDaysToPasswordExpiration() {
            return this.daysToPasswordExpiration;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NotifierData [passwordAge=");
            builder.append(this.passwordAge);
            builder.append(", hoursToPasswordExpiration=");
            builder.append(this.hoursToPasswordExpiration);
            builder.append(", daysToPasswordExpiration=");
            builder.append(this.daysToPasswordExpiration);
            builder.append(", passwordExpirationNotifierDurationHours=");
            builder.append(this.passwordExpirationNotifierDurationHours);
            builder.append(", beforeExpirationInNotiferDuration=");
            builder.append(this.beforeExpirationInNotiferDuration);
            builder.append(", expirationDate=");
            builder.append(this.expirationDate);
            builder.append(", needRunNotifier=");
            builder.append(this.needRunNotifier);
            builder.append("]");
            return builder.toString();
        }

        public boolean isPasswordExpired() {
            return this.passwordExpired;
        }

        public boolean isSendPasswordExpiredNotification() {
            return this.sendPasswordExpiredNotification;
        }
    }
}

