/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.service;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.User;
import com.intenso.confluence.plugins.action.FormattedLockingAfterDateUserPolicy;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.passpolicy.UserPasswordPolicy;
import com.intenso.confluence.plugins.service.LockUserAccountService;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import com.intenso.confluence.plugins.service.UserDirectoryService;
import com.intenso.confluence.plugins.utils.UserPreferencesUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class LockUserAccountServiceImpl
implements LockUserAccountService {
    private final PluginConfigurationService pluginConfigurationService;
    private final PasswordPolicyService passwordPolicyService;
    private final PermissionManager permissionManager;
    private final UserDirectoryService userDirectoryService;
    private final UserManager userManager;
    private final UserAccessor userAccessor;
    private final LoginManager loginManager;
    public static final String USER_LOCK_AFTER_DATE_KEY = "intenso-password-policy-user-lock-after-date";

    public LockUserAccountServiceImpl(PluginConfigurationService pluginConfigurationService, PasswordPolicyService passwordPolicyService, PermissionManager permissionManager, UserDirectoryService userDirectoryService, UserManager userManager, UserAccessor userAccessor, LoginManager loginManager) {
        this.pluginConfigurationService = pluginConfigurationService;
        this.passwordPolicyService = passwordPolicyService;
        this.permissionManager = permissionManager;
        this.userDirectoryService = userDirectoryService;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.loginManager = loginManager;
    }

    @Override
    public void lockUsersWithExpiredPasswords() {
        PluginConfiguration configuration = this.pluginConfigurationService.getConfiguration();
        if (this.pluginConfigurationService.isLicenseValidAndPluginEnabled() && configuration.getUserAccountLockingEnabled().booleanValue() && configuration.getUserAccountLockingAfterPasswordExpirationEnabled().booleanValue() && configuration.getMaximumPasswordAge() > 0) {
            this.doLockUsersWithExpiredPasswords(configuration);
        }
    }

    private void doLockUsersWithExpiredPasswords(PluginConfiguration configuration) {
        Integer hoursAfterPasswordExpirationToLockUserAccount = configuration.getDaysAfterPasswordExpirationToLockUserAccount() * 24;
        for (String userName : this.userAccessor.getUserNamesWithConfluenceAccess()) {
            ConfluenceUser user = this.userAccessor.getUserByName(userName);
            if (!this.isFromInternalDirectory((User)user) || this.permissionManager.isSystemAdministrator(user)) continue;
            this.lockUser(configuration, hoursAfterPasswordExpirationToLockUserAccount, user);
        }
    }

    private void lockUser(PluginConfiguration configuration, Integer hoursAfterPasswordExpirationToLockUserAccount, ConfluenceUser user) {
        UserPasswordPolicy userPasswordPolicy = this.passwordPolicyService.createLazyUserPasswordPolicy(user, configuration);
        if (userPasswordPolicy.isPasswordExpired()) {
            Integer hoursAfterPasswordExpirationDate = userPasswordPolicy.getHoursAfterPasswordExpirationDate();
            if (!userPasswordPolicy.getIsUserAccountUnlockedManually() && hoursAfterPasswordExpirationDate != null && hoursAfterPasswordExpirationDate > hoursAfterPasswordExpirationToLockUserAccount) {
                userPasswordPolicy.getUserPreferences().setBoolean("com.intenso.jira.plugins.passpolicy:user_account_locked", true);
                UserPreferencesUtils.setDate("com.intenso.jira.plugins.passpolicy:date_of_user_locking_user_account", userPasswordPolicy.getUserPreferences(), new Date());
            }
        }
    }

    @Override
    public boolean lockUserAccount(String username) {
        return this.changeUserLockProperty(username, LockValue.LOCK);
    }

    @Override
    public boolean unlockUserAccount(String username) {
        return this.changeUserLockProperty(username, LockValue.UNLOCK);
    }

    private boolean changeUserLockProperty(String username, LockValue lockValue) {
        ConfluenceUser user;
        UserProfile remoteUser = this.userManager.getRemoteUser();
        if (remoteUser == null) {
            return false;
        }
        boolean isUserLocked = false;
        ConfluenceUser loggedInUser = this.userAccessor.getUserByName(remoteUser.getUsername());
        boolean isSystemAdmin = this.isUserSystemAdmin((User)loggedInUser);
        if (isSystemAdmin && (user = this.userAccessor.getUserByName(username)) != null && !this.isUserSystemAdmin((User)user)) {
            UserPreferences preferences = this.userAccessor.getUserPreferences(user);
            if (lockValue.equals((Object)LockValue.LOCK)) {
                isUserLocked = true;
                UserPreferencesUtils.setDate("com.intenso.jira.plugins.passpolicy:date_of_user_locking_user_account", preferences, new Date());
                preferences.setBoolean("com.intenso.jira.plugins.passpolicy:user_account_unlocked_manually", false);
            } else {
                preferences.remove("com.intenso.jira.plugins.passpolicy:date_of_user_locking_user_account");
                preferences.setBoolean("com.intenso.jira.plugins.passpolicy:user_account_unlocked_manually", true);
            }
            preferences.setBoolean("com.intenso.jira.plugins.passpolicy:user_account_locked", isUserLocked);
        }
        return isUserLocked;
    }

    private boolean isUserSystemAdmin(User loggedInUser) {
        ConfluenceUser cUser = (ConfluenceUser)loggedInUser;
        UserKey userKey = cUser.getKey();
        return this.userManager.isSystemAdmin(userKey);
    }

    @Override
    public void updateUserAccountLockAfterDatePolicy(ConfluenceUser user, Date date) {
        if (!this.isUserSystemAdmin((User)user)) {
            UserPreferences preferences = this.userAccessor.getUserPreferences(user);
            preferences.setLong(USER_LOCK_AFTER_DATE_KEY, date.getTime());
        }
    }

    @Override
    public void removeUserAccountLockAfterDatePolicy(ConfluenceUser user) {
        UserPreferences preferences = this.userAccessor.getUserPreferences(user);
        preferences.remove(USER_LOCK_AFTER_DATE_KEY);
    }

    @Override
    public boolean isAnyUserAccountLockAfterDatePolicyExists() {
        for (String username : this.userAccessor.getUserNamesWithConfluenceAccess()) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            UserPreferences preferences = this.userAccessor.getUserPreferences(user);
            if (!preferences.getLong(USER_LOCK_AFTER_DATE_KEY).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateUserAccountLockAfterDatePolicy(String username, String dateTime) {
        if (!this.isUserExists(username)) {
            return;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        Date date = new Date(dateTime);
        this.updateUserAccountLockAfterDatePolicy(user, date);
    }

    @Override
    public void removeUserAccountLockAfterDatePolicy(String username) {
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        UserPreferences preferences = this.userAccessor.getUserPreferences(user);
        preferences.remove(USER_LOCK_AFTER_DATE_KEY);
    }

    @Override
    public boolean isUserExists(String username) {
        return this.userAccessor.exists(username);
    }

    @Override
    public boolean canLockAccountAfterDate(User user) {
        return !this.isUserSystemAdmin(user) && this.isLockingEnabled();
    }

    private boolean isLockingEnabled() {
        return this.pluginConfigurationService.isUserAccountLockingEnabled();
    }

    @Override
    public String canSetLockAfterDatePolicy(String username) {
        if (this.isUserExists(username)) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            if (this.isUserSystemAdmin((User)user)) {
                return "You can't lock confluence admin.";
            }
            return "";
        }
        return "User " + username + " doesn't exits.";
    }

    @Override
    public boolean isDateValid(String date) {
        return true;
    }

    @Override
    public boolean isUserLocked(ConfluenceUser user) {
        if (user == null) {
            return false;
        }
        if (this.pluginConfigurationService.isUserAccountLockingEnabled() && this.canBeLocked((User)user)) {
            UserPreferences userPreferences = this.userAccessor.getUserPreferences(user);
            return userPreferences.getBoolean("com.intenso.jira.plugins.passpolicy:user_account_locked").orElse(false);
        }
        return false;
    }

    @Override
    public List<FormattedLockingAfterDateUserPolicy> getAllLockAfterDatePolicies() {
        ArrayList<FormattedLockingAfterDateUserPolicy> result = new ArrayList<FormattedLockingAfterDateUserPolicy>();
        for (String username : this.userAccessor.getUserNamesWithConfluenceAccess()) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            UserPreferences preferences = this.userAccessor.getUserPreferences(user);
            if (!preferences.getLong(USER_LOCK_AFTER_DATE_KEY).isPresent()) continue;
            FormattedLockingAfterDateUserPolicy tooAdd = new FormattedLockingAfterDateUserPolicy(user, this.userAccessor);
            result.add(tooAdd);
        }
        return result;
    }

    @Override
    public boolean processLockAfterDate(ConfluenceUser user) {
        FormattedLockingAfterDateUserPolicy policy;
        if (this.canLockAccountAfterDate((User)user) && (policy = new FormattedLockingAfterDateUserPolicy(user, this.userAccessor)).shouldLockAccountAfterDate()) {
            policy.lockUser();
        }
        return false;
    }

    @Override
    public void processLockAfterFiledLoginAttempts(ConfluenceUser user) {
        if (this.canLockAccountAfterFiledLoginAttempts((User)user) && this.failedLoginCountExceedsMaximum((User)user)) {
            FormattedLockingAfterDateUserPolicy policy = new FormattedLockingAfterDateUserPolicy(user, this.userAccessor);
            policy.lockUser();
        }
    }

    @Override
    public boolean canLockAccountAfterFiledLoginAttempts(User user) {
        return this.canBeLocked(user) && this.isLockingEnabled() && this.isLockingAfterFiledLoginAttemptsEnabled();
    }

    private boolean canBeLocked(User user) {
        return !this.isUserSystemAdmin(user) && this.isFromInternalDirectory(user);
    }

    private boolean isFromInternalDirectory(User user) {
        return this.userDirectoryService.isUserInInternalDirectory(user);
    }

    private boolean isLockingAfterFiledLoginAttemptsEnabled() {
        return this.pluginConfigurationService.getConfiguration().getUserAccountLockingAfterFailedLoginsEnabled();
    }

    private Integer getCurrentFailedLoginCount(User user) {
        LoginInfo loginInfo = this.loginManager.getLoginInfo(user);
        return loginInfo.getCurrentFailedLoginCount();
    }

    private boolean failedLoginCountExceedsMaximum(User user) {
        Integer maxNumOfAttempts = this.getMaximumFailedLoginCount();
        if (maxNumOfAttempts == null) {
            return false;
        }
        Integer currentFailedLoginCount = this.getCurrentFailedLoginCount(user);
        if (currentFailedLoginCount == null) {
            return false;
        }
        return maxNumOfAttempts <= currentFailedLoginCount;
    }

    private Integer getMaximumFailedLoginCount() {
        return this.pluginConfigurationService.getConfiguration().getNumberOfFailedAttemptsToLockUser();
    }

    static enum LockValue {
        LOCK,
        UNLOCK;

    }
}

