/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.rules;

import com.intenso.confluence.plugins.passpolicy.PasswordMessageResolver;
import edu.vt.middleware.password.CharacterRule;
import edu.vt.middleware.password.DictionaryRule;
import edu.vt.middleware.password.Password;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import java.util.Map;

public class PolicyRule {
    private final Rule rule;
    private final String key;
    private final Map<String, ?> parameters;
    private final PasswordMessageResolver messageResolver;

    public PolicyRule(Rule rule, String key, Map<String, ?> parameters, PasswordMessageResolver messageResolver) {
        this.rule = rule;
        this.key = key;
        this.parameters = parameters;
        this.messageResolver = messageResolver;
    }

    public String getHelpMessage() {
        return this.messageResolver.resolve(this.key, this.parameters);
    }

    public boolean isPasswordValid(String password) {
        RuleResult validate = this.rule.validate(new PasswordData(new Password(password)));
        return validate.isValid();
    }

    public String getKey() {
        return this.key;
    }

    public boolean isCharacterRule() {
        return this.rule instanceof CharacterRule;
    }

    public boolean isDictionaryRule() {
        return this.rule instanceof DictionaryRule;
    }
}

