/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.rest;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.intenso.confluence.plugins.rest.FailedLoginAttemptMessage;
import com.intenso.confluence.plugins.rest.PasswordValidationDTO;
import com.intenso.confluence.plugins.rest.UserLockingPolicyJSON;
import com.intenso.confluence.plugins.service.LockUserAccountService;
import com.intenso.confluence.plugins.service.PasswordExpirationService;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Controller;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/")
@Controller
public class PasswordPolicyResource {
    private final PasswordPolicyService passwordPolicyService;
    private final LockUserAccountService lockUserAccountService;
    private final PasswordExpirationService passwordExpirationService;
    private final PluginConfigurationService pluginConfigurationService;
    private final UserAccessor userAccessor;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @UnrestrictedAccess
    @Path(value="validatePassword")
    public Response validatePassword(PasswordValidationDTO validationDTO) {
        String password = validationDTO.getPassword();
        String username = validationDTO.getUsername();
        Map<String, Boolean> result = this.passwordPolicyService.validatePasswordWithRules(password, username);
        return Response.ok(result).cacheControl(PasswordPolicyResource.never()).build();
    }

    @POST
    @Path(value="lockUserAccount")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response lockUserAccount(@FormParam(value="username") String username) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean isUserLocked = this.lockUserAccountService.lockUserAccount(username);
        result.put("isUserLocked", isUserLocked);
        return Response.ok(result).cacheControl(PasswordPolicyResource.never()).build();
    }

    @POST
    @Path(value="unlockUserAccount")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response unlockUserAccount(@FormParam(value="username") String username) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean isUserLocked = this.lockUserAccountService.unlockUserAccount(username);
        result.put("isUserLocked", isUserLocked);
        return Response.ok(result).cacheControl(PasswordPolicyResource.never()).build();
    }

    @POST
    @Path(value="setExpirationPolicy/user")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response setExpirationPolicyEnabled(@FormParam(value="username") String username, @FormParam(value="enabled") boolean enabled) {
        HashMap result = new HashMap();
        this.passwordExpirationService.setExpirationPolicyEnabledForUser(username, enabled);
        return Response.ok(result).cacheControl(PasswordPolicyResource.never()).build();
    }

    @POST
    @Path(value="setExpirationPolicy/group")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response setExpirationPolicyEnabledForGroup(@FormParam(value="groupName") String groupName, @FormParam(value="enabled") boolean enabled) {
        HashMap result = new HashMap();
        this.passwordExpirationService.update(groupName, (Boolean)enabled);
        return Response.ok(result).cacheControl(PasswordPolicyResource.never()).build();
    }

    public static CacheControl never() {
        CacheControl cacheNever = new CacheControl();
        cacheNever.setNoStore(true);
        cacheNever.setNoCache(true);
        return cacheNever;
    }

    @POST
    @Path(value="updateUserAccountLockAfterDatePolicy")
    @Consumes(value={"application/json"})
    public Response updateUserAccountLockAfterDateRule(UserLockingPolicyJSON lockingPolicyJSON) {
        HashMap<String, String> errors = new HashMap<String, String>();
        this.validateUserName(errors, lockingPolicyJSON.getUsername());
        if (errors.isEmpty()) {
            this.lockUserAccountService.updateUserAccountLockAfterDatePolicy(lockingPolicyJSON.getUsername(), lockingPolicyJSON.getLockDate());
        }
        return Response.ok(errors).build();
    }

    @POST
    @Path(value="removeUserAccountLockAfterDatePolicy")
    @Consumes(value={"application/json"})
    public Response removeUserAccountLockAfterDateRule(UserLockingPolicyJSON lockingPolicyJSON) {
        HashMap<String, String> errors = new HashMap<String, String>();
        this.validateUserName(errors, lockingPolicyJSON.getUsername());
        if (errors.isEmpty()) {
            this.lockUserAccountService.removeUserAccountLockAfterDatePolicy(lockingPolicyJSON.getUsername());
        }
        return Response.ok(errors).build();
    }

    private void validateUserName(Map<String, String> result, String username) {
        String userNameError = this.lockUserAccountService.canSetLockAfterDatePolicy(username);
        if (userNameError.length() > 0) {
            result.put("usernameError", userNameError);
        }
    }

    private void validateLockDate(Map<String, Boolean> result, String date) {
        if (!this.lockUserAccountService.isDateValid(date)) {
            result.put("dateError", true);
        }
    }

    @GET
    @Path(value="failedLoginAttempt")
    @Consumes
    @Produces(value={"application/json"})
    @UnrestrictedAccess
    public Response failedLoginAttempt(@QueryParam(value="username") String username) {
        ConfluenceUser user;
        FailedLoginAttemptMessage result = new FailedLoginAttemptMessage();
        result.setMessage("");
        try {
            user = this.userAccessor.getUserByName(username);
        }
        catch (IllegalStateException e) {
            return Response.ok((Object)result).build();
        }
        this.processLockAfterFailedLoginAttempts(user);
        if (this.lockUserAccountService.isUserLocked(user)) {
            String message = this.pluginConfigurationService.getConfiguration().getUserAccountLockedPageConent();
            result.setMessage(message);
        }
        return Response.ok((Object)result).build();
    }

    private void processLockAfterFailedLoginAttempts(ConfluenceUser user) {
        if (user == null) {
            return;
        }
        if (!this.lockUserAccountService.isUserLocked(user)) {
            this.lockUserAccountService.processLockAfterFiledLoginAttempts(user);
        }
    }

    @Generated
    public PasswordPolicyResource(PasswordPolicyService passwordPolicyService, LockUserAccountService lockUserAccountService, PasswordExpirationService passwordExpirationService, PluginConfigurationService pluginConfigurationService, UserAccessor userAccessor) {
        this.passwordPolicyService = passwordPolicyService;
        this.lockUserAccountService = lockUserAccountService;
        this.passwordExpirationService = passwordExpirationService;
        this.pluginConfigurationService = pluginConfigurationService;
        this.userAccessor = userAccessor;
    }
}

