/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.passpolicy.configuration.rest;

import com.intenso.confluence.plugins.passpolicy.configuration.PasswordPolicyConfigurationService;
import com.intenso.confluence.plugins.passpolicy.configuration.rest.ConfigJsonMessage;
import com.intenso.confluence.plugins.passpolicy.configuration.rest.ConfigJsonResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/config")
public class ConfigurationRestService {
    PasswordPolicyConfigurationService service;

    public ConfigurationRestService(PasswordPolicyConfigurationService service) {
        this.service = service;
    }

    @POST
    @Path(value="/updateConfigValue")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response tryUpdateValue(ConfigJsonMessage config) {
        ConfigJsonResponse result = this.service.validateConfig(config);
        if (result.hasErrors()) {
            return Response.ok((Object)result).build();
        }
        this.service.updateConfig(config);
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/getTranslation/{configId}/{key}")
    public Response getTranslation(@PathParam(value="configId") String configId, @PathParam(value="key") String key) {
        return Response.ok((Object)this.service.getTranslation(configId, key)).build();
    }
}

