/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.passpolicy.configuration.model;

import com.intenso.confluence.plugins.passpolicy.configuration.model.LangTranslation;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LangTranslationHolder {
    private String defaultLanguageKey;
    private List<LangTranslation> translations;

    public List<LangTranslation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(List<LangTranslation> translations) {
        this.translations = translations;
    }

    public String getDefaultLanguageKey() {
        return this.defaultLanguageKey;
    }

    public String getValueForLocale(String locale) {
        if (this.translations != null && locale != null) {
            for (LangTranslation tran : this.translations) {
                if (!tran.getKey().equals(locale)) continue;
                return tran.getTrnaslationValue();
            }
        }
        return null;
    }

    public String getValueForLocale(Locale locale) {
        return this.getValueForLocale(locale.getLanguage() + "_" + locale.getCountry());
    }

    public void setDefaultLanguageKey(String defaultLanguageKey) {
        this.defaultLanguageKey = defaultLanguageKey;
    }

    public static class LangTranslationHolderBuilder {
        LangTranslationHolder ltHolder = new LangTranslationHolder();

        public LangTranslationHolder build() {
            return this.ltHolder;
        }

        public LangTranslationHolderBuilder defaultLanguageKey(String defaultLanguageKey) {
            this.ltHolder.defaultLanguageKey = defaultLanguageKey;
            return this;
        }

        public LangTranslationHolderBuilder addLanguageTransalation(String key, String keyDesc, String translation) {
            if (this.ltHolder.translations == null) {
                this.ltHolder.translations = new ArrayList<LangTranslation>();
            }
            this.ltHolder.translations.add(new LangTranslation(key, keyDesc, translation));
            return this;
        }
    }
}

