/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.passpolicy.configuration;

import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.passpolicy.configuration.PasswordPolicyConfigurationService;
import com.intenso.confluence.plugins.passpolicy.configuration.model.LangTranslationHelper;
import com.intenso.confluence.plugins.passpolicy.configuration.rest.ConfigJsonMessage;
import com.intenso.confluence.plugins.passpolicy.configuration.rest.ConfigJsonResponse;
import com.intenso.confluence.plugins.service.PasswordPolicyPropertiesService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import com.intenso.confluence.plugins.upgrade.util.LocaleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PasswordPolicyConfigurationServiceImpl
implements PasswordPolicyConfigurationService {
    private static final String LANG_SELECT = "Select";
    private static final String GENERAL_GROUP_NAME = "General";
    private static final String RULES_GROUP_NAME = "Password Complexity";
    private static final String EXPIRATION_NOTIFIER_GROUP_NAME = "Expiration Notification";
    private static final String USER_LOCKING_GROUP_NAME = "User Locking";
    public static final String ENABLED_CONFIG_ID = "enabled";
    public static final String ENABLED_EXPIRING_POLICY_BY_DEFAULT_CONFIG_ID = "enabledExpiringPolicyByDefault";
    public static final String MAXIMUM_PASSWORD_AGE_CONFIG_ID = "maximumPasswordAge";
    private static final String PASSWORDS_REMEBMERED_IN_HISTORY_CONFIG_ID = "passwordsRemebmeredInHistory";
    private static final String PASSWORD_CHARACTER_CHARACTERISTICS_ENABLED_CONFIG_ID = "passwordCharacterCharacteristicsEnabled";
    private static final String MIN_PASSWORD_LENGTH_CONFIG_ID = "minPasswordLength";
    private static final String MAX_PASSWORD_LENGTH_CONFIG_ID = "maxPasswordLength";
    private static final String DIGIT_CHARACTER_RULE_CONFIG_ID = "digitCharacterRule";
    private static final String NON_ALPHANUMERIC_CHARACTER_RULE_CONFIG_ID = "nonAlphanumericCharacterRule";
    private static final String UPPERCASE_CHARACTER_RULE_CONFIG_ID = "uppercaseCharacterRule";
    private static final String LOWERCASE_CHARACTER_RULE_CONFIG_ID = "lowercaseCharacterRule";
    private static final String PASSWORDS_LIKE_NAME_ALLOWED_CONFIG_ID = "passwordsLikeNameAllowed";
    private static final String NUMBER_OF_CHARACTERISTICS_CONFIG_ID = "numberOfCharacteristics";
    public static final String LAST_CHANGE_TIME_CONFIG_ID = "lastChangeTime";
    public static final String ADMIN_CAN_SKIP_PASSWORD_CHANGE_CONFIG_ID = "adminCanSkipPasswordChange";
    public static final String PASSWORD_EXPIRATION_NOTIFIER_ENABLED_CONFIG_ID = "passwordExpirationNotifierEnabled";
    public static final String PASSWORD_EXPIRATION_NOTIFIER_DURATION_CONFIG_ID = "passwordExpirationNotifierDuration";
    public static final String PASSWORD_EXPIRATION_NOTIFIER_EMAIL_SUBJECT_CONFIG_ID = "passwordExpirationNotifierEmailSubject";
    public static final String PASSWORD_EXPIRATION_NOTIFIER_EMAIL_BODY_CONFIG_ID = "passwordExpirationNotifierEmailBody";
    public static final String PASSWORD_EXPIRATION_NOTIFIER_EMAIL_FROM_NAME_CONFIG_ID = "passwordExpirationNotifierEmailFromName";
    public static final String LAST_PASSWORD_EXPIRATION_NOTIFIER_EXECUTION_CONFIG_ID = "lastPasswordExpirationNotifierExecution";
    public static final String PASSWORD_EXPIRED_NOTIFIER_EMAIL_SUBJECT_CONFIG_ID = "passwordExpiredNotifierEmailSubject";
    public static final String PASSWORD_EXPIRED_NOTIFIER_EMAIL_BODY_CONFIG_ID = "passwordExpiredNotifierEmailBody";
    public static final String PASSWORD_EXPIRED_NOTIFIER_EMAIL_FROM_NAME_CONFIG_ID = "passwordExpiredNotifierEmailFromName";
    public static final String USER_ACCOUNT_LOCKING_ENABLED_CONFIG_ID = "userAccountLockingEnabled";
    public static final String USER_ACCOUNT_LOCKING_AFTER_PASSWORD_EXPIRATION_ENABLED_CONFIG_ID = "userAccountLockingAfterPasswordExpirationEnabled";
    public static final String DAYS_AFTER_PASSWORD_EXPIRATION_TO_LOCK_USER_ACCOUNT_CONFIG_ID = "daysAfterPasswordExpirationToLockUserAccount";
    public static final String USER_ACCOUNT_LOCKED_PAGE_CONTENT_CONFIG_ID = "userAccountLockedPageConent";
    public static final String EXCLUDED_USER_GROUP_CONFIG_ID = "excludedUserGroup";
    public static final String USER_ACCOUNT_LOCKING_AFTER_FAILED_LOGINS_ENABLED_CONFIG_ID = "userAccountLockingAfterFailedLoginsEnabled";
    public static final String NUMBER_OF_FAILED_ATTEMPTS_TO_LOCK_USER_CONFIG_ID = "numberOfFailedAttemptsToLockUser";
    private static final String MANAGE_POLICIES_LINK_ID = "managePolicies";
    private static final String SHOW_USER_POLICIES_LINK_ID = "userPasswordPolicies";
    private static final String RESET_PASSWORD_AGE_LINK_ID = "resetPasswordAge";
    private Map<String, String> languageList;
    private List<Map<String, String>> configAsList;
    private List<Map<String, String>> groupsWithDescriptionAsList;
    private PluginConfigurationService pluginConfigurationService;
    private PasswordPolicyPropertiesService passwordPolicyPropertiesService;
    private LocaleManager localeManager;
    private LanguageManager languageManager;
    private final PermissionManager permissionManager;

    public PasswordPolicyConfigurationServiceImpl(LanguageManager languageManager, LocaleManager localeManager, PluginConfigurationService pluginConfigurationService, PasswordPolicyPropertiesService passwordPolicyPropertiesService, PermissionManager permissionManager) {
        this.pluginConfigurationService = pluginConfigurationService;
        this.passwordPolicyPropertiesService = passwordPolicyPropertiesService;
        this.localeManager = localeManager;
        this.languageManager = languageManager;
        this.permissionManager = permissionManager;
        this.configAsList = new ArrayList<Map<String, String>>();
        this.languageList = new HashMap<String, String>();
        this.groupsWithDescriptionAsList = new ArrayList<Map<String, String>>();
    }

    private PluginConfiguration getPluginConfiguration() {
        return this.pluginConfigurationService.getConfiguration();
    }

    @Override
    public List<Map<String, String>> getGroupsConfigAsList() {
        this.groupsWithDescriptionAsList.clear();
        this.groupsWithDescriptionAsList.add(this.getGroup(GENERAL_GROUP_NAME, "General Enterprise Password Policy Configuration", "https://deviniti.com/support/addon/server/password-policy-confluence/latest/general/"));
        this.groupsWithDescriptionAsList.add(this.getGroup(RULES_GROUP_NAME, "Set Password Complexity Requirements", "https://deviniti.com/support/addon/server/password-policy-confluence/latest/password-complexity/"));
        this.groupsWithDescriptionAsList.add(this.getGroup(USER_LOCKING_GROUP_NAME, "Set User Locking Rules", "https://deviniti.com/support/addon/server/password-policy-confluence/latest/user-locking/"));
        this.groupsWithDescriptionAsList.add(this.getGroup(EXPIRATION_NOTIFIER_GROUP_NAME, "Password Expiration Notifications Configuration", "https://deviniti.com/support/addon/server/password-policy-confluence/latest/expiration-notifications/"));
        return this.groupsWithDescriptionAsList;
    }

    @Override
    public List<Map<String, String>> getConfigsAsList() {
        this.configAsList.clear();
        this.configAsList.add(this.getEnabledMenuItemAsMap());
        this.configAsList.add(this.getEnabledExpiringPolicyByDefaultMenuItemAsMap());
        if (this.isSystemAdmin()) {
            this.configAsList.add(this.getAdminCanSkipPasswordChangeMenuItemAsMap());
            this.configAsList.add(this.getResetPasswordAgeMenuItemAsMap());
        }
        this.configAsList.add(this.getUserPasswordPoliciesMenuItemAsMap());
        this.configAsList.add(this.getPasswordCharacterCharacteristicsEnabledMenuItemAsMap());
        this.configAsList.add(this.getPasswordsLikeNameAllowedMenuItemAsMap());
        this.configAsList.add(this.getNumberOfCharacteristicsMenuItemAsMap());
        this.configAsList.add(this.getDigitCharacterRuleMenuItemAsMap());
        this.configAsList.add(this.getNonAlphanumericCharacterRuleMenuItemAsMap());
        this.configAsList.add(this.getUppercaseCharacterRuleMenuItemAsMap());
        this.configAsList.add(this.getLowercaseCharacterRuleMenuItemAsMap());
        this.configAsList.add(this.getMaximumPasswordAgeMenuItemAsMap());
        this.configAsList.add(this.getPasswordsRemebmeredInHistoryMenuItemAsMap());
        this.configAsList.add(this.getMinPasswordLengthMenuItemAsMap());
        this.configAsList.add(this.getMaxPasswordLengthMenuItemAsMap());
        this.configAsList.add(this.getUserAccountLockedPageConentMenuItemAsMap());
        this.configAsList.add(this.getUserAccountLockingEnabledMenuItemAsMap());
        this.configAsList.add(this.getUserAccountLockingAfterPasswordExpirationMenuItemAsMap());
        this.configAsList.add(this.getDaysAfterPasswordExpirationToLockUserAccountMenuItemAsMap());
        this.configAsList.add(this.getLockingAfterDateActionMenuItemAsMap());
        this.configAsList.add(this.getUserAccountLockingAfterFailedLoginsEnabledMenuItemAsMap());
        this.configAsList.add(this.getNumberOfFailedAttemptsToLockUserMenuItemAsMap());
        this.configAsList.add(this.getEnablePasswordExpirationNotifierMenuItemAsMap());
        this.configAsList.add(this.getPasswordExpirationNotifierDurationMenuItemAsMap());
        this.configAsList.add(this.getPasswordExpirationNotifierEmailSubjectMenuItemAsMap());
        this.configAsList.add(this.getPasswordExpirationNotifierEmailBodyMenuItemAsMap());
        this.configAsList.add(this.getPasswordExpirationNotifierEmailFromNameMenuItemAsMap());
        this.configAsList.add(this.getPasswordExpiredNotifierEmailSubjectMenuItemAsMap());
        this.configAsList.add(this.getPasswordExpiredNotifierEmailBodyMenuItemAsMap());
        return this.configAsList;
    }

    private boolean isSystemAdmin() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.isSystemAdministrator(confluenceUser);
    }

    private Map<String, String> getEnabledMenuItemAsMap() {
        Map<String, String> result = this.getConfigBooleanElementTemplate();
        result.put("id", ENABLED_CONFIG_ID);
        String value = Boolean.toString(this.getPluginConfiguration().getEnabled());
        result.put("value", value);
        result.put("label", "Enable Enterprise Password Policy");
        result.put("is-required", "false");
        result.put("group-name", GENERAL_GROUP_NAME);
        return result;
    }

    private Map<String, String> getEnabledExpiringPolicyByDefaultMenuItemAsMap() {
        Map<String, String> result = this.getConfigBooleanElementTemplate();
        result.put("id", ENABLED_EXPIRING_POLICY_BY_DEFAULT_CONFIG_ID);
        String value = Boolean.toString(this.getPluginConfiguration().getEnabledExpiringPolicyByDefault());
        result.put("value", value);
        result.put("label", "Enable Enterprise Password Policy by default for new users");
        result.put("is-required", "false");
        result.put("group-name", GENERAL_GROUP_NAME);
        return result;
    }

    private Map<String, String> getAdminCanSkipPasswordChangeMenuItemAsMap() {
        Map<String, String> result = this.getConfigBooleanElementTemplate();
        result.put("id", ADMIN_CAN_SKIP_PASSWORD_CHANGE_CONFIG_ID);
        String value = Boolean.toString(this.getPluginConfiguration().getAdminCanSkipPasswordChange());
        result.put("value", value);
        result.put("label", "Skip admin password change");
        result.put("description", "Confluence System Administrator can skip a password change.");
        result.put("is-required", "false");
        result.put("group-name", GENERAL_GROUP_NAME);
        return result;
    }

    private Map<String, String> getResetPasswordAgeMenuItemAsMap() {
        Map<String, String> result = this.getConfigJiraActionElementTemplate();
        result.put("value", "if (confirm('Reset password age for all users? All users will need to change password on next login.')){location='passwordpolicyconfigurationactionreset.action'}");
        result.put("id", RESET_PASSWORD_AGE_LINK_ID);
        result.put("label", "Reset users password age");
        result.put("is-required", "false");
        result.put("custom-text", "Reset");
        result.put("group-name", GENERAL_GROUP_NAME);
        return result;
    }

    private Map<String, String> getUserPasswordPoliciesMenuItemAsMap() {
        Map<String, String> result = this.getConfigJiraActionLinkElementTemplate();
        result.put("value", "userpasswordpoliciesdefault.action");
        result.put("label", "Show password policies for users and groups");
        result.put("id", SHOW_USER_POLICIES_LINK_ID);
        result.put("custom-text", "Show");
        result.put("is-required", "false");
        result.put("group-name", GENERAL_GROUP_NAME);
        return result;
    }

    private Map<String, String> getMaximumPasswordAgeMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getMaximumPasswordAge().toString();
        result.put("value", value);
        result.put("id", MAXIMUM_PASSWORD_AGE_CONFIG_ID);
        result.put("label", "Maximum password age in days");
        result.put("description", "Number of days a password is valid before the user is required to change it.");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        return result;
    }

    private Map<String, String> getPasswordsRemebmeredInHistoryMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getPasswordsRemebmeredInHistory().toString();
        result.put("value", value);
        result.put("id", PASSWORDS_REMEBMERED_IN_HISTORY_CONFIG_ID);
        result.put("label", "Number of remembered passwords");
        result.put("description", "A new password needs to differ from these previous passwords.");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        return result;
    }

    private Map<String, String> getMinPasswordLengthMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getMinPasswordLength().toString();
        result.put("value", value);
        result.put("id", MIN_PASSWORD_LENGTH_CONFIG_ID);
        result.put("label", "Minimum password length");
        result.put("description", "Minimum number of characters in a password.");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        return result;
    }

    private Map<String, String> getMaxPasswordLengthMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getMaxPasswordLength().toString();
        result.put("value", value);
        result.put("id", MAX_PASSWORD_LENGTH_CONFIG_ID);
        result.put("label", "Maximum password length");
        result.put("description", "Maximum number of characters in a password.");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        return result;
    }

    private Map<String, String> getPasswordCharacterCharacteristicsEnabledMenuItemAsMap() {
        Map<String, String> result = this.getConfigBooleanElementTemplate();
        String valueToDisplay = "true";
        int v = this.getPluginConfiguration().getNumberOfCharacteristics();
        if (v == 0) {
            valueToDisplay = "false";
        }
        result.put("value", valueToDisplay);
        result.put("id", PASSWORD_CHARACTER_CHARACTERISTICS_ENABLED_CONFIG_ID);
        result.put("label", "Enable password character rules");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        return result;
    }

    private Map<String, String> getNumberOfCharacteristicsMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getNumberOfCharacteristics().toString();
        result.put("value", value);
        result.put("id", NUMBER_OF_CHARACTERISTICS_CONFIG_ID);
        result.put("label", "Character types");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        result.put("description", "A password needs to contain at least this number of different character types.");
        return result;
    }

    private Map<String, String> getPasswordsLikeNameAllowedMenuItemAsMap() {
        Map<String, String> result = this.getConfigBooleanElementTemplate();
        String value = this.getPluginConfiguration().getPasswordsLikeNameAllowed().toString();
        result.put("value", value);
        result.put("id", PASSWORDS_LIKE_NAME_ALLOWED_CONFIG_ID);
        result.put("label", "Enable passwords similar to username");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        return result;
    }

    private Map<String, String> getDigitCharacterRuleMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getDigitCharacterRule().toString();
        result.put("value", value);
        result.put("id", DIGIT_CHARACTER_RULE_CONFIG_ID);
        result.put("label", "Digits");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        result.put("description", "A password needs to contain this number of digits. Value 0 disables this rule.");
        return result;
    }

    private Map<String, String> getNonAlphanumericCharacterRuleMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getNonAlphanumericCharacterRule().toString();
        result.put("value", value);
        result.put("id", NON_ALPHANUMERIC_CHARACTER_RULE_CONFIG_ID);
        result.put("label", "Non-alphanumeric characters");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        result.put("description", "A password needs to contain this number of non-alphanumeric characters. Value 0 disables this rule.");
        return result;
    }

    private Map<String, String> getUppercaseCharacterRuleMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getUppercaseCharacterRule().toString();
        result.put("value", value);
        result.put("id", UPPERCASE_CHARACTER_RULE_CONFIG_ID);
        result.put("label", "Uppercase characters");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        result.put("description", "A password needs to contain this number of uppercase characters. Value 0 disables this rule.");
        return result;
    }

    private Map<String, String> getLowercaseCharacterRuleMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getLowercaseCharacterRule().toString();
        result.put("value", value);
        result.put("id", LOWERCASE_CHARACTER_RULE_CONFIG_ID);
        result.put("label", "Lowercase characters");
        result.put("is-required", "false");
        result.put("group-name", RULES_GROUP_NAME);
        result.put("description", "A password needs to contain this number of lowercase characters. Value 0 disables this rule.");
        return result;
    }

    private Map<String, String> getUserAccountLockingEnabledMenuItemAsMap() {
        Map<String, String> result = this.getConfigBooleanElementTemplate();
        String value = this.getPluginConfiguration().getUserAccountLockingEnabled().toString();
        result.put("value", value);
        result.put("id", USER_ACCOUNT_LOCKING_ENABLED_CONFIG_ID);
        result.put("label", "Enable user account locking");
        result.put("is-required", "false");
        result.put("group-name", USER_LOCKING_GROUP_NAME);
        return result;
    }

    private Map<String, String> getUserAccountLockingAfterFailedLoginsEnabledMenuItemAsMap() {
        Map<String, String> result = this.getConfigBooleanElementTemplate();
        String value = this.getPluginConfiguration().getUserAccountLockingAfterFailedLoginsEnabled().toString();
        result.put("value", value);
        result.put("id", USER_ACCOUNT_LOCKING_AFTER_FAILED_LOGINS_ENABLED_CONFIG_ID);
        result.put("label", "Lock user account after failed logins");
        result.put("is-required", "false");
        result.put("group-name", USER_LOCKING_GROUP_NAME);
        return result;
    }

    private Map<String, String> getNumberOfFailedAttemptsToLockUserMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getNumberOfFailedAttemptsToLockUser().toString();
        result.put("value", value);
        result.put("id", NUMBER_OF_FAILED_ATTEMPTS_TO_LOCK_USER_CONFIG_ID);
        result.put("label", "Number of failed logins to lock user");
        result.put("is-required", "false");
        result.put("group-name", USER_LOCKING_GROUP_NAME);
        return result;
    }

    private Map<String, String> getUserAccountLockingAfterPasswordExpirationMenuItemAsMap() {
        Map<String, String> result = this.getConfigBooleanElementTemplate();
        String value = this.getPluginConfiguration().getUserAccountLockingAfterPasswordExpirationEnabled().toString();
        result.put("value", value);
        result.put("id", USER_ACCOUNT_LOCKING_AFTER_PASSWORD_EXPIRATION_ENABLED_CONFIG_ID);
        result.put("label", "Lock user account after password expiration");
        result.put("is-required", "false");
        result.put("group-name", USER_LOCKING_GROUP_NAME);
        return result;
    }

    private Map<String, String> getDaysAfterPasswordExpirationToLockUserAccountMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getDaysAfterPasswordExpirationToLockUserAccount().toString();
        result.put("value", value);
        result.put("id", DAYS_AFTER_PASSWORD_EXPIRATION_TO_LOCK_USER_ACCOUNT_CONFIG_ID);
        result.put("label", "Days for password change after expiration");
        result.put("is-required", "false");
        result.put("group-name", USER_LOCKING_GROUP_NAME);
        result.put("description", "Number of days after password expiration before a user account is locked.");
        return result;
    }

    private Map<String, String> getLockingAfterDateActionMenuItemAsMap() {
        Map<String, String> result = this.getConfigJiraActionLinkElementTemplate();
        result.put("value", "manageuseraccountlockafterdatepolicy.action");
        result.put("label", "Lock user after date policies");
        result.put("id", MANAGE_POLICIES_LINK_ID);
        result.put("custom-text", "Manage policies");
        result.put("is-required", "false");
        result.put("group-name", USER_LOCKING_GROUP_NAME);
        return result;
    }

    private Map<String, String> getUserAccountLockedPageConentMenuItemAsMap() {
        Map<String, String> result = this.getConfigTexAreaElementTemplate();
        result.put("value", this.getPluginConfiguration().getUserAccountLockedPageConent());
        result.put("label", "Locked user account page content");
        result.put("id", USER_ACCOUNT_LOCKED_PAGE_CONTENT_CONFIG_ID);
        result.put("is-required", "false");
        result.put("group-name", USER_LOCKING_GROUP_NAME);
        return result;
    }

    private Map<String, String> getEnablePasswordExpirationNotifierMenuItemAsMap() {
        Map<String, String> result = this.getConfigBooleanElementTemplate();
        result.put("id", PASSWORD_EXPIRATION_NOTIFIER_ENABLED_CONFIG_ID);
        String value = Boolean.toString(this.getPluginConfiguration().getPasswordExpirationNotifierEnabled());
        result.put("value", value);
        result.put("label", "Enable password expiration notifier");
        result.put("is-required", "false");
        result.put("group-name", EXPIRATION_NOTIFIER_GROUP_NAME);
        return result;
    }

    private Map<String, String> getPasswordExpirationNotifierDurationMenuItemAsMap() {
        Map<String, String> result = this.getConfigTextElementTemplate();
        String value = this.getPluginConfiguration().getPasswordExpirationNotifierDuration().toString();
        result.put("value", value);
        result.put("id", PASSWORD_EXPIRATION_NOTIFIER_DURATION_CONFIG_ID);
        result.put("label", "Notification period (days)");
        result.put("is-required", "false");
        result.put("group-name", EXPIRATION_NOTIFIER_GROUP_NAME);
        result.put("description", "Number of days before a password expires, after which a notification is sent.");
        return result;
    }

    private Map<String, String> getPasswordExpirationNotifierEmailSubjectMenuItemAsMap() {
        Map<String, String> result = this.getConfigTexAreaElementTemplate();
        result.put("value", this.getPluginConfiguration().getPasswordExpirationNotifierEmailTemplate().getSubject().getValueForLocale(this.getDefaultLocale()));
        result.put("label", "Subject of a pending password expiration e-mail");
        result.put("id", PASSWORD_EXPIRATION_NOTIFIER_EMAIL_SUBJECT_CONFIG_ID);
        result.put("is-required", "false");
        result.put("group-name", EXPIRATION_NOTIFIER_GROUP_NAME);
        result.put("sub-element-type", "select");
        result.put("sub-element-id", "passwordExpirationNotifierEmailSubjectSelect");
        result.put("sub-element-options-id", "language-settings");
        result.put("sub-element-user-locale", this.getDefaultLocale());
        return result;
    }

    private Map<String, String> getPasswordExpirationNotifierEmailBodyMenuItemAsMap() {
        Map<String, String> result = this.getConfigTexAreaElementTemplate();
        result.put("value", this.getPluginConfiguration().getPasswordExpirationNotifierEmailTemplate().getBody().getValueForLocale(this.getDefaultLocale()));
        result.put("label", "Body of a pending password expiration e-mail");
        result.put("id", PASSWORD_EXPIRATION_NOTIFIER_EMAIL_BODY_CONFIG_ID);
        result.put("is-required", "false");
        result.put("group-name", EXPIRATION_NOTIFIER_GROUP_NAME);
        result.put("sub-element-type", "select");
        result.put("sub-element-id", "passwordExpirationNotifierEmailBodySelect");
        result.put("sub-element-options-id", "language-settings");
        result.put("sub-element-user-locale", this.getDefaultLocale());
        return result;
    }

    private Map<String, String> getPasswordExpirationNotifierEmailFromNameMenuItemAsMap() {
        Map<String, String> result = this.getConfigTexAreaElementTemplate();
        result.put("value", this.getPluginConfiguration().getPasswordExpirationNotifierEmailTemplate().getFromName().getValueForLocale(this.getDefaultLocale()));
        result.put("label", "From field of a pending password expiration e-mail");
        result.put("id", PASSWORD_EXPIRATION_NOTIFIER_EMAIL_FROM_NAME_CONFIG_ID);
        result.put("is-required", "false");
        result.put("group-name", EXPIRATION_NOTIFIER_GROUP_NAME);
        result.put("sub-element-type", "select");
        result.put("sub-element-id", "passwordExpirationNotifierEmailFromNameSelect");
        result.put("sub-element-options-id", "language-settings");
        result.put("sub-element-user-locale", this.getDefaultLocale());
        return result;
    }

    private Map<String, String> getPasswordExpiredNotifierEmailSubjectMenuItemAsMap() {
        Map<String, String> result = this.getConfigTexAreaElementTemplate();
        result.put("value", this.getPluginConfiguration().getPasswordExpiredNotifierEmailTemplate().getSubject().getValueForLocale(this.getDefaultLocale()));
        result.put("label", "Subject of a password expired e-mail");
        result.put("id", PASSWORD_EXPIRED_NOTIFIER_EMAIL_SUBJECT_CONFIG_ID);
        result.put("is-required", "false");
        result.put("group-name", EXPIRATION_NOTIFIER_GROUP_NAME);
        result.put("sub-element-type", "select");
        result.put("sub-element-id", "passwordExpiredNotifierEmailSubjectSelect");
        result.put("sub-element-options-id", "language-settings");
        result.put("sub-element-user-locale", this.getDefaultLocale());
        return result;
    }

    private String getDefaultLocale() {
        return this.localeManager.getSiteDefaultLocale().getLanguage() + "_" + this.localeManager.getSiteDefaultLocale().getCountry();
    }

    @Override
    public Map<String, String> getLanguageList() {
        Locale defaultLocale = this.localeManager.getSiteDefaultLocale();
        for (Language language : this.languageManager.getLanguages()) {
            this.languageList.put(LocaleUtil.buildKey(language.getLocale()), this.buildDescription(defaultLocale, language.getLocale()));
        }
        return this.languageList;
    }

    private String buildDescription(Locale defaultLocale, Locale locale) {
        return locale.getDisplayLanguage(defaultLocale) + " (" + locale.getCountry() + ")" + (locale.getLanguage().equals(defaultLocale.getLanguage()) && locale.getCountry().equals(defaultLocale.getCountry()) ? " [default]" : "");
    }

    private Map<String, String> getPasswordExpiredNotifierEmailBodyMenuItemAsMap() {
        Map<String, String> result = this.getConfigTexAreaElementTemplate();
        result.put("value", this.getPluginConfiguration().getPasswordExpiredNotifierEmailTemplate().getBody().getValueForLocale(this.getDefaultLocale()));
        result.put("label", "Body of a password expired e-mail");
        result.put("id", PASSWORD_EXPIRED_NOTIFIER_EMAIL_BODY_CONFIG_ID);
        result.put("is-required", "false");
        result.put("group-name", EXPIRATION_NOTIFIER_GROUP_NAME);
        result.put("sub-element-type", "select");
        result.put("sub-element-id", "passwordExpiredNotifierEmailBodySelect");
        result.put("sub-element-options-id", "language-settings");
        result.put("sub-element-user-locale", this.getDefaultLocale());
        return result;
    }

    private Map<String, String> getConfigTextElementTemplate() {
        Map<String, String> result = this.getConfigElementTemplate();
        result.put("type", "text");
        result.put("id", "");
        result.put("is-unlimited", "false");
        return result;
    }

    private Map<String, String> getConfigJiraActionLinkElementTemplate() {
        Map<String, String> result = this.getConfigElementTemplate();
        result.put("type", "jira-action-new-tab");
        result.put("id", "");
        result.put("custom-text", "");
        result.put("group-name", "Other actions");
        return result;
    }

    private Map<String, String> getConfigJiraActionElementTemplate() {
        Map<String, String> result = this.getConfigElementTemplate();
        result.put("type", "jira-action");
        result.put("id", "");
        result.put("custom-text", "");
        result.put("group-name", "Other actions");
        return result;
    }

    private Map<String, String> getConfigTexAreaElementTemplate() {
        Map<String, String> result = this.getConfigElementTemplate();
        result.put("type", "text-area");
        result.put("id", "");
        result.put("custom-text", "");
        result.put("group-name", "Other actions");
        return result;
    }

    private Map<String, String> getGroupConfigTemplate() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("group-name", "");
        result.put("description", "");
        return result;
    }

    private Map<String, String> getConfigElementTemplate() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("type", "");
        result.put("value", "");
        result.put("id", "");
        result.put("label", "");
        result.put("group-name", GENERAL_GROUP_NAME);
        result.put("is-required", "false");
        result.put("description", "");
        result.put("error-message", "");
        result.put("is-unlimited", "false");
        return result;
    }

    private Map<String, String> getGroup(String groupName, String description, String linkToDoc) {
        Map<String, String> result = this.getGroupConfigTemplate();
        result.put("group-name", groupName);
        result.put("description", description);
        result.put("linkToDoc", linkToDoc);
        return result;
    }

    private Map<String, String> getConfigBooleanElementTemplate() {
        Map<String, String> result = this.getConfigElementTemplate();
        result.put("type", "boolean");
        result.put("id", "");
        return result;
    }

    @Override
    public void updateConfig(ConfigJsonMessage config) {
        String type = config.getType();
        if (type.equals("text-area-translation")) {
            this.tryUpdateTransaltionConfig(config);
        } else if (type.equals("text") || type.equals("text-area")) {
            this.tryUpdateTextConfig(config);
        } else if (type.equals("boolean")) {
            this.tryUpdateBooleanConfig(config);
        } else if (type.equals("select")) {
            this.tryUpdateSelectConfig(config);
        }
    }

    private void tryUpdateTransaltionConfig(ConfigJsonMessage config) {
        this.passwordPolicyPropertiesService.setPropertyValue(config.getConfigId(), LangTranslationHelper.updateJson(this.passwordPolicyPropertiesService.getProperty(config.getConfigId()).getValue(), config.getUpdatedKey(), config.getNewValue()));
    }

    private void tryUpdateSelectConfig(ConfigJsonMessage config) {
    }

    private void tryUpdateBooleanConfig(ConfigJsonMessage config) {
        if (PASSWORD_CHARACTER_CHARACTERISTICS_ENABLED_CONFIG_ID.equals(config.getConfigId())) {
            Boolean chboxValue = Boolean.parseBoolean(config.getNewValue());
            if (chboxValue.booleanValue()) {
                this.passwordPolicyPropertiesService.setPropertyValue(NUMBER_OF_CHARACTERISTICS_CONFIG_ID, "3");
            } else {
                this.passwordPolicyPropertiesService.setPropertyValue(NUMBER_OF_CHARACTERISTICS_CONFIG_ID, "0");
            }
            return;
        }
        this.passwordPolicyPropertiesService.setPropertyValue(config.getConfigId(), config.getNewValue());
    }

    private void tryUpdateTextConfig(ConfigJsonMessage config) {
        this.passwordPolicyPropertiesService.setPropertyValue(config.getConfigId(), config.getNewValue());
    }

    @Override
    public ConfigJsonResponse validateConfig(ConfigJsonMessage config) {
        String type = config.getType();
        if (type.equals("text")) {
            return this.validateTextConfig(config);
        }
        if (type.equals("boolean")) {
            return this.validateBooleanConfig(config);
        }
        if (type.equals("select")) {
            return this.validateSelectConfig(config);
        }
        ConfigJsonResponse response = new ConfigJsonResponse();
        return response;
    }

    private ConfigJsonResponse validateSelectConfig(ConfigJsonMessage config) {
        return null;
    }

    private ConfigJsonResponse validateBooleanConfig(ConfigJsonMessage config) {
        ConfigJsonResponse response = new ConfigJsonResponse();
        String cId = config.getConfigId();
        if (cId.equals(PASSWORD_EXPIRATION_NOTIFIER_ENABLED_CONFIG_ID)) {
            Integer maxPasswordAge = this.getPluginConfiguration().getMaximumPasswordAge();
            Boolean newValue = Boolean.parseBoolean(config.getNewValue());
            if (newValue.booleanValue() && maxPasswordAge != null && maxPasswordAge == 0) {
                response.addError("To enable notifier maximum password age must be greater than 0");
            }
        } else if (cId.equals(USER_ACCOUNT_LOCKING_AFTER_PASSWORD_EXPIRATION_ENABLED_CONFIG_ID)) {
            Boolean newValue = Boolean.parseBoolean(config.getNewValue());
            Boolean isUserAccountLockingEnabled = this.getPluginConfiguration().getUserAccountLockingEnabled();
            if (newValue.booleanValue() && !isUserAccountLockingEnabled.booleanValue()) {
                response.addError("User account locking have to be enabled");
            }
        }
        return response;
    }

    private ConfigJsonResponse validateTextConfig(ConfigJsonMessage config) {
        ConfigJsonResponse response = new ConfigJsonResponse();
        int MAX_PASSWORD_LENGTH = 255;
        String cId = config.getConfigId();
        boolean isValueValid = true;
        if (cId.equals(MIN_PASSWORD_LENGTH_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 6, 255);
            if (isValueValid) {
                Integer newMin = Integer.parseInt(config.getNewValue());
                Integer max = this.getPluginConfiguration().getMaxPasswordLength();
                if (max < newMin) {
                    response.addError("Minimum password length can't be greater than maximum");
                }
            }
        } else if (cId.equals(MAX_PASSWORD_LENGTH_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 6, 255);
            if (isValueValid) {
                Integer newMax = Integer.parseInt(config.getNewValue());
                Integer min2 = this.getPluginConfiguration().getMinPasswordLength();
                if (min2 > newMax) {
                    response.addError("Maximum password length can't be greater than minimum");
                }
            }
        } else if (cId.equals(DIGIT_CHARACTER_RULE_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 0, 255);
        } else if (cId.equals(NON_ALPHANUMERIC_CHARACTER_RULE_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 0, 255);
        } else if (cId.equals(UPPERCASE_CHARACTER_RULE_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 0, 255);
        } else if (cId.equals(LOWERCASE_CHARACTER_RULE_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 0, 255);
        } else if (cId.equals(NUMBER_OF_CHARACTERISTICS_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 1, 4);
        } else if (cId.equals(DAYS_AFTER_PASSWORD_EXPIRATION_TO_LOCK_USER_ACCOUNT_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 0, 1000);
        } else if (cId.equals(PASSWORD_EXPIRATION_NOTIFIER_DURATION_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 1, 31);
        } else if (cId.equals(PASSWORD_EXPIRATION_NOTIFIER_DURATION_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 1, 31);
        } else if (cId.equals(MAXIMUM_PASSWORD_AGE_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 0, 365);
        } else if (cId.equals(NUMBER_OF_FAILED_ATTEMPTS_TO_LOCK_USER_CONFIG_ID)) {
            isValueValid = this.validateNumericAndRange(config.getNewValue(), 1, Integer.MAX_VALUE);
        }
        if (!isValueValid) {
            response.addError("Not valid value");
            return response;
        }
        if (cId.equals(PASSWORD_EXPIRATION_NOTIFIER_EMAIL_SUBJECT_CONFIG_ID) || cId.equals(PASSWORD_EXPIRED_NOTIFIER_EMAIL_SUBJECT_CONFIG_ID)) {
            if (StringUtils.isBlank((CharSequence)config.getNewValue())) {
                response.addError("Email subject is required");
            } else if (config.getNewValue().length() > 250) {
                response.addError("Subject can't be longer than 250 characters");
            }
            return response;
        }
        if (cId.equals(PASSWORD_EXPIRATION_NOTIFIER_EMAIL_FROM_NAME_CONFIG_ID)) {
            if (StringUtils.isBlank((CharSequence)config.getNewValue())) {
                response.addError("Email from is required");
            } else if (config.getNewValue().length() > 250) {
                response.addError("From name can't be longer than 250 characters");
            }
            return response;
        }
        return response;
    }

    private boolean validateNumericAndRange(String value, Integer min2, Integer max) {
        Integer intValue;
        if (StringUtils.isBlank((CharSequence)value) || !StringUtils.isNumeric((CharSequence)value) || !this.isValidInteger(value)) {
            return false;
        }
        return min2 == null || max == null || (intValue = Integer.valueOf(Integer.parseInt(value))) >= min2 && intValue <= max;
    }

    private boolean isValidInteger(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public String getTranslation(String configId, String key) {
        return LangTranslationHelper.getValue(this.passwordPolicyPropertiesService.getProperty(configId).getValue(), key);
    }

    public void setLanguageList(Map<String, String> languageList) {
        this.languageList = languageList;
    }
}

