/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.passpolicy.configuration;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.intenso.confluence.plugins.passpolicy.configuration.PasswordPolicyConfigurationService;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import com.intenso.confluence.plugins.service.UserDirectoryService;
import com.intenso.confluence.plugins.utils.LicenseUtils;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PasswordPolicyConfigurationAction
extends ConfluenceActionSupport {
    private final PasswordPolicyConfigurationService service;
    private final PasswordPolicyService passwordPolicyService;
    private final PluginLicenseManager licenseManager;
    private final UserDirectoryService userDirectoryService;
    private final PluginConfigurationService pluginConfigurationService;

    @PermittedMethods(value={HttpMethod.GET})
    public List<Map<String, String>> getConfigsAsList() {
        return this.service.getConfigsAsList();
    }

    @PermittedMethods(value={HttpMethod.GET})
    public List<Map<String, String>> getGroups() {
        return this.service.getGroupsConfigAsList();
    }

    @PermittedMethods(value={HttpMethod.GET})
    public Map<String, String> getLanguageList() {
        return this.service.getLanguageList();
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        return "input";
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doResetPasswordAge() throws Exception {
        this.passwordPolicyService.resetPasswordAge();
        return this.execute();
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String getLicenseError() {
        String errorMsg = LicenseUtils.checkLicense(this.licenseManager);
        if (errorMsg != null) {
            return errorMsg;
        }
        return null;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public boolean getExternalDirectoryDefined() {
        return this.userDirectoryService.isExternalDefined();
    }

    @PermittedMethods(value={HttpMethod.GET})
    public boolean getPasswordPolicyEnabled() {
        return this.pluginConfigurationService.pluginEnabled();
    }

    @PermittedMethods(value={HttpMethod.GET})
    public PasswordPolicyConfigurationService getService() {
        return this.service;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public PasswordPolicyService getPasswordPolicyService() {
        return this.passwordPolicyService;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public PluginLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public Map getErrors() {
        return this.getFieldErrors();
    }

    @Generated
    public PasswordPolicyConfigurationAction(PasswordPolicyConfigurationService service, PasswordPolicyService passwordPolicyService, PluginLicenseManager licenseManager, UserDirectoryService userDirectoryService, PluginConfigurationService pluginConfigurationService) {
        this.service = service;
        this.passwordPolicyService = passwordPolicyService;
        this.licenseManager = licenseManager;
        this.userDirectoryService = userDirectoryService;
        this.pluginConfigurationService = pluginConfigurationService;
    }
}

