/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.passpolicy;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.User;
import com.intenso.confluence.plugins.service.LockUserAccountService;
import com.intenso.confluence.plugins.service.PasswordExpirationService;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import com.intenso.confluence.plugins.service.UserDirectoryService;
import com.intenso.confluence.plugins.utils.LicenseUtils;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@UnrestrictedAccess
@Component
public class PasswordPolicyFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(PasswordPolicyFilter.class);
    private static final String LAST_INSPECTION_DATE_OF_PASSWORD_AGE = "com.intenso.confluence.plugins.passpolicy.passwordPolicyFilter:lastInspectionDateOfPasswordAge";
    private final UserManager userManager;
    private final LoginManager loginManager;
    private final PluginConfigurationService pluginConfigurationService;
    private final PasswordPolicyService passwordPolicyService;
    private final PluginLicenseManager licenseManager;
    private final PasswordExpirationService passwordExpirationService;
    private final LockUserAccountService lockUserAccountService;
    private final UserDirectoryService userDirectoryService;
    private final Set<String> notRedirectedUrls = new HashSet<String>(Arrays.asList("useraccountlockeddefault.action", "logout.action"));

    public PasswordPolicyFilter(UserManager userManager, LoginManager loginManager, PluginConfigurationService pluginConfigurationService, PasswordPolicyService passwordPolicyService, PluginLicenseManager licenseManager, PasswordExpirationService passwordExpirationService, LockUserAccountService lockUserAccountService, UserDirectoryService userDirectoryService) {
        this.userManager = userManager;
        this.loginManager = loginManager;
        this.pluginConfigurationService = pluginConfigurationService;
        this.passwordPolicyService = passwordPolicyService;
        this.licenseManager = licenseManager;
        this.passwordExpirationService = passwordExpirationService;
        this.lockUserAccountService = lockUserAccountService;
        this.userDirectoryService = userDirectoryService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean redirected = false;
        try {
            boolean pluginValid;
            boolean bl = pluginValid = this.pluginConfigurationService.pluginEnabled() && LicenseUtils.isValid(this.licenseManager);
            if (pluginValid && !this.isIgnoredUrl((HttpServletRequest)request)) {
                String userName;
                UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
                ConfluenceUser loggedInUser = userAccessor.getUserByName(userName = (String)Optional.ofNullable(this.userManager.getRemoteUser((HttpServletRequest)request)).map(UserProfile::getUsername).orElse(null));
                boolean canRedirectUser = this.userDirectoryService.isUserInInternalDirectory((User)loggedInUser);
                if (canRedirectUser) {
                    redirected = this.processRequest((HttpServletRequest)request, (HttpServletResponse)response, loggedInUser);
                }
                if (!redirected) {
                    redirected = this.redirectStandardResetPassword((HttpServletRequest)request, (HttpServletResponse)response);
                }
            }
            if (!redirected) {
                chain.doFilter(request, response);
            }
        }
        catch (Exception ex) {
            log.error("Filter exception", (Throwable)ex);
            chain.doFilter(request, response);
        }
    }

    private boolean processRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ConfluenceUser loggedInUser) throws IOException {
        boolean redirected = this.redirectLockedUser(servletRequest, servletResponse, loggedInUser);
        this.processLockAfterDate(loggedInUser);
        if (!redirected) {
            redirected = this.redirectOnPasswordAgeExpiration(servletRequest, servletResponse, loggedInUser);
        }
        if (!redirected) {
            redirected = this.redirectStandardChangePassword(servletRequest, servletResponse, (User)loggedInUser);
        }
        if (!redirected) {
            redirected = this.redirectStandardSetUserPassword(servletRequest, servletResponse);
        }
        return redirected;
    }

    private void processLockAfterDate(ConfluenceUser loggedInUser) {
        if (loggedInUser == null) {
            return;
        }
        if (!this.lockUserAccountService.isUserLocked(loggedInUser)) {
            this.lockUserAccountService.processLockAfterDate(loggedInUser);
        }
    }

    private String getChangePasswordUrl(HttpServletRequest servletRequest, User loggedInUser) {
        return servletRequest.getContextPath() + "/users/changeuserpassworddefault.action";
    }

    private boolean isIgnoredUrl(HttpServletRequest servletRequest) {
        String requestURI = servletRequest.getRequestURI();
        for (String url : this.notRedirectedUrls) {
            if (!requestURI.contains(url)) continue;
            return true;
        }
        return false;
    }

    private boolean redirectLockedUser(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ConfluenceUser loggedInUser) throws IOException {
        if (this.lockUserAccountService.isUserLocked(loggedInUser)) {
            String redirectUrl = servletRequest.getContextPath() + "/users/useraccountlockeddefault.action";
            servletResponse.sendRedirect(redirectUrl);
            return true;
        }
        return false;
    }

    private boolean redirectStandardResetPassword(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String requestURI = servletRequest.getRequestURI();
        if (requestURI.contains("resetuserpassword.action")) {
            String redirectUrl = servletRequest.getContextPath() + "/users/resetuserpassworddefault.action?token=" + servletRequest.getParameter("token") + "&username=" + servletRequest.getParameter("username");
            servletResponse.sendRedirect(redirectUrl);
            return true;
        }
        return false;
    }

    private boolean redirectOnPasswordAgeExpiration(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ConfluenceUser loggedInUser) throws IOException {
        String requestURI = servletRequest.getRequestURI();
        if (!requestURI.contains("logout.action") && !requestURI.contains("changeuserpassword") && !requestURI.contains("skipchangepassword.action") && this.inspectPasswordAge(servletRequest)) {
            if (this.canRedirectUserToChangePassword((User)loggedInUser) && this.passwordPolicyService.hasUserPasswordExpired(loggedInUser) && this.passwordExpirationService.isExpirationPolicyGloballyEnabled(loggedInUser)) {
                String destination = this.getDestination(servletRequest);
                Object redirectUrl = this.getChangePasswordUrl(servletRequest, (User)loggedInUser);
                if (StringUtils.isNotBlank((CharSequence)destination)) {
                    redirectUrl = (String)redirectUrl + "&destination=" + URLEncoder.encode(destination, "UTF-8");
                }
                servletResponse.sendRedirect((String)redirectUrl);
                servletRequest.getSession().setAttribute("confluence-passport-policy-filterRedirected-userPasswordExpired", (Object)true);
                return true;
            }
            servletRequest.getSession().setAttribute(LAST_INSPECTION_DATE_OF_PASSWORD_AGE, (Object)new Date());
        }
        return false;
    }

    private boolean inspectPasswordAge(HttpServletRequest servletRequest) {
        Date lastInspectionDate = (Date)servletRequest.getSession().getAttribute(LAST_INSPECTION_DATE_OF_PASSWORD_AGE);
        if (lastInspectionDate != null) {
            Minutes minutesBetween = Minutes.minutesBetween(new DateTime(lastInspectionDate), new DateTime());
            return minutesBetween.getMinutes() >= 60;
        }
        return true;
    }

    private boolean canRedirectUserToChangePassword(User loggedInUser) {
        LoginInfo loginInfo = this.loginManager.getLoginInfo(loggedInUser.getName());
        return loginInfo.getLastSuccessfulLoginDate() == null || loginInfo.getLastSuccessfulLoginDate().getTime() > this.pluginConfigurationService.getLastConfigChangeTime();
    }

    private String getDestination(HttpServletRequest servletRequest) {
        Object destination = null;
        String forwardUri = (String)servletRequest.getAttribute("javax.servlet.forward.request_uri");
        String forwardQuery = (String)servletRequest.getAttribute("javax.servlet.forward.query_string");
        if (StringUtils.isNotBlank((CharSequence)forwardUri)) {
            destination = forwardUri;
            if (StringUtils.isNotBlank((CharSequence)forwardQuery)) {
                destination = (String)destination + "?" + forwardQuery;
            }
        }
        return destination;
    }

    private boolean redirectStandardChangePassword(HttpServletRequest servletRequest, HttpServletResponse servletResponse, User loggedInUser) throws IOException {
        String requestURI = servletRequest.getRequestURI();
        if (requestURI.contains("changemypassword.action")) {
            boolean isDialogDecorator = "dialog".equals(servletRequest.getParameter("decorator"));
            Object redirectUrl = this.getChangePasswordUrl(servletRequest, loggedInUser);
            if (isDialogDecorator) {
                redirectUrl = (String)redirectUrl + "&inline=true&decorator=dialog";
            }
            servletResponse.sendRedirect((String)redirectUrl);
            return true;
        }
        return false;
    }

    private boolean redirectStandardSetUserPassword(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (servletRequest.getRequestURI().contains("setuserpassword.action")) {
            String redirectUrl = servletRequest.getContextPath() + "/admin/users/setuserpassworddefault.action?username=" + servletRequest.getParameter("username") + "&inline=true&decorator=dialog&atl_token=" + servletRequest.getParameter("atl_token");
            servletResponse.sendRedirect(redirectUrl);
            return true;
        }
        return false;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }
}

