/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.passpolicy;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.spring.container.ContainerManager;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.passpolicy.UserPasswordPolicy;
import com.intenso.confluence.plugins.utils.UserPreferencesUtils;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.Hours;

public class LazyUserPasswordPolicy
implements UserPasswordPolicy {
    private final ConfluenceUser user;
    private final PluginConfiguration configuration;
    private final UserPreferences userPreferences;
    private final DateTime lastPasswordChangeDateTime;
    private Integer passwordAgeInHours;
    private Integer hoursToPasswordExpiration;
    private Boolean passwordExpired;
    private Date lastPasswordExpiredNotificationSendDate;
    private Date lastPasswordExpirationNotificationSendDate;
    private Integer maximumPasswordAgeInHours;
    private Integer hoursAfterPasswordExpirationDate;
    private DateTime passwordExpirationDateTime;
    private Boolean userAccountLocked;
    private Boolean expiringPasswordPolicyEnabled;
    private DateTime dateTimeOfLockingUserAccount;
    private Boolean isSysAdmin;
    private Boolean isUserAccountUnlockedManually;
    private boolean isUserInternal;

    public LazyUserPasswordPolicy(ConfluenceUser user, UserPreferences userPreferences, PluginConfiguration configuration, boolean isUserInternal) {
        this.user = user;
        this.configuration = configuration;
        this.userPreferences = userPreferences;
        this.isUserInternal = isUserInternal;
        Date lastPasswordChangeDate = UserPreferencesUtils.getDate("last_password_changed_date_property", userPreferences);
        this.lastPasswordChangeDateTime = lastPasswordChangeDate != null ? new DateTime(lastPasswordChangeDate) : null;
        this.expiringPasswordPolicyEnabled = userPreferences.getBoolean("com.intenso.jira.plugins.passpolicy:expiring-policy-enabled").orElse(false);
    }

    @Override
    public ConfluenceUser getUser() {
        return this.user;
    }

    @Override
    public DateTime getLastPasswordChangeDateTime() {
        return this.lastPasswordChangeDateTime;
    }

    @Override
    public Date getLastPasswordExpiredNotificationSendDate() {
        if (this.lastPasswordExpiredNotificationSendDate == null) {
            this.lastPasswordExpiredNotificationSendDate = UserPreferencesUtils.getDate("last_password_expired_notification_send_date", this.userPreferences);
        }
        return this.lastPasswordExpiredNotificationSendDate;
    }

    @Override
    public Date getLastPasswordExpirationNotificationSendDate() {
        if (this.lastPasswordExpirationNotificationSendDate == null) {
            this.lastPasswordExpirationNotificationSendDate = UserPreferencesUtils.getDate("last_password_expiration_notification_send_date", this.userPreferences);
        }
        return this.lastPasswordExpirationNotificationSendDate;
    }

    @Override
    public Integer getPasswordAgeInHours() {
        if (this.passwordAgeInHours == null) {
            DateTime nowDateTime = new DateTime();
            Integer maximumPasswordAgeInHours = this.getMaximumPasswordAgeInHours();
            this.passwordAgeInHours = this.lastPasswordChangeDateTime != null ? Hours.hoursBetween(this.lastPasswordChangeDateTime, nowDateTime).getHours() : Hours.hours(maximumPasswordAgeInHours).getHours();
        }
        return this.passwordAgeInHours;
    }

    private Integer getMaximumPasswordAgeInHours() {
        if (this.maximumPasswordAgeInHours == null) {
            this.maximumPasswordAgeInHours = this.configuration.getMaximumPasswordAge() * 24;
        }
        return this.maximumPasswordAgeInHours;
    }

    @Override
    public Integer getHoursToPasswordExpiration() {
        this.hoursToPasswordExpiration = this.getMaximumPasswordAgeInHours() - this.getPasswordAgeInHours();
        return this.hoursToPasswordExpiration;
    }

    @Override
    public boolean isPasswordExpired() {
        if (this.passwordExpired == null) {
            this.passwordExpired = this.lastPasswordChangeDateTime == null || this.getPasswordAgeInHours() > this.getMaximumPasswordAgeInHours();
        }
        return this.passwordExpired;
    }

    @Override
    public boolean isUserAccountLocked() {
        if (this.userAccountLocked == null) {
            this.userAccountLocked = this.userPreferences.getBoolean("com.intenso.jira.plugins.passpolicy:user_account_locked").orElse(false);
        }
        return this.userAccountLocked;
    }

    @Override
    public DateTime getDateTimeOfLockingUserAccount() {
        Date date;
        if (this.dateTimeOfLockingUserAccount == null && (date = UserPreferencesUtils.getDate("com.intenso.jira.plugins.passpolicy:date_of_user_locking_user_account", this.userPreferences)) != null) {
            this.dateTimeOfLockingUserAccount = new DateTime(date);
        }
        return this.dateTimeOfLockingUserAccount;
    }

    @Override
    public Integer getHoursAfterPasswordExpirationDate() {
        DateTime localPasswordExpirationDateTime = this.getPasswordExpirationDateTime();
        if (localPasswordExpirationDateTime != null) {
            this.hoursAfterPasswordExpirationDate = Hours.hoursBetween(localPasswordExpirationDateTime, new DateTime()).getHours();
        }
        return this.hoursAfterPasswordExpirationDate;
    }

    @Override
    public DateTime getPasswordExpirationDateTime() {
        if (this.passwordExpirationDateTime == null && this.lastPasswordChangeDateTime != null) {
            this.passwordExpirationDateTime = this.lastPasswordChangeDateTime != null ? this.lastPasswordChangeDateTime.plusDays(this.configuration.getMaximumPasswordAge()) : null;
        }
        return this.passwordExpirationDateTime;
    }

    @Override
    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    @Override
    public boolean getIsSysAdmin() {
        if (this.isSysAdmin == null) {
            PermissionManager permissionManager = (PermissionManager)ContainerManager.getInstance().getContainerContext().getComponent((Object)"permissionManager");
            this.isSysAdmin = permissionManager.isSystemAdministrator(this.user);
        }
        return this.isSysAdmin;
    }

    @Override
    public boolean getIsUserAccountUnlockedManually() {
        if (this.isUserAccountUnlockedManually == null) {
            this.isUserAccountUnlockedManually = this.userPreferences.getBoolean("com.intenso.jira.plugins.passpolicy:user_account_unlocked_manually").orElse(false);
        }
        return this.isUserAccountUnlockedManually;
    }

    @Override
    public boolean isExpiringPasswordPolicyEnabled() {
        return this.expiringPasswordPolicyEnabled;
    }

    @Override
    public boolean isUserInternal() {
        return this.isUserInternal;
    }
}

