/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.passpolicy;

import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.user.ConfluenceUser;
import com.intenso.confluence.plugins.action.FormatedUserPasswordPolicy;
import com.intenso.confluence.plugins.passpolicy.configuration.model.LangTranslationHolder;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;

public class EmailTemplate {
    private static final String userName = "$userName";
    private static final String userFullName = "$userFullName";
    private static final String expirationDateTime = "$expirationDateTime";
    private static final String expirationDays = "$expirationDays";
    private static final String expirationHours = "$expirationHours";
    private static final String changePasswordUrl = "$changePasswordUrl";
    private LangTranslationHolder fromName;
    private LangTranslationHolder subject;
    private LangTranslationHolder body;

    public String evaluateBody(FormatedUserPasswordPolicy userPasswordPolicy, String baseUrl, DateTimeFormatter dateTimeFormatter, Locale locale) {
        ConfluenceUser user = userPasswordPolicy.getUser();
        DateTime expirationDate = userPasswordPolicy.getNotifierData().getExpirationDate();
        DateTimeFormatter formatter = dateTimeFormatter;
        String bodyResult = this.body.getValueForLocale(locale).replace(userName, user.getName()).replace(userFullName, user.getFullName());
        bodyResult = bodyResult.replace(expirationDateTime, expirationDate != null ? formatter.print(expirationDate) : "n/a");
        bodyResult = bodyResult.replace(expirationHours, String.valueOf(userPasswordPolicy.getNotifierData().getHoursToPasswordExpiration()));
        bodyResult = bodyResult.replace(expirationDays, String.valueOf(userPasswordPolicy.getNotifierData().getDaysToPasswordExpiration()));
        bodyResult = bodyResult.replace(changePasswordUrl, baseUrl + "/users/changeuserpassworddefault.action");
        return bodyResult;
    }

    public String evaluateBody(FormatedUserPasswordPolicy userPasswordPolicy, String baseUrl, DateFormatter formatter, Locale userLocale) {
        ConfluenceUser user = userPasswordPolicy.getUser();
        DateTime expirationDate = userPasswordPolicy.getNotifierData().getExpirationDate();
        String bodyResult = this.body.getValueForLocale(userLocale).replace(userName, user.getName()).replace(userFullName, user.getFullName());
        bodyResult = bodyResult.replace(expirationDateTime, expirationDate != null ? formatter.formatDateTime(expirationDate.toDate()) : "n/a");
        bodyResult = bodyResult.replace(expirationHours, String.valueOf(userPasswordPolicy.getNotifierData().getHoursToPasswordExpiration()));
        bodyResult = bodyResult.replace(expirationDays, String.valueOf(userPasswordPolicy.getNotifierData().getDaysToPasswordExpiration()));
        bodyResult = bodyResult.replace(changePasswordUrl, baseUrl + "/users/changeuserpassworddefault.action");
        return bodyResult;
    }

    public static String getUserName() {
        return userName;
    }

    public LangTranslationHolder getFromName() {
        return this.fromName;
    }

    public void setFromName(LangTranslationHolder fromName) {
        this.fromName = fromName;
    }

    public LangTranslationHolder getSubject() {
        return this.subject;
    }

    public void setSubject(LangTranslationHolder subject) {
        this.subject = subject;
    }

    public LangTranslationHolder getBody() {
        return this.body;
    }

    public void setBody(LangTranslationHolder body) {
        this.body = body;
    }
}

