/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.listener;

import com.atlassian.confluence.event.events.user.UserCreateEvent;
import com.atlassian.confluence.event.events.user.UserSignupEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.intenso.confluence.plugins.ao.PassPolicyProp;
import com.intenso.confluence.plugins.service.PasswordPolicyPropertiesService;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class UserAddedListener
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final PasswordPolicyPropertiesService propertiesService;
    private final UserAccessor userAccessor;

    public UserAddedListener(EventPublisher eventPublisher, PasswordPolicyPropertiesService propertiesService, UserAccessor userAccessor) {
        this.eventPublisher = eventPublisher;
        this.propertiesService = propertiesService;
        this.userAccessor = userAccessor;
    }

    @EventListener
    public void onCreateEvent(UserCreateEvent event) {
        this.setExpiringPolicyForNewUser((ConfluenceUser)event.getUser());
    }

    @EventListener
    public void onSignUpEvent(UserSignupEvent event) {
        this.setExpiringPolicyForNewUser((ConfluenceUser)event.getUser());
    }

    private void setExpiringPolicyForNewUser(ConfluenceUser user) {
        if (this.isExpiringPolicyForNewUsers()) {
            UserPreferences preferences = this.userAccessor.getUserPreferences(user);
            preferences.setBoolean("com.intenso.jira.plugins.passpolicy:expiring-policy-enabled", true);
        }
    }

    private boolean isExpiringPolicyForNewUsers() {
        return this.propertiesService.getOptionalProperty("enabledExpiringPolicyByDefault").map(PassPolicyProp::getValue).map(Boolean::parseBoolean).orElse(false);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }
}

