/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.job;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.intenso.confluence.plugins.service.PasswordExpirationNotifierService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SendNotificationOnPasswordExpirationJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(SendNotificationOnPasswordExpirationJob.class);
    private final PasswordExpirationNotifierService passwordExpirationNotifierService;
    private final ClusterLockService clusterLockService;
    private final TransactionTemplate txTemplate;

    @ParametersAreNonnullByDefault
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        ClusterLock lock = this.clusterLockService.getLockForName(this.getClass().getName() + ".taskExecutionLock");
        log.info("Starting SendNotificationOnPasswordExpirationJob");
        if (lock.tryLock()) {
            try {
                this.txTemplate.execute(() -> {
                    this.passwordExpirationNotifierService.executeNotifier();
                    log.info("SendNotificationOnPasswordExpirationJob executed successfully");
                    return null;
                });
            }
            finally {
                lock.unlock();
            }
            return JobRunnerResponse.success();
        }
        return JobRunnerResponse.failed((String)"Locking SendNotificationOnPasswordExpirationJob failed");
    }

    @Generated
    public SendNotificationOnPasswordExpirationJob(PasswordExpirationNotifierService passwordExpirationNotifierService, ClusterLockService clusterLockService, TransactionTemplate txTemplate) {
        this.passwordExpirationNotifierService = passwordExpirationNotifierService;
        this.clusterLockService = clusterLockService;
        this.txTemplate = txTemplate;
    }
}

