/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.job;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.intenso.confluence.plugins.service.LockUserAccountService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockUserAccountJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(LockUserAccountJob.class);
    private final LockUserAccountService lockUserAccountService;
    private final ClusterLockService clusterLockService;
    private final TransactionTemplate txTemplate;

    @ParametersAreNonnullByDefault
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        ClusterLock lock = this.clusterLockService.getLockForName(this.getClass().getName() + ".taskExecutionLock");
        log.info("Starting LockUserAccountJob");
        if (lock.tryLock()) {
            try {
                this.txTemplate.execute(() -> {
                    this.lockUserAccountService.lockUsersWithExpiredPasswords();
                    log.info("LockUserAccountJob executed successfully");
                    return null;
                });
            }
            finally {
                lock.unlock();
            }
            return JobRunnerResponse.success();
        }
        return JobRunnerResponse.failed((String)"Locking LockUserAccountJob failed");
    }

    @Generated
    public LockUserAccountJob(LockUserAccountService lockUserAccountService, ClusterLockService clusterLockService, TransactionTemplate txTemplate) {
        this.lockUserAccountService = lockUserAccountService;
        this.clusterLockService = clusterLockService;
        this.txTemplate = txTemplate;
    }
}

