/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.intenso.confluence.plugins.ao.PassPolicyPropDAO;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationCacheManager
implements DisposableBean {
    private static final int CACHE_EXPIRE_IN_MINUTES = 5;
    private static final String CACHE_NAME = ConfigurationCacheManager.class.getName() + ".cache";
    private final Cache<String, Optional<String>> cache;
    private final PassPolicyPropDAO dao;

    public ConfigurationCacheManager(CacheManager cacheManager, PassPolicyPropDAO dao) {
        this.dao = dao;
        this.cache = cacheManager.getCache(CACHE_NAME, this::getProperty, this.getCacheSettings());
    }

    public Optional<String> getPropertyValue(String propertyKey) {
        return (Optional)this.cache.get((Object)propertyKey);
    }

    public void savePropertyValue(String propertyKey, String propertyValue) {
        this.cache.put((Object)propertyKey, Optional.ofNullable(propertyValue));
    }

    public void removePropertyValue(String propertyKey) {
        this.cache.remove((Object)propertyKey);
    }

    public void clearCache() {
        if (Objects.nonNull(this.cache)) {
            this.cache.removeAll();
        }
    }

    @Nonnull
    private Optional<String> getProperty(String key) {
        return Optional.ofNullable(this.dao.getPropertyValue(key));
    }

    private CacheSettings getCacheSettings() {
        return new CacheSettingsBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).local().build();
    }

    public void destroy() {
        this.clearCache();
    }
}

