/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.intenso.confluence.plugins.ao.UserPasswordHistory;
import com.intenso.confluence.plugins.ao.UserPasswordHistoryDAO;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Component;

@Component
public class UserPasswordHistoryDAOImpl
implements UserPasswordHistoryDAO {
    private final ActiveObjects ao;
    private static final String USERNAME_FIELD = "USERNAME";
    private static final String PASSWORD_FIELD = "PASSWORD";
    private static final String INSERT_DATE_FIELD = "INSERT_DATE";

    public UserPasswordHistoryDAOImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void save(String username, String password, int passwordsRemebmeredInHistory) {
        if (passwordsRemebmeredInHistory > 0) {
            this.deletePreviousPasswords(username, passwordsRemebmeredInHistory);
            this.savePasswordHistory(username, password);
        } else {
            this.ao.delete(this.ao.find(UserPasswordHistory.class, Query.select().where("USERNAME = ?", new Object[]{username})));
        }
    }

    private void savePasswordHistory(String username, String password) {
        DBParam usernameParam = new DBParam(USERNAME_FIELD, (Object)username);
        DBParam passwordParam = new DBParam(PASSWORD_FIELD, (Object)this.getPasswordHash(username, password));
        DBParam insertDateParam = new DBParam(INSERT_DATE_FIELD, (Object)new Date());
        this.ao.create(UserPasswordHistory.class, new DBParam[]{usernameParam, passwordParam, insertDateParam});
    }

    private void deletePreviousPasswords(String username, int passwordsRemebmeredInHistory) {
        int numberOfPasswords = this.count(username);
        if (numberOfPasswords >= passwordsRemebmeredInHistory) {
            List<UserPasswordHistory> previousPasswordsHistory = this.findPreviousPasswordsHistory(username);
            for (int i = passwordsRemebmeredInHistory - 1; i < previousPasswordsHistory.size(); ++i) {
                this.ao.delete(new RawEntity[]{(RawEntity)previousPasswordsHistory.get(i)});
            }
        }
    }

    @Override
    public int count(String username) {
        return this.ao.count(UserPasswordHistory.class, Query.select().where("USERNAME = ?", new Object[]{username}));
    }

    @Override
    public boolean passwordInHistory(String username, String password) {
        List<UserPasswordHistory> previousPasswordsHistory = this.findPreviousPasswordsHistory(username);
        String passwordHash = this.getPasswordHash(username, password);
        return previousPasswordsHistory.stream().anyMatch(history -> passwordHash.equals(history.getPassword()));
    }

    @Override
    public boolean hasPreviousPasswords(String username) {
        return this.findPreviousPasswordsHistory(username).size() > 0;
    }

    private List<UserPasswordHistory> findPreviousPasswordsHistory(String username) {
        int CURRENT_PASSWORD_COUNT;
        int numberOfPasswords = this.count(username);
        if (numberOfPasswords > (CURRENT_PASSWORD_COUNT = 1)) {
            int countWithoutCurrentPassword = numberOfPasswords - CURRENT_PASSWORD_COUNT;
            Query query = this.buildPreviousPasswordsQuery(username, countWithoutCurrentPassword);
            return Arrays.asList((UserPasswordHistory[])this.ao.find(UserPasswordHistory.class, query));
        }
        return Collections.emptyList();
    }

    private Query buildPreviousPasswordsQuery(String username, int countWithoutCurrentPassword) {
        return Query.select().where("USERNAME = ?", new Object[]{username}).order("INSERT_DATE asc").limit(countWithoutCurrentPassword);
    }

    private String getPasswordHash(String username, String password) {
        return DigestUtils.sha512Hex(username + "_" + password);
    }
}

