/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.intenso.confluence.plugins.action.FormatedUserPasswordPolicy;
import com.intenso.confluence.plugins.action.FormattedGroupPasswordExpirationPolicy;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.passpolicy.UserPasswordPolicy;
import com.intenso.confluence.plugins.service.PasswordExpirationNotifierChecker;
import com.intenso.confluence.plugins.service.PasswordExpirationNotifierService;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import com.intenso.confluence.plugins.service.UserDirectoryService;
import com.intenso.confluence.plugins.utils.Page;
import com.intenso.confluence.plugins.utils.PageResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.joda.time.DateTime;

public class UserPasswordPoliciesAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    private static final String USERNAME_IN_QUERY = ".*username\\=(\\w+).*";
    private static final String GROUP_IN_QUERY = ".*groupname\\=(\\w+).*";
    private PasswordExpirationNotifierService passwordExpirationNotifierService;
    private PluginConfigurationService pluginConfigurationService;
    private PasswordPolicyService passwordPolicyService;
    private BootstrapManager bootstrapManager;
    private PluginConfiguration pluginConfiguration;
    private UserDirectoryService userDirectoryService;
    private String lastPasswordExpirationNotifierExecution = "n/a";
    private int page = 1;
    private int groupPage = 1;
    private String searchString;
    private String groupSearchString;

    @PermittedMethods(value={HttpMethod.GET})
    public String doDefault() throws Exception {
        this.pluginConfiguration = this.pluginConfigurationService.getConfiguration();
        Date lastPasswordExpirationNotifierExecutionDate = this.pluginConfigurationService.getLastPasswordExpirationNotifierExecution();
        if (lastPasswordExpirationNotifierExecutionDate != null) {
            this.lastPasswordExpirationNotifierExecution = DateFormatUtils.format((Date)lastPasswordExpirationNotifierExecutionDate, (String)"yyyy-MM-dd HH:mm:ss");
        }
        return "view";
    }

    public PageResponse<FormatedUserPasswordPolicy> getUserPasswordPoliciesPage() {
        if (Objects.isNull(this.searchString)) {
            this.searchString = this.getQueryParam(USERNAME_IN_QUERY);
        }
        PageResponse<ConfluenceUser> writableActiveUsersPage = this.pluginConfigurationService.getWritableActiveUsersPage(new Page(this.page - 1, 20), this.searchString);
        List<FormatedUserPasswordPolicy> userPasswordPolicies = writableActiveUsersPage.getElements().stream().map(user -> this.getPolicy(this.userAccessor, (ConfluenceUser)user)).toList();
        return new PageResponse<FormatedUserPasswordPolicy>(userPasswordPolicies, writableActiveUsersPage.getPage());
    }

    public PageResponse<FormattedGroupPasswordExpirationPolicy> getGroupPasswordPoliciesPage() {
        if (Objects.isNull(this.groupSearchString)) {
            this.groupSearchString = this.getQueryParam(GROUP_IN_QUERY);
        }
        Page currentPage = new Page(this.groupPage - 1, 20);
        PageResponse<FormattedGroupPasswordExpirationPolicy> groupsPage = this.pluginConfigurationService.getGroupsPage(this.userAccessor, currentPage, this.groupSearchString);
        return new PageResponse<FormattedGroupPasswordExpirationPolicy>(groupsPage.getElements(), groupsPage.getPage());
    }

    private FormatedUserPasswordPolicy getPolicy(UserAccessor userAccessor, ConfluenceUser user) {
        UserPreferences preferences = userAccessor.getUserPreferences(user);
        PasswordExpirationNotifierChecker.NotifierData notifierData = this.passwordExpirationNotifierService.checkNeedRunNotifier(this.pluginConfiguration, preferences, new DateTime());
        UserPasswordPolicy userPasswordPolicy = this.passwordPolicyService.createLazyUserPasswordPolicy(user, this.pluginConfiguration);
        return new FormatedUserPasswordPolicy(userPasswordPolicy, notifierData);
    }

    public boolean getExternalDirectoryDefined() {
        return this.userDirectoryService.isExternalDefined();
    }

    public String getWebApplicationContextPath() {
        return this.bootstrapManager.getWebAppContextPath();
    }

    private String getQueryParam(String queryRegex) {
        HttpServletRequest httpRequest = this.getActiveRequest();
        if (Objects.isNull(httpRequest) || Objects.isNull(httpRequest.getQueryString())) {
            return "";
        }
        Pattern pattern = Pattern.compile(queryRegex);
        Matcher matcher = pattern.matcher(httpRequest.getQueryString());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public Map getErrors() {
        return this.getFieldErrors();
    }

    @Generated
    public void setPasswordExpirationNotifierService(PasswordExpirationNotifierService passwordExpirationNotifierService) {
        this.passwordExpirationNotifierService = passwordExpirationNotifierService;
    }

    @Generated
    public void setPluginConfigurationService(PluginConfigurationService pluginConfigurationService) {
        this.pluginConfigurationService = pluginConfigurationService;
    }

    @Generated
    public void setPasswordPolicyService(PasswordPolicyService passwordPolicyService) {
        this.passwordPolicyService = passwordPolicyService;
    }

    @Generated
    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    @Generated
    public void setPluginConfiguration(PluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    @Generated
    public PluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    @Generated
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Generated
    public String getLastPasswordExpirationNotifierExecution() {
        return this.lastPasswordExpirationNotifierExecution;
    }

    @StrutsParameter
    @Generated
    public void setPage(int page) {
        this.page = page;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @StrutsParameter
    @Generated
    public void setGroupPage(int groupPage) {
        this.groupPage = groupPage;
    }

    @Generated
    public int getGroupPage() {
        return this.groupPage;
    }

    @StrutsParameter
    @Generated
    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    @Generated
    public String getSearchString() {
        return this.searchString;
    }

    @StrutsParameter
    @Generated
    public void setGroupSearchString(String groupSearchString) {
        this.groupSearchString = groupSearchString;
    }

    @Generated
    public String getGroupSearchString() {
        return this.groupSearchString;
    }
}

