/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.Map;

public class SkipChangePassword
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    private PluginConfigurationService pluginConfigurationService;
    private PermissionManager permissionManager;
    private HttpContext httpContext;

    public SkipChangePassword(PluginConfigurationService pluginConfigurationService, PermissionManager permissionManager) {
        this.pluginConfigurationService = pluginConfigurationService;
        this.permissionManager = permissionManager;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        ConfluenceUser loggedInUser = this.getAuthenticatedUser();
        if (loggedInUser == null) {
            return "login.action";
        }
        if (this.isSystemAdmin(loggedInUser) && this.isAdminAllowedToSkipPasswordChange()) {
            UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
            userAccessor.getUserPreferences(loggedInUser).setLong("last_password_changed_date_property", new Date().getTime());
            HttpServletRequest request = this.httpContext.getActiveRequest();
            request.getSession().removeAttribute("confluence-passport-policy-filterRedirected-userPasswordExpired");
        }
        return "success";
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    private boolean isSystemAdmin(ConfluenceUser user) {
        return this.permissionManager.isSystemAdministrator(user);
    }

    private boolean isAdminAllowedToSkipPasswordChange() {
        PluginConfiguration configuration = this.pluginConfigurationService.getConfiguration();
        return configuration.getAdminCanSkipPasswordChange();
    }

    public Map getErrors() {
        return this.getFieldErrors();
    }

    public String getContextPath() {
        return this.httpContext.getActiveRequest().getContextPath();
    }
}

