/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.action;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.SetUserPasswordAction;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import java.util.List;
import java.util.Map;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class SetUserPassword
extends SetUserPasswordAction {
    private static final long serialVersionUID = 1L;
    private String password;
    private String confirm;
    private PasswordPolicyService passwordPolicyService;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        return super.execute();
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String doSet() throws Exception {
        this.passwordPolicyService.savePasswordToHistory(this.getUsername(), this.password);
        return super.doSet();
    }

    @PermittedMethods(value={HttpMethod.POST})
    public void validate() {
        Boolean isError = false;
        if (this.password == null || this.password.equals("")) {
            this.addFieldError("password", "You must enter a value as your new password.");
            isError = true;
        }
        if (this.confirm == null || this.password.equals("")) {
            this.addFieldError("confirm", "You must enter a value as your new password.");
            isError = true;
        }
        if (!isError.booleanValue()) {
            if (!this.password.equals(this.confirm)) {
                this.addFieldError("confirm", "The new entered password and the confirmed one do not match.");
                isError = true;
            } else {
                List<String> messages = this.passwordPolicyService.validatePassword(this.password);
                if (!messages.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String message : messages) {
                        stringBuilder.append(message + "<br />");
                    }
                    this.addFieldError("password", stringBuilder.toString());
                    isError = true;
                }
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    @StrutsParameter
    public void setPassword(String password) {
        this.setNewPassword(password);
        this.password = password;
    }

    @StrutsParameter
    public void setConfirm(String confirm) {
        this.setNewPasswordConfirmation(confirm);
        this.confirm = confirm;
    }

    public void setPasswordPolicyService(PasswordPolicyService passwordPolicyService) {
        this.passwordPolicyService = passwordPolicyService;
    }

    public User getAtlassianUser() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        return userAccessor.getUser(this.username);
    }

    public Map getErrors() {
        return this.getFieldErrors();
    }
}

