/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.action;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserVerificationTokenManager;
import com.atlassian.confluence.user.UserVerificationTokenType;
import com.atlassian.confluence.user.actions.ResetUserPasswordAction;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import com.intenso.confluence.plugins.rules.PolicyRule;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@UnrestrictedAccess
public class ResetUserPassword
extends ResetUserPasswordAction {
    private static final long serialVersionUID = 1L;
    private PluginConfigurationService pluginConfigurationService;
    private PasswordPolicyService passwordPolicyService;
    private BootstrapManager bootstrapManager;
    private UserVerificationTokenManager userVerificationTokenManager;
    private HttpContext httpContext;
    private String password;
    private String confirm;
    private List<PolicyRule> passwordRules;

    @PermittedMethods(value={HttpMethod.GET})
    public String doDefault() throws Exception {
        this.prepareAction();
        return super.doDefault();
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String execute() throws Exception {
        String result = "success";
        try {
            result = this.doResetPassword();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if ("success".equals(result)) {
            this.passwordPolicyService.userPasswordChanged(this.getUsername(), this.password);
        }
        return result;
    }

    private void prepareAction() {
        this.passwordRules = this.passwordPolicyService.getPasswordRulesHelp(this.pluginConfigurationService.getConfiguration(), this.getUsername());
    }

    @PermittedMethods(value={HttpMethod.POST})
    public void validate() {
        boolean isError = false;
        if (this.password == null || this.password.equals("")) {
            this.addFieldError("newpassword", "You must enter a value as your new password.");
            isError = true;
        }
        if (this.confirm == null || this.password.equals("")) {
            this.addFieldError("newPasswordConfirmation", "You must enter a value as your new password.");
            isError = true;
        }
        if (!isError) {
            List<String> messages;
            if (this.getUserByName(this.getUsername()) == null) {
                this.addActionError(this.getText("reset.password.error.user.does.not.exist", new String[]{PlainTextToHtmlConverter.encodeHtmlEntities((String)this.getUsername())}));
            } else if (!this.isValidUserToken()) {
                this.addActionError(this.getText("reset.password.error.invalid.token"));
            }
            if (!this.hasActionErrors() && !(messages = this.passwordPolicyService.validatePassword(this.password, this.getUsername())).isEmpty()) {
                this.addFieldError("newpassword", StringUtils.join(messages, (String)"<br />"));
                isError = true;
            }
        }
        if (this.hasActionErrors() || isError) {
            this.prepareAction();
        }
    }

    private boolean isValidUserToken() {
        String token;
        String userName = this.getUsername();
        return this.userVerificationTokenManager.hasValidUserToken(userName, UserVerificationTokenType.PASSWORD_RESET, token = this.getToken()) || this.userVerificationTokenManager.hasValidUserToken(userName, UserVerificationTokenType.USER_SIGNUP, token);
    }

    @StrutsParameter
    public void setPassword(String password) {
        this.setNewPassword(password);
        this.password = password;
    }

    @StrutsParameter
    public void setConfirm(String confirm) {
        this.setNewPasswordConfirmation(confirm);
        this.confirm = confirm;
    }

    public List<PolicyRule> getPasswordRules() {
        return this.passwordRules;
    }

    public String getWebApplicationContextPath() {
        return this.bootstrapManager.getWebAppContextPath();
    }

    public void setPluginConfigurationService(PluginConfigurationService pluginConfigurationService) {
        this.pluginConfigurationService = pluginConfigurationService;
    }

    public void setPasswordPolicyService(PasswordPolicyService passwordPolicyService) {
        this.passwordPolicyService = passwordPolicyService;
    }

    public User getLoggedInUser() {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        return userAccessor.getUser(this.getUsername());
    }

    public void setUserVerificationTokenManager(UserVerificationTokenManager userVerificationTokenManager) {
        this.userVerificationTokenManager = userVerificationTokenManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public boolean mustValidateCaptcha() {
        return false;
    }

    public Map getErrors() {
        return this.getFieldErrors();
    }

    public String getContextPath() {
        return this.httpContext.getActiveRequest().getContextPath();
    }
}

