/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.intenso.confluence.plugins.action.FormattedLockingAfterDateUserPolicy;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.service.LockUserAccountService;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import com.intenso.confluence.plugins.utils.LicenseUtils;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class PasswordPolicyConfiguration
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 1L;
    private final PluginConfigurationService pluginConfigurationService;
    private final LockUserAccountService lockService;
    private final PluginLicenseManager licenseManager;
    private final PasswordPolicyService passwordPolicyService;
    private PluginConfiguration pluginConfiguration;
    private Boolean passwordAgeReseted = false;
    private Boolean enabled = false;
    private Boolean passwordCharacterCharacteristicsEnabled = false;
    private Boolean adminCanSkipPasswordChange = false;
    private String maximumPasswordAge;
    private String passwordsRemebmeredInHistory;
    private String minPasswordLength;
    private String maxPasswordLength;
    private String digitCharacterRule;
    private String nonAlphanumericCharacterRule;
    private String uppercaseCharacterRule;
    private String lowercaseCharacterRule;
    private String numberOfCharacteristics;
    private Boolean passwordExpirationNotifierEnabled;
    private String passwordExpirationNotifierDuration;
    private String passwordExpirationNotifierEmailSubject;
    private String passwordExpirationNotifierEmailBody;
    private String passwordExpirationNotifierEmailFromName;
    private String passwordExpiredNotifierEmailSubject;
    private String passwordExpiredNotifierEmailBody;
    private Boolean userAccountLockingEnabled = false;
    private String daysAfterPasswordExpirationToLockUserAccount;
    private String userAccountLockedPageConent;
    private String maximumPasswordAgeField;
    private Boolean userAccountLockingAfterFailedLoginsEnabled;
    private String numberOfFailedAttemptsToLockUser;
    private Boolean userAccountLockingAfterPasswordExpirationEnabled;

    @PermittedMethods(value={HttpMethod.GET})
    public String doInput() {
        String errorMsg = LicenseUtils.checkLicense(this.licenseManager);
        if (errorMsg != null) {
            this.addActionMessage(errorMsg);
        }
        this.pluginConfiguration = this.pluginConfigurationService.getConfiguration();
        this.enabled = this.pluginConfiguration.getEnabled();
        this.maximumPasswordAge = this.pluginConfiguration.getMaximumPasswordAge().toString();
        this.passwordsRemebmeredInHistory = this.pluginConfiguration.getPasswordsRemebmeredInHistory().toString();
        this.minPasswordLength = this.pluginConfiguration.getMinPasswordLength().toString();
        this.maxPasswordLength = this.pluginConfiguration.getMaxPasswordLength().toString();
        this.passwordCharacterCharacteristicsEnabled = this.pluginConfiguration.getNumberOfCharacteristics() > 0;
        this.numberOfCharacteristics = this.pluginConfiguration.getNumberOfCharacteristics().toString();
        this.digitCharacterRule = this.pluginConfiguration.getDigitCharacterRule().toString();
        this.nonAlphanumericCharacterRule = this.pluginConfiguration.getNonAlphanumericCharacterRule().toString();
        this.uppercaseCharacterRule = this.pluginConfiguration.getUppercaseCharacterRule().toString();
        this.lowercaseCharacterRule = this.pluginConfiguration.getLowercaseCharacterRule().toString();
        this.adminCanSkipPasswordChange = this.pluginConfiguration.getAdminCanSkipPasswordChange();
        this.passwordExpirationNotifierEnabled = this.pluginConfiguration.getPasswordExpirationNotifierEnabled();
        this.passwordExpirationNotifierDuration = this.pluginConfiguration.getPasswordExpirationNotifierDuration().toString();
        this.userAccountLockingEnabled = this.pluginConfiguration.getUserAccountLockingEnabled();
        this.userAccountLockingAfterPasswordExpirationEnabled = this.pluginConfiguration.getUserAccountLockingAfterPasswordExpirationEnabled();
        this.setUserAccountLockingAfterFailedLoginsEnabled(this.pluginConfiguration.getUserAccountLockingAfterFailedLoginsEnabled());
        this.setNumberOfFailedAttemptsToLockUser(this.pluginConfiguration.getNumberOfFailedAttemptsToLockUser().toString());
        this.daysAfterPasswordExpirationToLockUserAccount = this.pluginConfiguration.getDaysAfterPasswordExpirationToLockUserAccount().toString();
        this.userAccountLockedPageConent = this.pluginConfiguration.getUserAccountLockedPageConent();
        return "input";
    }

    public String doDefault() throws Exception {
        String errorMsg = LicenseUtils.checkLicense(this.licenseManager);
        if (errorMsg != null) {
            this.addActionMessage(errorMsg);
        }
        this.pluginConfiguration = this.pluginConfigurationService.getConfiguration();
        return "view";
    }

    public String execute() throws Exception {
        this.pluginConfiguration = this.pluginConfigurationService.getConfiguration();
        this.pluginConfiguration.setEnabled(this.enabled);
        if (this.enabled.booleanValue()) {
            this.pluginConfiguration.setMaximumPasswordAge(Integer.parseInt(this.maximumPasswordAge));
            this.pluginConfiguration.setPasswordsRemebmeredInHistory(Integer.parseInt(this.passwordsRemebmeredInHistory));
            this.pluginConfiguration.setMinPasswordLength(Integer.parseInt(this.minPasswordLength));
            this.pluginConfiguration.setMaxPasswordLength(Integer.parseInt(this.maxPasswordLength));
            this.pluginConfiguration.setAdminCanSkipPasswordChange(this.adminCanSkipPasswordChange);
            if (this.passwordCharacterCharacteristicsEnabled.booleanValue()) {
                this.pluginConfiguration.setNumberOfCharacteristics(Integer.parseInt(this.numberOfCharacteristics));
                this.pluginConfiguration.setDigitCharacterRule(Integer.parseInt(this.digitCharacterRule));
                this.pluginConfiguration.setNonAlphanumericCharacterRule(Integer.parseInt(this.nonAlphanumericCharacterRule));
                this.pluginConfiguration.setUppercaseCharacterRule(Integer.parseInt(this.uppercaseCharacterRule));
                this.pluginConfiguration.setLowercaseCharacterRule(Integer.parseInt(this.lowercaseCharacterRule));
            } else {
                this.pluginConfiguration.setNumberOfCharacteristics(0);
            }
            this.pluginConfiguration.setPasswordExpirationNotifierEnabled(this.passwordExpirationNotifierEnabled);
            if (this.passwordExpirationNotifierEnabled.booleanValue()) {
                this.pluginConfiguration.setPasswordExpirationNotifierDuration(Integer.parseInt(this.passwordExpirationNotifierDuration));
            }
            this.pluginConfiguration.setUserAccountLockingEnabled(this.userAccountLockingEnabled);
            if (this.pluginConfiguration.getUserAccountLockingEnabled().booleanValue()) {
                this.pluginConfiguration.setUserAccountLockedPageConent(this.userAccountLockedPageConent);
            }
            this.pluginConfiguration.setUserAccountLockingAfterPasswordExpirationEnabled(this.userAccountLockingAfterPasswordExpirationEnabled);
            if (this.pluginConfiguration.getUserAccountLockingAfterPasswordExpirationEnabled().booleanValue()) {
                this.pluginConfiguration.setDaysAfterPasswordExpirationToLockUserAccount(Integer.parseInt(this.daysAfterPasswordExpirationToLockUserAccount));
            }
            this.pluginConfiguration.setUserAccountLockingAfterFailedLoginsEnabled(this.getUserAccountLockingAfterFailedLoginsEnabled());
            this.pluginConfiguration.setNumberOfFailedAttemptsToLockUser(Integer.parseInt(this.getNumberOfFailedAttemptsToLockUser()));
        }
        this.pluginConfigurationService.saveConfiguration(this.pluginConfiguration);
        return this.doDefault();
    }

    public void validate() {
        super.validate();
        if (this.enabled.booleanValue()) {
            Integer maximumPasswordAgeInt = this.validateNumericAndRange(this.maximumPasswordAge, "maximumPasswordAge", 0, 365);
            this.validateNumericAndRange(this.passwordsRemebmeredInHistory, "passwordsRemebmeredInHistory", 0, 100);
            int MAX_PASSWORD_LENGTH = 255;
            Integer minPasswordLengthNumber = this.validateNumericAndRange(this.minPasswordLength, "minPasswordLength", 6, 255);
            Integer maxPasswordLengthValidNumber = this.validateNumericAndRange(this.maxPasswordLength, "maxPasswordLength", 6, 255);
            if (minPasswordLengthNumber != null && maxPasswordLengthValidNumber != null && minPasswordLengthNumber > maxPasswordLengthValidNumber) {
                this.addFieldError("minPasswordLength", "Minimum password length can't be greater than maximum");
            }
            if (this.passwordCharacterCharacteristicsEnabled.booleanValue() && this.validateNumericAndRange(this.numberOfCharacteristics, "numberOfCharacteristics", 1, 4) != null) {
                boolean rulesValid;
                Integer digitCharacterRuleNumber = this.validateNumericAndRange(this.digitCharacterRule, "digitCharacterRule", 0, 255);
                Integer nonAlphanumericCharacterRuleNumber = this.validateNumericAndRange(this.nonAlphanumericCharacterRule, "nonAlphanumericCharacterRule", 0, 255);
                Integer uppercaseCharacterRuleNumber = this.validateNumericAndRange(this.uppercaseCharacterRule, "uppercaseCharacterRule", 0, 255);
                Integer lowercaseCharacterRuleNumber = this.validateNumericAndRange(this.lowercaseCharacterRule, "lowercaseCharacterRule", 0, 255);
                boolean bl = rulesValid = digitCharacterRuleNumber != null && nonAlphanumericCharacterRuleNumber != null && uppercaseCharacterRuleNumber != null && lowercaseCharacterRuleNumber != null;
                if (rulesValid) {
                    int characterRuleSum;
                    int numberOfCharacteristicsInt;
                    int numberOfRules = 0;
                    if (digitCharacterRuleNumber > 0) {
                        ++numberOfRules;
                    }
                    if (nonAlphanumericCharacterRuleNumber > 0) {
                        ++numberOfRules;
                    }
                    if (uppercaseCharacterRuleNumber > 0) {
                        ++numberOfRules;
                    }
                    if (lowercaseCharacterRuleNumber > 0) {
                        ++numberOfRules;
                    }
                    if (numberOfRules < (numberOfCharacteristicsInt = Integer.parseInt(this.numberOfCharacteristics))) {
                        this.addFieldError("numberOfCharacteristics", "Max number of characteristict is " + numberOfRules);
                    } else if (minPasswordLengthNumber != null && (characterRuleSum = digitCharacterRuleNumber + nonAlphanumericCharacterRuleNumber + uppercaseCharacterRuleNumber + lowercaseCharacterRuleNumber) > minPasswordLengthNumber) {
                        this.addFieldError("minPasswordLength", "Minimum length based on defined character rules is " + characterRuleSum);
                    }
                }
            }
            if (this.passwordExpirationNotifierEnabled.booleanValue()) {
                this.validateNumericAndRange(this.passwordExpirationNotifierDuration, "passwordExpirationNotifierDuration", 1, 31);
                if (StringUtils.isBlank((CharSequence)this.passwordExpirationNotifierEmailSubject)) {
                    this.addFieldError("passwordExpirationNotifierEmailSubject", "Email subject is required");
                } else if (this.passwordExpirationNotifierEmailSubject.length() > 250) {
                    this.addFieldError("passwordExpirationNotifierEmailSubject", "Subject can't be longer than 250 characters");
                }
                if (StringUtils.isBlank((CharSequence)this.passwordExpirationNotifierEmailFromName)) {
                    this.addFieldError("passwordExpirationNotifierEmailFromName", "From name is required");
                } else if (this.passwordExpirationNotifierEmailSubject.length() > 250) {
                    this.addFieldError("passwordExpirationNotifierEmailFromName", "From name can't be longer than 250 characters");
                }
            }
            if (this.passwordExpirationNotifierEnabled.booleanValue() && maximumPasswordAgeInt != null && maximumPasswordAgeInt == 0) {
                this.addFieldError("passwordExpirationNotifierEnabled", "To enable notifier maximum password age must be greater than 0");
            }
            if (this.userAccountLockingAfterPasswordExpirationEnabled.booleanValue()) {
                this.validateNumericAndRange(this.daysAfterPasswordExpirationToLockUserAccount, "daysAfterPasswordExpirationToLockUserAccount", 1, 1000);
            }
            Integer n = this.validateNumericAndRange(this.getNumberOfFailedAttemptsToLockUser(), "numberOfFailedAttemptsToLockUser", 1, Integer.MAX_VALUE);
        }
    }

    private Integer validateNumericAndRange(String value, String fieldName, Integer min2, Integer max) {
        Integer intValue;
        if (StringUtils.isBlank((CharSequence)value) || !StringUtils.isNumeric((CharSequence)value) || !this.isValidInteger(value)) {
            this.addFieldError(fieldName, this.getText("BAD_INTEGER", value));
            return null;
        }
        if (min2 != null && max != null && ((intValue = Integer.valueOf(Integer.parseInt(value))) < min2 || intValue > max)) {
            this.addFieldError(fieldName, "Number must be between " + min2 + " and " + max + ".");
            return null;
        }
        return Integer.parseInt(value);
    }

    private boolean isValidInteger(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public String doResetPasswordAge() throws Exception {
        this.passwordPolicyService.resetPasswordAge();
        return this.doDefault();
    }

    public List<FormattedLockingAfterDateUserPolicy> getAllLockAfterDatePolicies() {
        return this.lockService.getAllLockAfterDatePolicies();
    }

    public boolean getIsAnyUserAccountLockAfterDatePolicyExists() {
        return this.lockService.isAnyUserAccountLockAfterDatePolicyExists();
    }

    public PluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getMaximumPasswordAge() {
        return this.maximumPasswordAge;
    }

    public void setMaximumPasswordAge(String maximumPasswordAge) {
        this.maximumPasswordAge = maximumPasswordAge;
    }

    public String getPasswordsRemebmeredInHistory() {
        return this.passwordsRemebmeredInHistory;
    }

    public void setPasswordsRemebmeredInHistory(String passwordsRemebmeredInHistory) {
        this.passwordsRemebmeredInHistory = passwordsRemebmeredInHistory;
    }

    public String getMinPasswordLength() {
        return this.minPasswordLength;
    }

    public void setMinPasswordLength(String minPasswordLength) {
        this.minPasswordLength = minPasswordLength;
    }

    public String getMaxPasswordLength() {
        return this.maxPasswordLength;
    }

    public void setMaxPasswordLength(String maxPasswordLength) {
        this.maxPasswordLength = maxPasswordLength;
    }

    public String getDigitCharacterRule() {
        return this.digitCharacterRule;
    }

    public void setDigitCharacterRule(String digitCharacterRule) {
        this.digitCharacterRule = digitCharacterRule;
    }

    public String getNonAlphanumericCharacterRule() {
        return this.nonAlphanumericCharacterRule;
    }

    public void setNonAlphanumericCharacterRule(String nonAlphanumericCharacterRule) {
        this.nonAlphanumericCharacterRule = nonAlphanumericCharacterRule;
    }

    public String getUppercaseCharacterRule() {
        return this.uppercaseCharacterRule;
    }

    public void setUppercaseCharacterRule(String uppercaseCharacterRule) {
        this.uppercaseCharacterRule = uppercaseCharacterRule;
    }

    public String getLowercaseCharacterRule() {
        return this.lowercaseCharacterRule;
    }

    public void setLowercaseCharacterRule(String lowercaseCharacterRule) {
        this.lowercaseCharacterRule = lowercaseCharacterRule;
    }

    public String getNumberOfCharacteristics() {
        return this.numberOfCharacteristics;
    }

    public void setNumberOfCharacteristics(String numberOfCharacteristics) {
        this.numberOfCharacteristics = numberOfCharacteristics;
    }

    public Boolean getPasswordCharacterCharacteristicsEnabled() {
        return this.passwordCharacterCharacteristicsEnabled;
    }

    public void setPasswordCharacterCharacteristicsEnabled(Boolean passwordCharacterCharacteristicsEnabled) {
        this.passwordCharacterCharacteristicsEnabled = passwordCharacterCharacteristicsEnabled;
    }

    public Boolean getPasswordAgeReseted() {
        return this.passwordAgeReseted;
    }

    public void setPasswordAgeReseted(Boolean passwordAgeReseted) {
        this.passwordAgeReseted = passwordAgeReseted;
    }

    public Boolean getAdminCanSkipPasswordChange() {
        return this.adminCanSkipPasswordChange;
    }

    public void setAdminCanSkipPasswordChange(Boolean adminCanSkipPasswordChange) {
        this.adminCanSkipPasswordChange = adminCanSkipPasswordChange;
    }

    public Boolean getPasswordExpirationNotifierEnabled() {
        return this.passwordExpirationNotifierEnabled;
    }

    public void setPasswordExpirationNotifierEnabled(Boolean passwordExpirationNotifierEnabled) {
        this.passwordExpirationNotifierEnabled = passwordExpirationNotifierEnabled;
    }

    public String getPasswordExpirationNotifierDuration() {
        return this.passwordExpirationNotifierDuration;
    }

    public void setPasswordExpirationNotifierDuration(String passwordExpirationNotifierDuration) {
        this.passwordExpirationNotifierDuration = passwordExpirationNotifierDuration;
    }

    public String getPasswordExpirationNotifierEmailSubject() {
        return this.passwordExpirationNotifierEmailSubject;
    }

    public void setPasswordExpirationNotifierEmailSubject(String passwordExpirationNotifierEmailSubject) {
        this.passwordExpirationNotifierEmailSubject = passwordExpirationNotifierEmailSubject;
    }

    public String getPasswordExpirationNotifierEmailBody() {
        return this.passwordExpirationNotifierEmailBody;
    }

    public void setPasswordExpirationNotifierEmailBody(String passwordExpirationNotifierEmailBody) {
        this.passwordExpirationNotifierEmailBody = passwordExpirationNotifierEmailBody;
    }

    public String getPasswordExpirationNotifierEmailFromName() {
        return this.passwordExpirationNotifierEmailFromName;
    }

    public void setPasswordExpirationNotifierEmailFromName(String passwordExpirationNotifierEmailFromName) {
        this.passwordExpirationNotifierEmailFromName = passwordExpirationNotifierEmailFromName;
    }

    public String getPasswordExpiredNotifierEmailSubject() {
        return this.passwordExpiredNotifierEmailSubject;
    }

    public void setPasswordExpiredNotifierEmailSubject(String passwordExpiredNotifierEmailSubject) {
        this.passwordExpiredNotifierEmailSubject = passwordExpiredNotifierEmailSubject;
    }

    public String getPasswordExpiredNotifierEmailBody() {
        return this.passwordExpiredNotifierEmailBody;
    }

    public void setPasswordExpiredNotifierEmailBody(String passwordExpiredNotifierEmailBody) {
        this.passwordExpiredNotifierEmailBody = passwordExpiredNotifierEmailBody;
    }

    public Boolean getUserAccountLockingEnabled() {
        return this.userAccountLockingEnabled;
    }

    public void setUserAccountLockingEnabled(Boolean userAccountLockingEnabled) {
        this.userAccountLockingEnabled = userAccountLockingEnabled;
    }

    public String getDaysAfterPasswordExpirationToLockUserAccount() {
        return this.daysAfterPasswordExpirationToLockUserAccount;
    }

    public void setDaysAfterPasswordExpirationToLockUserAccount(String daysAfterPasswordExpirationToLockUserAccount) {
        this.daysAfterPasswordExpirationToLockUserAccount = daysAfterPasswordExpirationToLockUserAccount;
    }

    public String getUserAccountLockedPageConent() {
        return this.userAccountLockedPageConent;
    }

    public void setUserAccountLockedPageConent(String userAccountLockedPageConent) {
        this.userAccountLockedPageConent = userAccountLockedPageConent;
    }

    public String getMaximumPasswordAgeField() {
        return this.maximumPasswordAgeField;
    }

    public void setMaximumPasswordAgeField(String maximumPasswordAgeField) {
        this.maximumPasswordAgeField = maximumPasswordAgeField;
    }

    public Boolean getUserAccountLockingAfterPasswordExpirationEnabled() {
        return this.userAccountLockingAfterPasswordExpirationEnabled;
    }

    public void setUserAccountLockingAfterPasswordExpirationEnabled(Boolean userAccountLockingAfterPasswordExpirationEnabled) {
        this.userAccountLockingAfterPasswordExpirationEnabled = userAccountLockingAfterPasswordExpirationEnabled;
    }

    public Boolean getUserAccountLockingAfterFailedLoginsEnabled() {
        return this.userAccountLockingAfterFailedLoginsEnabled;
    }

    public void setUserAccountLockingAfterFailedLoginsEnabled(Boolean userAccountLockingAfterFailedLoginsEnabled) {
        this.userAccountLockingAfterFailedLoginsEnabled = userAccountLockingAfterFailedLoginsEnabled;
    }

    public String getNumberOfFailedAttemptsToLockUser() {
        return this.numberOfFailedAttemptsToLockUser;
    }

    public void setNumberOfFailedAttemptsToLockUser(String numberOfFailedAttemptsToLockUser) {
        this.numberOfFailedAttemptsToLockUser = numberOfFailedAttemptsToLockUser;
    }

    public Map getErrors() {
        return this.getFieldErrors();
    }

    @Generated
    public PasswordPolicyConfiguration(PluginConfigurationService pluginConfigurationService, LockUserAccountService lockService, PluginLicenseManager licenseManager, PasswordPolicyService passwordPolicyService) {
        this.pluginConfigurationService = pluginConfigurationService;
        this.lockService = lockService;
        this.licenseManager = licenseManager;
        this.passwordPolicyService = passwordPolicyService;
    }
}

