/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.user.User;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;

public class FormattedLockingAfterDateUserPolicy {
    private Date lockDate;
    private User user;
    private UserPreferences properties;

    public FormattedLockingAfterDateUserPolicy(ConfluenceUser user, UserAccessor userAccessor) {
        this.user = user;
        this.properties = userAccessor.getUserPreferences(user);
    }

    public String getLockDateString() {
        Date currentLockDate = this.getLockDate();
        return currentLockDate != null ? new SimpleDateFormat("yyyy/MM/dd HH:mm").format(currentLockDate) : "";
    }

    public Date getLockDate() {
        Optional maybeLockAfterEpochMillis = this.properties.getLong("intenso-password-policy-user-lock-after-date");
        if (maybeLockAfterEpochMillis.isEmpty()) {
            return null;
        }
        if (this.lockDate == null) {
            this.lockDate = new Date((Long)maybeLockAfterEpochMillis.get());
        }
        return this.lockDate;
    }

    public Date getCurrentDate() {
        return new Date();
    }

    public String getUsername() {
        return this.user.getName();
    }

    public boolean isAccountLocked() {
        return this.properties.getBoolean("com.intenso.jira.plugins.passpolicy:user_account_locked").orElse(false);
    }

    public String getFullUsername() {
        return this.user.getFullName();
    }

    public boolean shouldLockAccountAfterDate() {
        return this.isLockDateExists() && this.isCurrentDateAfterLockDate();
    }

    private boolean isLockDateExists() {
        return this.getLockDate() != null;
    }

    public boolean isCurrentDateAfterLockDate() {
        return this.getCurrentDate().after(this.getLockDate());
    }

    public void lockUser() {
        this.properties.setBoolean("com.intenso.jira.plugins.passpolicy:user_account_locked", true);
    }
}

