/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.intenso.confluence.plugins.passpolicy.UserPasswordPolicy;
import com.intenso.confluence.plugins.service.PasswordExpirationNotifierChecker;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.joda.time.DateTime;

public class FormatedUserPasswordPolicy {
    private ConfluenceUser user;
    private PasswordExpirationNotifierChecker.NotifierData notifierData;
    private final UserPasswordPolicy userPasswordPolicy;
    private final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private final String NOT_AVAILABLE = "n/a";
    private final String INTERNAL = "Internal";
    private final String EXTERNAL = "External";

    public FormatedUserPasswordPolicy(UserPasswordPolicy userPasswordPolicy, PasswordExpirationNotifierChecker.NotifierData notifierData) {
        this.user = userPasswordPolicy.getUser();
        this.notifierData = notifierData;
        this.userPasswordPolicy = userPasswordPolicy;
    }

    public String getDirectoryType() {
        return this.userPasswordPolicy.isUserInternal() ? "Internal" : "External";
    }

    public String getLastPasswordChangedDate() {
        DateTime date = this.getLastPasswordChangeDateTime();
        return date != null ? DateFormatUtils.format((Date)date.toDate(), (String)"yyyy-MM-dd HH:mm:ss") : "n/a";
    }

    public DateTime getLastPasswordChangeDateTime() {
        return this.userPasswordPolicy.getLastPasswordChangeDateTime();
    }

    public String getLastPasswordExpirationNotificationSendDate() {
        Date date = this.userPasswordPolicy.getLastPasswordExpirationNotificationSendDate();
        return date != null ? DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss") : "n/a";
    }

    public String getLastPasswordExpiredNotificationSendDate() {
        Date date = this.userPasswordPolicy.getLastPasswordExpiredNotificationSendDate();
        return date != null ? DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss") : "n/a";
    }

    public ConfluenceUser getUser() {
        return this.user;
    }

    public PasswordExpirationNotifierChecker.NotifierData getNotifierData() {
        return this.notifierData;
    }

    public Integer getPasswordAge() {
        return this.notifierData != null ? this.notifierData.getPasswordAge().getHours() : 0;
    }

    public String getExpirationDate() {
        if (this.notifierData != null && this.notifierData.getExpirationDate() != null) {
            Date date = this.notifierData.getExpirationDate().toDate();
            return date != null ? DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss") : "n/a";
        }
        return "n/a";
    }

    public boolean getIsExpirationDateSet() {
        return this.notifierData != null && this.notifierData.getExpirationDate() != null;
    }

    public String getPasswordNotification() {
        if (this.notifierData.isNeedRunNotifier()) {
            return "expiration notification";
        }
        if (this.notifierData.isSendPasswordExpiredNotification()) {
            return "expired notification";
        }
        return "none";
    }

    public boolean isUserAccountLocked() {
        return this.userPasswordPolicy.isUserAccountLocked();
    }

    public boolean getIsExpiringPasswordPolicyEnabled() {
        return this.userPasswordPolicy.isExpiringPasswordPolicyEnabled();
    }

    public DateTime getDateTimeOfLockingUserAccount() {
        return this.userPasswordPolicy.getDateTimeOfLockingUserAccount();
    }

    public boolean getIsSysAdmin() {
        return this.userPasswordPolicy.getIsSysAdmin();
    }
}

