/*
 * Decompiled with CFR 0.152.
 */
package com.intenso.confluence.plugins.action;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ChangeMyPasswordAction;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.user.User;
import com.intenso.confluence.plugins.passpolicy.PluginConfiguration;
import com.intenso.confluence.plugins.passpolicy.PluginConstants;
import com.intenso.confluence.plugins.rules.PolicyRule;
import com.intenso.confluence.plugins.service.PasswordPolicyService;
import com.intenso.confluence.plugins.service.PluginConfigurationService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ChangeUserPassword
extends ChangeMyPasswordAction {
    private static final long serialVersionUID = 1L;
    private PluginConfigurationService pluginConfigurationService;
    private PasswordPolicyService passwordPolicyService;
    private HttpContext httpContext;
    private BootstrapManager bootstrapManager;
    private PermissionManager permissionManager;
    private Boolean passwordExpired;
    private Boolean canSkipPasswordChange;
    private Boolean filterRedirectToChangePassword = false;
    private String password;
    private String current;
    private String confirm;
    private String destination;
    private Boolean showMenu = true;
    private List<PolicyRule> passwordRules;

    @PermittedMethods(value={HttpMethod.GET})
    public String doDefault() throws Exception {
        UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
        User loggedInUser = userAccessor.getUser(this.getUser().getName());
        if (loggedInUser == null) {
            return "login.action";
        }
        this.prepareAction();
        return "input";
    }

    private void prepareAction() {
        ConfluenceUser loggedInUser = this.getUser();
        boolean isSystemAdmin = this.permissionManager.isSystemAdministrator(loggedInUser);
        PluginConfiguration configuration = this.pluginConfigurationService.getConfiguration();
        this.canSkipPasswordChange = isSystemAdmin && configuration.getAdminCanSkipPasswordChange() != false;
        this.passwordExpired = this.passwordPolicyService.hasUserPasswordExpired(loggedInUser);
        HttpServletRequest request = this.httpContext.getActiveRequest();
        Object filterRedirectToChangePasswordAttribute = request.getSession().getAttribute("confluence-passport-policy-filterRedirected-userPasswordExpired");
        if (filterRedirectToChangePasswordAttribute != null) {
            this.filterRedirectToChangePassword = (Boolean)filterRedirectToChangePasswordAttribute;
            this.showMenu = this.filterRedirectToChangePassword == false;
        }
        this.passwordRules = this.passwordPolicyService.getPasswordRulesHelp(configuration, loggedInUser.getName());
    }

    @PermittedMethods(value={HttpMethod.POST})
    public void validate() {
        boolean isError = false;
        if (this.current == null || this.current.equals("")) {
            this.addFieldError("current", "You must enter a value as your current password.");
            isError = true;
        }
        if (this.password == null || this.password.equals("")) {
            this.addFieldError("password", "You must enter a value as your new password.");
            isError = true;
        }
        if (this.confirm == null || this.confirm.equals("")) {
            this.addFieldError("confirm", "You must enter a value as your new password.");
            isError = true;
        }
        if (!isError) {
            if (!this.userAccessor.authenticate(this.getUser().getName(), this.current)) {
                this.addFieldError("current", "Your current password is not correct.");
                isError = true;
            } else if (!this.password.equals(this.confirm)) {
                isError = true;
            } else {
                UserAccessor userAccessor;
                ConfluenceUser loggedInUser;
                List<String> messages;
                PluginConfiguration configuration = this.pluginConfigurationService.getConfiguration();
                if (configuration.getEnabled().booleanValue() && !this.hasActionErrors() && !(messages = this.passwordPolicyService.validatePassword(configuration, this.password, (loggedInUser = (userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor")).getUserByName(this.getUser().getName())).getName())).isEmpty()) {
                    this.addFieldError("password", StringUtils.join(messages, (String)"<br />"));
                    isError = true;
                }
            }
        }
        if (isError || this.hasActionErrors()) {
            this.prepareAction();
        }
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String execute() throws Exception {
        String result = super.execute();
        if (!"error".equals(result)) {
            UserAccessor userAccessor = (UserAccessor)ContainerManager.getInstance().getContainerContext().getComponent((Object)"userAccessor");
            ConfluenceUser loggedInUser = userAccessor.getUserByName(this.getUser().getName());
            HttpServletRequest request = this.httpContext.getActiveRequest();
            Object filterRedirectToChangePasswordAttribute = request.getSession().getAttribute("confluence-passport-policy-filterRedirected-userPasswordExpired");
            if (filterRedirectToChangePasswordAttribute != null) {
                this.filterRedirectToChangePassword = (Boolean)filterRedirectToChangePasswordAttribute;
                this.showMenu = this.filterRedirectToChangePassword == false;
            }
            this.passwordPolicyService.saveDistinctPasswordToHistory(this.getUsername(), this.current);
            this.passwordPolicyService.userPasswordChanged(loggedInUser, this.password);
        }
        return result;
    }

    public boolean isDialogDecorator() {
        HttpServletRequest request = this.httpContext.getActiveRequest();
        return "dialog".equals(request.getParameter("decorator"));
    }

    @StrutsParameter
    public void setPassword(String password) {
        this.setNewPassword(password);
        this.password = password;
    }

    @StrutsParameter
    public void setCurrent(String current) {
        this.setCurrentPassword(current);
        this.current = current;
    }

    @StrutsParameter
    public void setConfirm(String confirm) {
        this.setNewPasswordConfirmation(confirm);
        this.confirm = confirm;
    }

    public Boolean getPasswordExpired() {
        return this.passwordExpired;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = StringUtils.trimToNull((String)destination);
    }

    public Boolean getFilterRedirectToChangePassword() {
        return this.filterRedirectToChangePassword;
    }

    public Boolean getCanSkipPasswordChange() {
        return this.canSkipPasswordChange;
    }

    public List<PolicyRule> getPasswordRules() {
        return this.passwordRules;
    }

    public String getImagesResourceKey() {
        return PluginConstants.getImagesResourceKey();
    }

    public String getWebApplicationContextPath() {
        return this.bootstrapManager.getWebAppContextPath();
    }

    public void setPluginConfigurationService(PluginConfigurationService pluginConfigurationService) {
        this.pluginConfigurationService = pluginConfigurationService;
    }

    public void setPasswordPolicyService(PasswordPolicyService passwordPolicyService) {
        this.passwordPolicyService = passwordPolicyService;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public Boolean getShowMenu() {
        return this.showMenu;
    }

    public void setShowMenu(Boolean showMenu) {
        this.showMenu = showMenu;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public Map getErrors() {
        return this.getFieldErrors();
    }

    public String getContextPath() {
        return this.httpContext.getActiveRequest().getContextPath();
    }
}

