/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.utils;

import com.atlassian.conf.logger.ISLogger;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.infosysta.utils.ISUtilities;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class JiraUtils {
    public static boolean isGreaterThanOrEqualTo_Plugin(String thisVersion) {
        boolean isGreaterThanOrEqualToCurrentVersion = false;
        try {
            String currentVersionNumber = JiraUtils.getPluginVersion();
            String[] currentVersionNumbers = new String[]{"-1", "-1", "-1"};
            int currentVersionIndex = 0;
            StringTokenizer currentVersionStringTokenizer = new StringTokenizer(currentVersionNumber, ".");
            while (currentVersionStringTokenizer.hasMoreTokens()) {
                currentVersionNumbers[currentVersionIndex] = currentVersionStringTokenizer.nextToken();
                ++currentVersionIndex;
            }
            int firstCurrentVersionNumber = Integer.valueOf(currentVersionNumbers[0]);
            int secondCurrentVersionNumber = Integer.valueOf(currentVersionNumbers[1]);
            int thirdCurrentVersionNumber = Integer.valueOf(currentVersionNumbers[2]);
            String[] thisVersionNumbers = new String[]{"-1", "-1", "-1"};
            int thisVersionIndex = 0;
            StringTokenizer thisVersionStringTokenizer = new StringTokenizer(thisVersion, ".");
            while (thisVersionStringTokenizer.hasMoreTokens()) {
                thisVersionNumbers[thisVersionIndex] = thisVersionStringTokenizer.nextToken();
                ++thisVersionIndex;
            }
            int thisFirstVersionNumber = Integer.valueOf(thisVersionNumbers[0]);
            int thisSecondVersionNumber = Integer.valueOf(thisVersionNumbers[1]);
            int thisThirdVersionNumber = Integer.valueOf(thisVersionNumbers[2]);
            if (firstCurrentVersionNumber > thisFirstVersionNumber || firstCurrentVersionNumber == thisFirstVersionNumber && secondCurrentVersionNumber >= thisSecondVersionNumber || firstCurrentVersionNumber == thisFirstVersionNumber && secondCurrentVersionNumber >= thisSecondVersionNumber && thirdCurrentVersionNumber >= thisThirdVersionNumber) {
                isGreaterThanOrEqualToCurrentVersion = true;
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return isGreaterThanOrEqualToCurrentVersion;
    }

    public static boolean isGreaterThanOrEqualTo(String pluginVersion, String thisVersion) {
        boolean isGreaterThanOrEqualToCurrentVersion = false;
        try {
            if (pluginVersion != null && thisVersion != null && pluginVersion.contains(".") && thisVersion.contains(".")) {
                pluginVersion = pluginVersion.substring(0, 5);
                thisVersion = thisVersion.substring(0, 5);
                StringTokenizer pluginVersionStringTokenizer = new StringTokenizer(pluginVersion, ".");
                int[] pluginVersionNumbersArray = new int[3];
                for (int pluginVersionIndex = 0; pluginVersionStringTokenizer.hasMoreTokens() && pluginVersionIndex < 3; ++pluginVersionIndex) {
                    pluginVersionNumbersArray[pluginVersionIndex] = Integer.valueOf(pluginVersionStringTokenizer.nextToken());
                }
                int[] thisVersionNumbersArray = new int[3];
                StringTokenizer thisVersionStringTokenizer = new StringTokenizer(thisVersion, ".");
                for (int thisVersionIndex = 0; thisVersionStringTokenizer.hasMoreTokens() && thisVersionIndex < 3; ++thisVersionIndex) {
                    thisVersionNumbersArray[thisVersionIndex] = Integer.valueOf(thisVersionStringTokenizer.nextToken());
                }
                isGreaterThanOrEqualToCurrentVersion = pluginVersionNumbersArray[0] >= thisVersionNumbersArray[0];
                if (isGreaterThanOrEqualToCurrentVersion && pluginVersionNumbersArray[0] == thisVersionNumbersArray[0]) {
                    isGreaterThanOrEqualToCurrentVersion = pluginVersionNumbersArray[1] >= thisVersionNumbersArray[1];
                }
                if (isGreaterThanOrEqualToCurrentVersion && pluginVersionNumbersArray[1] == thisVersionNumbersArray[1]) {
                    isGreaterThanOrEqualToCurrentVersion = pluginVersionNumbersArray[2] >= thisVersionNumbersArray[2];
                }
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return isGreaterThanOrEqualToCurrentVersion;
    }

    public static Date getUserCurrentDateTime(ApplicationUser applicationUser) {
        Calendar calendar = Calendar.getInstance(JiraUtils.getCurrentUserTimeZone(applicationUser), JiraUtils.getUserLocale(applicationUser));
        return ISUtilities.convertDateToCertianTimeZone(calendar.getTime(), JiraUtils.getCurrentUserTimeZone(applicationUser));
    }

    public static Locale getUserLocale(ApplicationUser applicationUser) {
        String defaultLocale = GeneralUtil.getGlobalSettings().getGlobalDefaultLocale();
        return new Locale(defaultLocale);
    }

    public static TimeZone getCurrentUserTimeZone(ApplicationUser applicationUser) {
        Object timeZoneInfo = null;
        try {
            UserPreferencesManager userPreferencesManager = (UserPreferencesManager)ComponentLocator.getComponent(UserPreferencesManager.class);
            ExtendedPreferences extPref = userPreferencesManager.getExtendedPreferences(applicationUser);
            String userTimeZone = extPref.getText("jira.user.timezone");
            com.atlassian.confluence.core.TimeZone timeZone = com.atlassian.confluence.core.TimeZone.getInstance((String)userTimeZone);
            return timeZone.getWrappedTimeZone();
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
            return timeZoneInfo != null ? TimeZone.getTimeZone(timeZoneInfo.getTimeZoneId()) : null;
        }
    }

    public static String getPluginVersion() {
        PluginAccessor pluginAccessor = (PluginAccessor)ComponentLocator.getComponent(PluginAccessor.class);
        return pluginAccessor.getPlugin("com.infosysta.confluence.arabic-for-confluence").getPluginInformation().getVersion();
    }

    public static String getJiraVersionNumber() {
        return GeneralUtil.getVersionNumber();
    }

    public static String getOperatingSystem() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getOperatingSystemArch() {
        return System.getProperty("os.arch");
    }

    public static String getHomeDownloadDirectory() {
        return System.getProperty("user.home").concat(File.separator).concat("Downloads").concat(File.separator);
    }

    public static String getJiraHomeDirectory() {
        return System.getProperty("user.dir");
    }

    public static boolean isJiraEightOrGreater() {
        return JiraUtils.isGreaterThanOrEqualTo(JiraUtils.getJiraVersionNumber(), "8.0.0");
    }
}

