/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.servlets;

import com.atlassian.conf.logger.ISLogger;
import com.atlassian.conf.servlets.LicenseChecker;
import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InputStreamAttachmentResource;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class Servlet_UploadRecord
extends HttpServlet {
    private static final String KEY_PAGE_ID = "pageId";
    private static final String KEY_RECORD_NAME = "recordName";
    private final PageManager pageManager;
    private final FileUploadManager fileUploadManager;
    private PluginLicenseManager pluginLicenseManager = null;

    public Servlet_UploadRecord(PageManager pageManager, FileUploadManager fileUploadManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.pageManager = pageManager;
        this.fileUploadManager = fileUploadManager;
        this.pluginLicenseManager = pluginLicenseManager;
        ThemeManager themeManager = (ThemeManager)ComponentAccessor.getOSGiComponentInstanceOfType(ThemeManager.class);
        themeManager.setGlobalTheme("");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            LicenseChecker licenseChecker = new LicenseChecker(this.pluginLicenseManager);
            if (licenseChecker.isLicenseValid()) {
                String pageId = req.getParameter(KEY_PAGE_ID);
                String recordName = req.getParameter(KEY_RECORD_NAME);
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List fileItemsList = upload.parseRequest(req);
                if (fileItemsList != null) {
                    for (FileItem fileItem : fileItemsList) {
                        if (fileItem.isFormField()) continue;
                        InputStream fileContent = fileItem.getInputStream();
                        Page page = this.pageManager.getPage(Long.valueOf(pageId).longValue());
                        InputStreamAttachmentResource resource = new InputStreamAttachmentResource((InputStream)new ByteArrayInputStream(fileItem.get()), recordName, "audio/mp3", (long)fileItem.get().length, "Added by Voice Recorder for Confluence");
                        this.fileUploadManager.storeResource((AttachmentResource)resource, (ContentEntityObject)page);
                    }
                }
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }
}

