/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.servlets;

import com.atlassian.conf.logger.ISLogger;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebServlet_General
extends HttpServlet {
    @ComponentImport
    private TemplateRenderer templateRenderer;
    @ComponentImport
    private LoginUriProvider loginUriProvider;

    public WebServlet_General(LoginUriProvider loginUriProvider, TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
        this.loginUriProvider = loginUriProvider;
    }

    protected void redirectTo(HttpServletResponse resp, String velocityTemplateFileName) {
        try {
            if (resp != null) {
                resp.setContentType("text/html;charset=utf-8");
                this.getTemplateRenderer().render(velocityTemplateFileName, (Writer)resp.getWriter());
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }

    protected void redirectToLogin(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.sendRedirect(this.getLoginUriProvider().getLoginUri(this.getUri(req)).toASCIIString());
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    protected LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    protected TemplateRenderer getTemplateRenderer() {
        return this.templateRenderer;
    }

    protected void sendOkResponse(HttpServletResponse resp, Object value) {
        this.sendResponse(resp, 200, value);
    }

    protected void sendResponse(HttpServletResponse resp, int status, Object value) {
        try {
            if (resp != null && value != null) {
                if (value instanceof JSONArray || value instanceof JSONObject) {
                    resp.setContentType("application/json");
                }
                resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
                resp.setStatus(status);
                PrintWriter printWriter = resp.getWriter();
                printWriter.append(value.toString());
                printWriter.flush();
                printWriter.close();
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }
}

