/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.components;

import com.atlassian.conf.logger.ISLogger;
import com.atlassian.conf.servlets.LicenseChecker;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.infosysta.components.TranslateCheck;
import java.util.TimerTask;

public class TranslateTask
extends TimerTask {
    private final PluginLicenseManager pluginLicenseManager;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final String ruModuleKey;
    private final String pluginKey;

    public TranslateTask(PluginLicenseManager pluginLicenseManager, PluginAccessor pluginAccessor, PluginController pluginController, String ruModuleKey, String pluginKey) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
        this.ruModuleKey = ruModuleKey;
        this.pluginKey = pluginKey;
    }

    @Override
    public void run() {
        try {
            boolean flag = false;
            try {
                this.pluginLicenseManager.getLicense();
                flag = true;
            }
            catch (Exception ex) {
                flag = false;
            }
            if (!flag) {
                return;
            }
            LicenseChecker licenseChecker = new LicenseChecker(this.pluginLicenseManager);
            boolean isTranslated = TranslateCheck.isTranslate(this.ruModuleKey, this.pluginAccessor);
            if (!licenseChecker.isLicenseValid() && isTranslated) {
                TranslateCheck.checkPlugin(this.ruModuleKey, this.pluginKey, this.pluginAccessor, this.pluginController);
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }
}

