var clearTable = function (e) {
    try {
        AJS.$("#table-body-words").children().remove();
        AJS.$("#send-to-infosysta-button").attr("disabled", "");
        AJS.$("#search-for").val("");
        AJS.$("#match-case").prop("checked", true);
    } catch (e) {
        debug(e);
    }
};

var onSearchFieldFocus = function (e) {
    try {
        AJS.$("#empty-serach-field-message").css({"visibility":"hidden"});
    } catch (e) {
        debug(e);
    }
};

var downloadNewSuggestedTranslations = function (e) {
    try {
        var translationJsonArray = getTranslationTableRowsJsonArray();
        var currentDate = new Date();

        var pom = document.createElement('a');
        pom.setAttribute('href', 'data:text/json;charset=utf-8,' + encodeURIComponent(JSON.stringify(translationJsonArray)));
        pom.setAttribute('download', 'arabic-translation-' + currentDate.toLocaleDateString() + '-' + currentDate.toLocaleTimeString() + ".json");
        pom.click();
    } catch (e) {
        debug(e);
    }
};

var getTranslationTableRowsJsonArray = function () {
    var translationJsonArray = [];
    try {
        AJS.$("#table-body-words").children('tr').each(function (index, row) {
            var translationKey = AJS.$(this).attr("id");
            var suggestedValue = AJS.$(row).find("#suggested-value-textarea").val();

            var translationJsonObject = {};
            translationJsonObject["propertyKey"]      = translationKey;
            translationJsonObject["propertyNewValue"] = suggestedValue;
            translationJsonArray.push(translationJsonObject);
        });
    } catch (e) {
        debug(e);
    }
    return translationJsonArray;
};

var searchForWords = function(e) {
    fillTranslationTable();
};

var fillWordsTable = function(foundWordsJsonArray) {
    try {
        if (foundWordsJsonArray != null) {
            if (foundWordsJsonArray.length > 0) {
                AJS.$("#send-to-infosysta-button").removeAttr("disabled");
            } else {
                AJS.$("#send-to-infosysta-button").attr("disabled", "");
            }

            var wordTableRowTemplate = AJS.$("#translation-table-row-template").html();

            Handlebars.registerPartial("wordRow", function(wordJsonObject){
                var wordTableRowCompiled = Handlebars.compile(wordTableRowTemplate);
                return wordTableRowCompiled(wordJsonObject);
            });

            var tableRowsTemplate         = AJS.$("#translation-table-rows-template").html();

            var tableRowsTemplateCompiled = Handlebars.compile(tableRowsTemplate);
            var tableRowsHtml             = tableRowsTemplateCompiled({"wordsJsonArray":foundWordsJsonArray});

            AJS.$("#table-body-words").children().remove();
            AJS.$("#table-body-words").append(tableRowsHtml);
        }
    } catch (e) {
        debug(e);
    }
};

var fillTranslationTable = function() {
    try {
        var word = AJS.$("#search-for").val();
        if (word != null && word != undefined && word != "" && word.length > 0) {
            AJS.$("#spinner-property-file").spin();
            jQuery.ajax({
                url: AJS.contextPath() + "/plugins/servlet/afc/TranslationSearchForWord",//WebServlet_AFC_TranslationPropertySearch
                data: {
                    query: word,
                    isMatchCase: AJS.$("#match-case").prop("checked")
                },
                type: "GET",
                error: function (jqXHR, textStatus, message) {
                    AJS.$("#spinner-property-file").spinStop();
                },
                success: function (response) {
                    fillWordsTable(response);
                },
                complete: function () {
                    AJS.$("#spinner-property-file").spinStop();
                }
            });
        } else {
            AJS.$("#empty-serach-field-message").css({"visibility":"visible"});
        }
    } catch (e) {
        debug(e);
    }
};

$(document).ready(function() {
    init();

    function init() {
        var isArabic = AJS.$("#tool-header").attr("isArabic");
        if (isArabic == 1) {
            AJS.$(".admin-heading").css({"direction":"rtl"});
        } else {
            AJS.$(".admin-heading").css({"direction":"ltr"});
        }
    }
});