/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.utils;

import com.atlassian.conf.logger.ISLogger;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;

public class ISUtilities {
    public static boolean isDevelopment() {
        return false;
    }

    public static String getBaseUrlWithContextPathIfFound() {
        String baseUrlWithContextPath = ISUtilities.getBaseUrl();
        try {
            String contextPath = ISUtilities.getContextPath();
            if (ISUtilities.isStringValid(contextPath) && ISUtilities.isStringValid(baseUrlWithContextPath) && !baseUrlWithContextPath.endsWith(contextPath)) {
                baseUrlWithContextPath = baseUrlWithContextPath.concat(contextPath);
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return baseUrlWithContextPath;
    }

    public static String getBaseUrl() {
        String baseUrl = null;
        try {
            baseUrl = GeneralUtil.getGlobalSettings().getBaseUrl();
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return baseUrl;
    }

    public static String getContextPath() {
        String contextPath = "";
        try {
            contextPath = ExecutingHttpRequest.get() != null ? ExecutingHttpRequest.get().getContextPath() : null;
            contextPath = contextPath == null ? "" : contextPath;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return contextPath;
    }

    public static String getDatabaseName() {
        return "Undefined";
    }

    public static Date convertDateToCertianTimeZone(Date currentDate, TimeZone newTimeZone) {
        Date convertedDate = null;
        try {
            if (currentDate != null && newTimeZone != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
                simpleDateFormat.setTimeZone(newTimeZone);
                String currentDateFormat = simpleDateFormat.format(currentDate);
                simpleDateFormat = new SimpleDateFormat();
                convertedDate = simpleDateFormat.parse(currentDateFormat);
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
            convertedDate = currentDate;
        }
        return convertedDate;
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static boolean isInteger(String value) {
        boolean isInteger = true;
        try {
            Integer.valueOf(value);
        }
        catch (Exception e) {
            isInteger = false;
        }
        return isInteger;
    }

    public static boolean isFloat(String value) {
        boolean isFloat = true;
        try {
            Float.valueOf(value);
        }
        catch (Exception e) {
            isFloat = false;
        }
        return isFloat;
    }

    public static boolean isDouble(String value) {
        boolean isDouble = true;
        try {
            Double.valueOf(value);
        }
        catch (Exception e) {
            isDouble = false;
        }
        return isDouble;
    }

    public static boolean isLong(String value) {
        boolean isLong = true;
        try {
            Long.valueOf(value);
        }
        catch (Exception e) {
            isLong = false;
        }
        return isLong;
    }

    public static long toLong(String value) {
        long longValue = 0L;
        try {
            if (ISUtilities.isLong(value)) {
                longValue = Long.valueOf(value);
            }
        }
        catch (Exception e) {
            longValue = 0L;
        }
        return longValue;
    }

    public static int toInt(String value) {
        return ISUtilities.toInt(value, 0);
    }

    public static int toInt(String value, int defaultValue) {
        int intValue = defaultValue;
        try {
            if (ISUtilities.isStringValid(value)) {
                intValue = Integer.valueOf(value);
            }
        }
        catch (Exception e) {
            intValue = defaultValue;
        }
        return intValue;
    }

    public static String toDisplayDate(long value) {
        String dateString = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            dateString = simpleDateFormat.format(new Date(value));
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return dateString;
    }

    public static String toDisplayDateTime(long value) {
        String dateString = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");
            dateString = simpleDateFormat.format(new Date(value));
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return dateString;
    }

    public static boolean toBoolean(Object value) {
        return ISUtilities.toBoolean(value, false);
    }

    public static boolean toBoolean(Object value, boolean defaultValue) {
        boolean booleanValue = defaultValue;
        try {
            if (value != null) {
                String booleanValue_Strg = String.valueOf(value);
                booleanValue = !booleanValue_Strg.isEmpty() && (booleanValue_Strg.equalsIgnoreCase("true") || booleanValue_Strg.equals("1") || booleanValue_Strg.equalsIgnoreCase("on"));
            }
        }
        catch (Exception e) {
            booleanValue = defaultValue;
        }
        return booleanValue;
    }

    public static JSONArray toJsonArray(String value) {
        JSONArray jsonArray = null;
        try {
            if (ISUtilities.isStringValid(value)) {
                jsonArray = new JSONArray(value);
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return jsonArray;
    }

    public static boolean isEqual(String value1, String value2) {
        return ISUtilities.isStringValid(value1) && ISUtilities.isStringValid(value2) && value1.equals(value2);
    }

    public static boolean isStringValid(String value) {
        boolean isStringValid = false;
        try {
            if (!(value == null || value.isEmpty() || value.equalsIgnoreCase("undefined") || value.equalsIgnoreCase("NaN") || value.equalsIgnoreCase("null"))) {
                isStringValid = true;
            }
        }
        catch (Exception e) {
            isStringValid = false;
        }
        return isStringValid;
    }
}

