/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.conf.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ISDebugLogger {
    private File logFile = null;
    private static ISDebugLogger debugLogger = null;

    private ISDebugLogger() {
    }

    public static ISDebugLogger getLogInstance() {
        if (debugLogger == null) {
            debugLogger = new ISDebugLogger();
        }
        return debugLogger;
    }

    private File getLogFile() {
        if (this.logFile == null) {
            try {
                this.logFile = new File("C:/Users/Mohamad/Desktop/log/JiraLog.log");
                if (!this.logFile.exists()) {
                    this.logFile.createNewFile();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.logFile;
    }

    public void logException(Exception exception) {
        if (exception != null) {
            try {
                String stringWriter = new String();
                PrintStream printStream = new PrintStream(stringWriter);
                exception.printStackTrace(printStream);
                String currentDateTime = this.getCurrentTime();
                StringBuilder builder = new StringBuilder(currentDateTime);
                builder.append(" ");
                builder.append("[Exception]");
                builder.append(" ");
                builder.append(stringWriter.toString());
                printStream.flush();
                printStream.close();
                this.log(null, builder.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public void logMethodLocation() {
        this.log("[Location] ", "", 4);
    }

    public void logMethodLocation(Object obj) {
        this.log("[Location] ", obj, 4);
    }

    public void log(String prefix, Object obj) {
        this.log(prefix, obj, 4);
    }

    private void log(String prefix, Object obj, int index) {
        try {
            FileWriter fileWriter = new FileWriter(this.getLogFile(), true);
            fileWriter.append("[");
            fileWriter.append(this.getCurrentTime());
            fileWriter.append("]");
            fileWriter.append(this.getMethodDetailsString(index));
            if (prefix != null && !prefix.isEmpty()) {
                fileWriter.append(prefix);
            }
            fileWriter.append(" ");
            obj = obj != null ? String.valueOf(obj) : null;
            fileWriter.append(String.valueOf(obj));
            fileWriter.append("\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getMethodDetailsString(int index) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StringBuilder builder = new StringBuilder();
        if (stackTraceElements != null && stackTraceElements.length > 1) {
            if (index == -1) {
                for (int i = 3; i < stackTraceElements.length && i <= 3; ++i) {
                    StackTraceElement stackTraceElementN = stackTraceElements[i];
                    if (stackTraceElementN == null || stackTraceElementN.getMethodName() == null || stackTraceElementN.getMethodName().contains("logMethodLocation") || stackTraceElementN.getMethodName().contains("logException") || stackTraceElementN.getMethodName().contains("ISDebugLogger")) continue;
                    builder.append(" [" + stackTraceElementN.getClassName() + "]");
                    builder.append(" [" + stackTraceElementN.getMethodName() + "]");
                    builder.append(" [" + stackTraceElementN.getLineNumber() + "]");
                }
            } else if (stackTraceElements.length >= index) {
                StackTraceElement stackTraceElementN = stackTraceElements[index];
                builder.append(" [" + stackTraceElementN.getClassName() + "]");
                builder.append(" [" + stackTraceElementN.getMethodName() + "]");
                builder.append(" [" + stackTraceElementN.getLineNumber() + "]");
            }
        }
        return builder.toString();
    }

    private String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm:ss");
        return simpleDateFormat.format(new Date(calendar.getTimeInMillis()));
    }
}

