/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.servlets;

import com.atlassian.conf.logger.ISLogger;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.infosysta.servlets.WebServlet_General;
import com.infosysta.utils.ISUtilities;
import com.infosysta.utils.UserUtils;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class WebServlet_AFC_TranslationView
extends WebServlet_General {
    @ComponentImport
    private final UserManager userManager;

    @Inject
    public WebServlet_AFC_TranslationView(LoginUriProvider loginUriProvider, TemplateRenderer templateRenderer, UserManager userManager) {
        super(loginUriProvider, templateRenderer);
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            if (this.getUserManager() != null) {
                String username = this.getUserManager().getRemoteUsername(req);
                if (ISUtilities.isStringValid(username) && this.getUserManager().isSystemAdmin(username)) {
                    this.redirectTo(resp, "templates/afc/translation/".concat(this.getScreenGuiFileName()));
                } else {
                    this.redirectToLogin(req, resp);
                }
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }

    private String getScreenGuiFileName() {
        if ("en".equalsIgnoreCase(UserUtils.getSelectedLanguage())) {
            return "afc-translation.vm";
        }
        return "afc-translation_ar.vm";
    }

    private UserManager getUserManager() {
        return this.userManager;
    }
}

