/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.conf.logger;

import com.atlassian.config.util.BootstrapUtils;
import com.infosysta.utils.ISUtilities;
import com.infosysta.utils.JiraUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class ISLogger {
    private static final String LOG_LEVLE_MISSING_DATA = "MISSING_DATA";
    private static final String LOG_LEVLE_INFO = "INFO";
    private static final String LOG_LEVLE_EXCEPTION = "EXCEPTION";
    private static ISLogger logger = null;

    private ISLogger() {
    }

    public static ISLogger getLogger() {
        if (logger == null) {
            logger = new ISLogger();
        }
        return logger;
    }

    public File getLogFile() {
        return this.getLogFile(false);
    }

    public File getLogFile(boolean addInfoLogAtCreation) {
        File logFile = null;
        try {
            String localHomeDirectoryPath = BootstrapUtils.getBootstrapManager().getApplicationHome();
            String logDirectoryPath = localHomeDirectoryPath.concat(File.separator).concat("logs");
            String logFileName = "afc-" + this.getCurrentDate() + ".log";
            logFile = new File(logDirectoryPath + File.separator + logFileName);
            if (!logFile.exists()) {
                logFile.createNewFile();
                if (addInfoLogAtCreation) {
                    this.writeInfoLog();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return logFile;
    }

    public void createLogFile() throws IOException {
        File logFile = this.getLogFile();
        if (!logFile.exists()) {
            logFile.createNewFile();
        }
    }

    public void writeLog(String logLevel, String logMessage) {
        String currentDate = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
        File logFile = this.getLogFile();
        try {
            PrintWriter logWriter = new PrintWriter(new FileWriter(logFile, true));
            logWriter.print("[" + currentDate + "] - [" + logLevel + "] ");
            logWriter.println(logMessage);
            logWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeIntoFile(String logMessage) {
        File logFile = this.getLogFile();
        try {
            PrintWriter logWriter = new PrintWriter(new FileWriter(logFile, true));
            logWriter.print(logMessage);
            logWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeInfoLog() {
        String currentDateTime = this.getCurrentDateTime();
        StringBuilder builder = new StringBuilder("[" + currentDateTime + "]");
        builder.append(" ");
        builder.append(this.getPluginAndJiraVersion());
        builder.append(" ");
        builder.append("[INFO]");
        builder.append(" ");
        builder.append(this.getMethodDetailsString(3));
        builder.append(" ");
        builder.append("\n");
        this.writeIntoFile(builder.toString());
    }

    public void writeInfoLog(Object log) {
        String currentDateTime = this.getCurrentDateTime();
        StringBuilder builder = new StringBuilder("[" + currentDateTime + "]");
        builder.append(" ");
        builder.append(this.getPluginAndJiraVersion());
        builder.append(" ");
        builder.append("[INFO]");
        builder.append(" ");
        builder.append(this.getMethodDetailsString(3));
        builder.append(" ");
        if (log != null) {
            builder.append(log);
        }
        builder.append("\n");
        this.writeIntoFile(builder.toString());
    }

    public void writeInfoLogForDebug(Object log) {
        String currentDateTime = this.getCurrentDateTime();
        StringBuilder builder = new StringBuilder("[" + currentDateTime + "]");
        builder.append(" ");
        builder.append(this.getPluginAndJiraVersion());
        builder.append(" ");
        builder.append("[INFO]");
        builder.append(" ");
        builder.append(this.getMethodDetailsString(3));
        builder.append(" ");
        if (log != null) {
            builder.append(log);
        }
        builder.append("\n");
        this.writeIntoFile(builder.toString());
    }

    public void writeMissingDataLog(String log) {
        String currentDateTime = this.getCurrentDateTime();
        StringBuilder builder = new StringBuilder("[" + currentDateTime + "]");
        builder.append(" ");
        builder.append(this.getPluginAndJiraVersion());
        builder.append(" ");
        builder.append("[MISSING_DATA]");
        builder.append(" ");
        builder.append(this.getMethodDetailsString(3));
        builder.append(" ");
        if (log != null) {
            builder.append(log);
        }
        builder.append("\n");
        this.writeIntoFile(builder.toString());
    }

    public void logException(Exception exception, String log) {
        if (exception != null) {
            try {
                StringWriter errors = new StringWriter();
                exception.printStackTrace(new PrintWriter(errors));
                String currentDateTime = this.getCurrentDateTime();
                StringBuilder builder = new StringBuilder("[" + currentDateTime + "]");
                builder.append(" ");
                builder.append(this.getPluginAndJiraVersion());
                builder.append(" ");
                builder.append(this.getMethodDetailsString(3));
                builder.append("\n");
                builder.append("[EXCEPTION]");
                builder.append(" ");
                if (exception != null) {
                    builder.append(exception.toString());
                    builder.append(" ");
                }
                if (log != null && !log.isEmpty()) {
                    builder.append(log);
                }
                builder.append(" ");
                builder.append(errors.toString());
                builder.append("\n");
                errors.flush();
                errors.close();
                this.writeIntoFile(builder.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private String getMethodDetailsString(int index) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StringBuilder builder = new StringBuilder();
        if (stackTraceElements != null && stackTraceElements.length > 1) {
            StackTraceElement stackTraceElementN;
            if (index == -1) {
                for (int i = 3; i < stackTraceElements.length && i <= 3; ++i) {
                    StackTraceElement stackTraceElementN2 = stackTraceElements[i];
                    if (stackTraceElementN2 == null || stackTraceElementN2.getMethodName() == null || stackTraceElementN2.getMethodName().contains("getMethodDetailsString") || stackTraceElementN2.getMethodName().contains("logException")) continue;
                    builder.append(" [" + stackTraceElementN2.getClassName() + "]");
                    builder.append(" [" + stackTraceElementN2.getMethodName() + "]");
                    builder.append(" [" + stackTraceElementN2.getLineNumber() + "]");
                }
            } else if (stackTraceElements.length >= index && (stackTraceElementN = stackTraceElements[index]) != null) {
                builder.append(" [" + stackTraceElementN.getClassName() + "]");
                builder.append(" [" + stackTraceElementN.getMethodName() + "]");
                builder.append(" [" + stackTraceElementN.getLineNumber() + "]");
            }
        }
        return builder.toString();
    }

    private String getPluginAndJiraVersion() {
        String version = null;
        try {
            version = "[".concat("V").concat("{P:").concat(JiraUtils.getPluginVersion()).concat("},{J:").concat(JiraUtils.getJiraVersionNumber()).concat("}]").concat("[DB:").concat(ISUtilities.getDatabaseName()).concat("]");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    private String getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(new Date(calendar.getTimeInMillis()));
    }

    private String getCurrentDateTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return simpleDateFormat.format(new Date(calendar.getTimeInMillis()));
    }
}

