/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.servlets;

import com.atlassian.conf.logger.ISLogger;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.infosysta.servlets.WebServlet_General;
import com.infosysta.utils.ISUtilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebServlet_AFC_TranslationPropertySearch
extends WebServlet_General {
    private static final String KEY_QUERY = "query";
    private static final String KEY_IS_MATCH_CASE = "isMatchCase";
    private static final String KEY_PROPERTY_KEY = "propertyKey";
    private static final String KEY_PROPERTY_VALUE = "propertyValue";
    private static final String KEY_PROPERTY_NEW_VALUE = "propertyNewValue";
    private static final String KEY_USER_NEW_TRANSLATION_JSON_ARRAY = "userNewTranslationJsonArray";

    public WebServlet_AFC_TranslationPropertySearch(LoginUriProvider loginUriProvider, TemplateRenderer templateRenderer) {
        super(loginUriProvider, templateRenderer);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String query = req.getParameter(KEY_QUERY);
            JSONArray matchedWordsJsonArray = new JSONArray();
            if (ISUtilities.isStringValid(query)) {
                boolean isMatchCase = ISUtilities.toBoolean(req.getParameter(KEY_IS_MATCH_CASE), true);
                JSONObject arabicPropertiesJsonObject = this.newArabicLanguagePropertiesAsJsonObject("arabic-properties.json");
                Iterator<String> keysItr = arabicPropertiesJsonObject.keys();
                String keyString = null;
                String valueString = null;
                JSONObject foundWordJsonObject = null;
                while (keysItr.hasNext()) {
                    String key = keysItr.next();
                    keyString = StringEscapeUtils.unescapeJava((String)key);
                    valueString = StringEscapeUtils.unescapeJava((String)arabicPropertiesJsonObject.optString(key, ""));
                    boolean isValidToAdd = false;
                    isValidToAdd = isMatchCase ? valueString.toString().trim().equals(query.trim()) : valueString.toString().trim().contains(query.trim());
                    if (!isValidToAdd) continue;
                    foundWordJsonObject = new JSONObject();
                    foundWordJsonObject.put(KEY_PROPERTY_KEY, keyString);
                    foundWordJsonObject.put(KEY_PROPERTY_VALUE, valueString.toString());
                    matchedWordsJsonArray.put(foundWordJsonObject);
                }
            }
            this.sendOkResponse(resp, matchedWordsJsonArray);
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }

    private JSONObject newArabicLanguagePropertiesAsJsonObject(String propertiesFileName) {
        JSONObject arabicLanguagePropertiesJsonObject = null;
        try {
            arabicLanguagePropertiesJsonObject = new JSONObject(this.getArabicPropertiesFileAsString(propertiesFileName));
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return arabicLanguagePropertiesJsonObject;
    }

    private String getArabicPropertiesFileAsString(String propertiesFileName) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getArabicPropertiesAsInputStream(propertiesFileName)));
            String line = null;
            StringBuilder arabicPropertiesStringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                arabicPropertiesStringBuilder.append(line);
            }
            return arabicPropertiesStringBuilder.toString();
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
            return null;
        }
    }

    private InputStream getArabicPropertiesAsInputStream(String propertiesFileName) {
        try {
            return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("infosysta/".concat(propertiesFileName));
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
            return null;
        }
    }
}

