/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.components;

import com.atlassian.conf.logger.ISLogger;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.infosysta.components.TranslateTask;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class TranslateInstallationListener
implements DisposableBean,
InitializingBean {
    private final EventPublisher eventPublisher;
    private final PluginLicenseManager pluginLicenseManager;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private static final String RU_PLUGIN_KEY = "com.infosysta.confluence.arabic-for-confluence";
    private static final String RU_MODULE_KEY_FULL = "com.infosysta.confluence.arabic-for-confluence:ar";
    private Timer timer = null;

    public TranslateInstallationListener(PluginAccessor pluginAccessor, PluginController pluginController, EventPublisher eventPublisher, PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
        this.eventPublisher = eventPublisher;
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @EventListener
    public void onPluginEnabledEvent(PluginEnabledEvent pluginEnabledEvent) {
    }

    public void destroy() throws Exception {
        this.stopTimer();
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.eventPublisher.register((Object)this);
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate((TimerTask)new TranslateTask(this.pluginLicenseManager, this.pluginAccessor, this.pluginController, RU_MODULE_KEY_FULL, RU_PLUGIN_KEY), new Date(), 10000L);
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }
}

