/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.components;

import com.atlassian.conf.logger.ISLogger;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import java.util.concurrent.TimeUnit;

public class TranslateCheck {
    public static boolean checkLicense(PluginLicenseManager pluginLicenseManager) {
        boolean result = false;
        try {
            Option optionPluginLicenses = pluginLicenseManager.getLicense();
            if (optionPluginLicenses != null && optionPluginLicenses.isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)optionPluginLicenses.get();
                result = pluginLicense.isValid() && pluginLicense.isActive();
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return result;
    }

    public static boolean isTranslate(String ruModuleKey, PluginAccessor pluginAccessor) {
        boolean result = false;
        try {
            ModuleDescriptor module = pluginAccessor.getEnabledPluginModule(ruModuleKey);
            result = module != null && module.isEnabled();
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return result;
    }

    public static void checkPlugin(String ruModuleKey, String ruPluginName, PluginAccessor pluginAccessor, PluginController pluginController) {
        try {
            Plugin plugin;
            ModuleDescriptor module = pluginAccessor.getEnabledPluginModule(ruModuleKey);
            if (module != null && !module.isEnabled()) {
                pluginController.enablePluginModule(ruModuleKey);
                TimeUnit.SECONDS.sleep(2L);
            }
            if ((plugin = pluginAccessor.getEnabledPlugin(ruPluginName)) != null) {
                pluginController.disablePlugin(ruPluginName);
                TimeUnit.SECONDS.sleep(2L);
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }
}

