/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.database.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.conf.logger.ISLogger;
import com.infosysta.database.manager.Condition;
import com.infosysta.utils.ISUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.java.ao.DBParam;
import net.java.ao.Entity;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class GeneralEntity<E extends Entity> {
    private ActiveObjects activeObjects = null;
    private Class<E> entityClasse = null;

    public GeneralEntity(Class<E> entityClasse, ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
        this.entityClasse = entityClasse;
    }

    public void dispose() {
        this.activeObjects = null;
        this.entityClasse = null;
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public E newEntity() {
        return (E)(this.getActiveObjects() != null ? (Entity)this.getActiveObjects().create(this.getEntityClasse(), new DBParam[0]) : null);
    }

    public void deleteFromDatabase(E entity) {
        try {
            if (this.getActiveObjects() != null && entity != null) {
                this.getActiveObjects().delete(new RawEntity[]{entity});
                entity = null;
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }

    public void deleteFromDatabase(String dbFiledName, Object fieldValue) {
        E attachmentsEntity = this.findEntityByCondition(dbFiledName, fieldValue);
        this.deleteFromDatabase(attachmentsEntity);
    }

    public E findEntityByCondition(String dbFiledName, Object fieldValue) {
        Entity iAttachmentsEntity = null;
        try {
            if (this.getActiveObjects() != null) {
                Query query = Query.select();
                query = fieldValue instanceof Integer || ISUtilities.isInteger(fieldValue + "") ? query.where(dbFiledName + " = ?", new Object[]{(int)Integer.valueOf(fieldValue + "")}) : (fieldValue instanceof Double || ISUtilities.isDouble(fieldValue + "") ? query.where(dbFiledName + " = ?", new Object[]{(double)Double.valueOf(fieldValue + "")}) : (fieldValue instanceof Float || ISUtilities.isFloat(fieldValue + "") ? query.where(dbFiledName + " = ?", new Object[]{Float.valueOf(Float.valueOf(fieldValue + "").floatValue())}) : (fieldValue instanceof Long || ISUtilities.isLong(fieldValue + "") ? query.where(dbFiledName + " = ?", new Object[]{(long)Long.valueOf(fieldValue + "")}) : (fieldValue instanceof String ? query.where(dbFiledName + " = ?", new Object[]{String.valueOf(fieldValue)}) : query.where(dbFiledName + " = ?", new Object[]{fieldValue})))));
                Entity[] iAttachmentsEntitiesArray = (Entity[])this.getActiveObjects().find(this.getEntityClasse(), query);
                if (iAttachmentsEntitiesArray != null && iAttachmentsEntitiesArray.length > 0) {
                    iAttachmentsEntity = iAttachmentsEntitiesArray[0];
                }
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return (E)iAttachmentsEntity;
    }

    protected E[] getEntitiesArrayWithConditions(Condition condition, String order) {
        return this.getEntitiesArrayWithConditions(condition != null ? condition.getOperation() : 1, condition, order);
    }

    protected E[] getEntitiesArrayWithConditions(int operation, Condition condition, String order) {
        return this.getEntitiesArrayWithConditions(operation, condition, order, null);
    }

    protected E[] getEntitiesArrayWithConditions(int operation, Condition condition, String order, String groupByPropertyId) {
        return this.getEntitiesArrayWithConditions(operation, condition.getConditionsMap(), order, groupByPropertyId);
    }

    protected E[] getEntitiesArrayWithConditions(int operation, HashMap<String, Object> fieldNameValueMap, String order, String groupByPropertyId) {
        Entity[] entitiesArray = null;
        try {
            if (fieldNameValueMap != null) {
                Query query;
                String cause;
                Condition condition = new Condition(this);
                StringBuilder causeStringBuilder = new StringBuilder();
                ArrayList<Object> whereList = new ArrayList<Object>();
                Iterator<String> keysItr = fieldNameValueMap.keySet().iterator();
                int i = 0;
                while (keysItr.hasNext()) {
                    cause = keysItr.next();
                    String where = fieldNameValueMap.get(cause) + "";
                    i = condition.appendConditionsValues(i, operation, whereList, where, cause, causeStringBuilder);
                }
                if (operation == 1 || operation == 4 || operation == 5) {
                    Query selectQuery = null;
                    selectQuery = ISUtilities.isStringValid(groupByPropertyId) ? Query.select((String)groupByPropertyId).group(groupByPropertyId) : Query.select();
                    query = selectQuery.where(causeStringBuilder.toString(), whereList.toArray());
                    if (order != null && !order.isEmpty()) {
                        query = query.order(order);
                    }
                    entitiesArray = (Entity[])this.getActiveObjects().find(this.getEntityClasse(), query);
                } else if (operation == 2 || operation == 3) {
                    cause = causeStringBuilder.toString();
                    Query query2 = query = cause.isEmpty() ? Query.select() : Query.select().where(causeStringBuilder.toString(), new Object[0]);
                    if (order != null && !order.isEmpty()) {
                        query = query.order(order);
                    }
                    entitiesArray = (Entity[])this.getActiveObjects().find(this.getEntityClasse(), query);
                }
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return entitiesArray;
    }

    public E[] runCustomQuery(String customQuery) {
        return (Entity[])this.getActiveObjects().find(this.getEntityClasse(), Query.select((String)customQuery));
    }

    protected E[] getEntitiesArrayWithLimitAndOffset(Condition condition, int limit, int offset, String orderBy, String groupByPropertyId) {
        Entity[] es = null;
        try {
            Query query;
            Query query2 = query = ISUtilities.isStringValid(groupByPropertyId) ? Query.select((String)groupByPropertyId).group(groupByPropertyId) : Query.select();
            if (condition != null) {
                condition.build();
                query.where(condition.getCauseString(), condition.getWhereList().toArray());
            }
            if (orderBy != null) {
                query = query.order(orderBy);
            }
            query.limit(limit).offset(offset);
            es = this.getActiveObjects() != null ? (Entity[])this.getActiveObjects().find(this.getEntityClasse(), query) : null;
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return es;
    }

    protected E[] getEntitiesArray() {
        return this.getEntitiesArray(null);
    }

    protected int getCount(Condition condition) {
        return this.getCount(condition, null);
    }

    public int getCount() {
        int count = 0;
        try {
            count = this.getActiveObjects().count(this.getEntityClasse());
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return count;
    }

    protected int getCount(Condition condition, String propertyId) {
        int count = 0;
        try {
            if (condition != null) {
                condition.setOperation(1);
                condition.build();
                Query query = null;
                query = propertyId != null && !propertyId.isEmpty() ? Query.select().group(propertyId).where(condition.getCauseString(), condition.getWhereList().toArray()) : Query.select().where(condition.getCauseString(), condition.getWhereList().toArray());
                count = this.getActiveObjects().count(this.getEntityClasse(), query);
                condition = null;
                query = null;
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return count;
    }

    protected E[] getEntitiesArray(String order) {
        Entity[] array = null;
        try {
            if (this.getActiveObjects() != null) {
                Query query = Query.select();
                if (ISUtilities.isStringValid(order)) {
                    query = query.order(order);
                }
                if (this.getEntityClasse() != null) {
                    array = (Entity[])this.getActiveObjects().find(this.getEntityClasse(), query);
                }
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return array;
    }

    protected Class<E> getEntityClasse() {
        return this.entityClasse;
    }

    protected Class<?> getFieldTypeById(String fieldId) {
        return null;
    }
}

