/*
 * Decompiled with CFR 0.152.
 */
package com.infosysta.database.manager;

import com.atlassian.conf.logger.ISLogger;
import com.infosysta.database.manager.DBDataTypes;
import com.infosysta.database.manager.GeneralEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Condition {
    public static final int OP_NONE = -1;
    public static final int OP_EQUAL = 1;
    public static final int OP_CONTAIN = 2;
    public static final int OP_IN = 3;
    public static final int OP_LESS_THAN = 4;
    public static final int OP_GREATER_THAN = 5;
    private List<Object> whereList = null;
    private String causeString = null;
    private int operation = -1;
    private HashMap<String, Object> fieldNameValueMap = new HashMap();
    private GeneralEntity generalEntity = null;

    public Condition(GeneralEntity generalEntity) {
        this(generalEntity, 1);
    }

    public Condition(GeneralEntity generalEntity, int operation) {
        this.generalEntity = generalEntity;
        this.setOperation(operation);
    }

    public void dispose() {
        if (this.fieldNameValueMap != null) {
            this.fieldNameValueMap.clear();
            this.fieldNameValueMap = null;
        }
        if (this.whereList != null) {
            this.whereList.clear();
            this.whereList = null;
        }
        this.causeString = null;
    }

    public void build() {
        this.buildConditionAsString(this.getOperation());
    }

    public void addCondition(String key, Object value) {
        this.fieldNameValueMap.put(key, value);
    }

    public HashMap<String, Object> getConditionsMap() {
        return this.fieldNameValueMap;
    }

    public List<Object> getWhereList() {
        if (this.whereList == null) {
            this.whereList = new ArrayList<Object>();
        }
        return this.whereList;
    }

    public void setWhereList(List<Object> whereList) {
        this.whereList = whereList;
    }

    public String getCauseString() {
        return this.causeString;
    }

    public void setCauseString(String causeString) {
        this.causeString = causeString;
    }

    public int appendConditionsValues(int index, int operation, List<Object> whereList, String where, String cause, StringBuilder causeStringBuilder) {
        try {
            if (where != null && !where.isEmpty()) {
                if (index > 0 && operation != 3) {
                    causeStringBuilder.append(" AND ");
                }
                causeStringBuilder.append(cause);
                switch (operation) {
                    case 1: {
                        causeStringBuilder.append(" = ? ");
                        this.appendValueToWhereList(whereList, cause, where);
                        break;
                    }
                    case 2: {
                        causeStringBuilder.append(" LIKE '%" + where + "%' ");
                        break;
                    }
                    case 3: {
                        causeStringBuilder.append(" IN (" + where + ") ");
                        break;
                    }
                    case 4: {
                        causeStringBuilder.append(" < ? ");
                        this.appendValueToWhereList(whereList, cause, where);
                        break;
                    }
                    case 5: {
                        causeStringBuilder.append(" > ? ");
                        this.appendValueToWhereList(whereList, cause, where);
                    }
                }
                ++index;
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
        return index;
    }

    private void buildConditionAsString(int operation) {
        StringBuilder causeStringBuilder = new StringBuilder();
        try {
            ArrayList<Object> whereList = new ArrayList<Object>();
            Iterator<String> keysItr = this.getConditionsMap().keySet().iterator();
            int i = 0;
            while (keysItr.hasNext()) {
                String cause = keysItr.next();
                String where = this.getConditionsMap().get(cause) + "";
                i = this.appendConditionsValues(i, operation, whereList, where, cause, causeStringBuilder);
            }
            this.setWhereList(whereList);
            this.setCauseString(causeStringBuilder.toString());
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }

    private void appendValueToWhereList(List<Object> whereList, String cause, Object where) {
        try {
            Class<?> fieldType = this.getGeneralEntity().getFieldTypeById(cause);
            DBDataTypes dbDataTypes = new DBDataTypes();
            if (dbDataTypes.isInteger(fieldType, cause, where)) {
                whereList.add(Integer.valueOf(where + ""));
            } else if (dbDataTypes.isDouble(fieldType, cause, where)) {
                whereList.add(Double.valueOf(where + ""));
            } else if (dbDataTypes.isFloat(fieldType, cause, where)) {
                whereList.add(Float.valueOf(where + ""));
            } else if (dbDataTypes.isLong(fieldType, cause, where)) {
                whereList.add(Long.valueOf(where + ""));
            } else if (dbDataTypes.isString(fieldType, cause, where)) {
                whereList.add(String.valueOf(where));
            } else {
                whereList.add(where);
            }
        }
        catch (Exception e) {
            ISLogger.getLogger().logException(e, null);
        }
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public GeneralEntity getGeneralEntity() {
        return this.generalEntity;
    }
}

