/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugins.rest.common.security.AuthenticationRequiredException;
import com.atlassian.plugins.rest.common.security.jersey.AccessType;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import java.util.Objects;

class AuthenticatedResourceFilter
implements ResourceFilter,
ContainerRequestFilter {
    @VisibleForTesting
    static final String DEFAULT_TO_LICENSED_ACCESS_FEATURE_KEY = "atlassian.rest.default.to.licensed.access.disabled";
    static final String DEFAULT_TO_SYSADMIN_ACCESS_FEATURE_KEY = "atlassian.rest.default.to.sysadmin.access.enabled";
    static final String IGNORE_ANONYMOUSALLOWED_ANNOTATION = "atlassian.rest.ignore.anonymousallowed.annotation.enabled";
    private final AbstractMethod abstractMethod;
    private final UserManager userManager;
    private final DarkFeatureManager darkFeatureManager;

    public AuthenticatedResourceFilter(AbstractMethod abstractMethod, UserManager userManager, DarkFeatureManager darkFeatureManager) {
        this.abstractMethod = Objects.requireNonNull(abstractMethod, "abstractMethod can't be null");
        this.userManager = Objects.requireNonNull(userManager, "userManager can't be null");
        this.darkFeatureManager = Objects.requireNonNull(darkFeatureManager, "featureFlagManager can't be null");
    }

    @Override
    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    @Override
    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    @Override
    public ContainerRequest filter(ContainerRequest request) {
        AccessType accessType = AccessType.getAccessType(this.abstractMethod);
        UserKey userKey = this.userManager.getRemoteUserKey();
        if (AccessType.EMPTY == accessType) {
            if (this.darkFeatureManager.isEnabledForAllUsers(DEFAULT_TO_SYSADMIN_ACCESS_FEATURE_KEY).orElse(false).booleanValue()) {
                if (this.userManager.isSystemAdmin(userKey)) {
                    return request;
                }
            } else {
                if (this.darkFeatureManager.isEnabledForAllUsers(DEFAULT_TO_LICENSED_ACCESS_FEATURE_KEY).orElse(false).booleanValue()) {
                    return request;
                }
                if (this.userManager.isLicensed(userKey)) {
                    return request;
                }
            }
        } else if (AccessType.SYSTEM_ADMIN_ONLY == accessType) {
            if (this.userManager.isSystemAdmin(userKey)) {
                return request;
            }
        } else if (AccessType.ADMIN_ONLY == accessType) {
            if (this.userManager.isAdmin(userKey) || this.userManager.isSystemAdmin(userKey)) {
                return request;
            }
        } else if (AccessType.LICENSED_ONLY == accessType) {
            if (this.userManager.isLicensed(userKey)) {
                return request;
            }
        } else if (AccessType.UNLICENSED_SITE_ACCESS == accessType) {
            if (this.userManager.isLicensed(userKey) || this.userManager.isLimitedUnlicensedUser(userKey)) {
                return request;
            }
        } else if (AccessType.ANONYMOUS_SITE_ACCESS == accessType) {
            if (userKey == null && this.userManager.isAnonymousAccessEnabled() || this.userManager.isLicensed(userKey) || this.userManager.isLimitedUnlicensedUser(userKey)) {
                return request;
            }
        } else {
            if (AccessType.UNRESTRICTED_ACCESS == accessType) {
                return request;
            }
            if (!this.darkFeatureManager.isEnabledForAllUsers(IGNORE_ANONYMOUSALLOWED_ANNOTATION).orElse(false).booleanValue() && AccessType.ANONYMOUS_ALLOWED == accessType) {
                return request;
            }
        }
        throw new AuthenticationRequiredException();
    }
}

