/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.runtime.impl;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.export.ModuleType;
import com.atlassian.plugin.spring.scanner.annotation.export.ServiceProperty;
import com.atlassian.plugin.spring.scanner.runtime.impl.ExportedSeviceManager;
import com.atlassian.plugin.spring.scanner.runtime.impl.util.AnnotationIndexReader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;

public class ServiceExporterBeanPostProcessor
implements DestructionAwareBeanPostProcessor,
InitializingBean {
    public static final String OSGI_SERVICE_SUFFIX = "_osgiService";
    static final String ATLASSIAN_DEV_MODE_PROP = "atlassian.dev.mode";
    private static final Logger log = LoggerFactory.getLogger(ServiceExporterBeanPostProcessor.class);
    private final boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
    private final BundleContext bundleContext;
    private ConfigurableListableBeanFactory beanFactory;
    private String profileName;
    private final ExportedSeviceManager serviceManager;
    private ImmutableMap<String, String[]> exports;

    public ServiceExporterBeanPostProcessor(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory) {
        this(bundleContext, beanFactory, new ExportedSeviceManager());
    }

    ServiceExporterBeanPostProcessor(BundleContext bundleContext, ConfigurableListableBeanFactory beanFactory, ExportedSeviceManager serviceManager) {
        this.bundleContext = bundleContext;
        this.beanFactory = beanFactory;
        this.profileName = null;
        this.serviceManager = serviceManager;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public void afterPropertiesSet() {
        ImmutableMap.Builder<String, String[]> exportBuilder = ImmutableMap.builder();
        Bundle bundle = this.bundleContext.getBundle();
        String[] profileNames = AnnotationIndexReader.splitProfiles(this.profileName);
        this.parseExportsForExportFile(exportBuilder, "exports", profileNames, bundle);
        if (this.isDevMode) {
            this.parseExportsForExportFile(exportBuilder, "dev-exports", profileNames, bundle);
        }
        this.exports = exportBuilder.build();
    }

    private void parseExportsForExportFile(ImmutableMap.Builder<String, String[]> exportBuilder, String exportFileName, String[] profileNames, Bundle bundle) {
        String[] defaultInterfaces = new String[]{};
        for (String fileToRead : AnnotationIndexReader.getIndexFilesForProfiles(profileNames, exportFileName)) {
            List<String> exportData = AnnotationIndexReader.readAllIndexFilesForProduct(fileToRead, bundle, this.bundleContext);
            for (String export : exportData) {
                String[] targetAndInterfaces = export.split("#");
                String target = targetAndInterfaces[0];
                String[] interfaces = targetAndInterfaces.length > 1 ? targetAndInterfaces[1].split(",") : defaultInterfaces;
                exportBuilder.put(target, interfaces);
            }
        }
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        if (this.serviceManager.hasService(bean)) {
            Object serviceBean;
            this.serviceManager.unregisterService(this.bundleContext, bean);
            String serviceName = this.getServiceName(beanName);
            if (this.beanFactory.containsBean(serviceName) && null != (serviceBean = this.beanFactory.getBean(serviceName))) {
                this.beanFactory.destroyBean(serviceName, serviceBean);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class[] interfaces = new Class[]{};
        ServiceProperty[] serviceProperties = new ServiceProperty[]{};
        Class beanTargetClass = AopUtils.getTargetClass((Object)bean);
        String beanClassName = beanTargetClass.getName();
        if (this.exports.containsKey(beanClassName) || this.isPublicComponent(beanTargetClass)) {
            if (this.exports.containsKey(beanClassName)) {
                String[] interfaceNames;
                ImmutableList.Builder interfaceBuilder = ImmutableList.builder();
                ClassLoader beanClassLoader = bean.getClass().getClassLoader();
                for (String interfaceName : interfaceNames = this.exports.get(beanClassName)) {
                    try {
                        Class<?> interfaceClass = beanClassLoader.loadClass(interfaceName);
                        interfaceBuilder.add(interfaceClass);
                    }
                    catch (ClassNotFoundException ecnf) {
                        log.warn("Cannot find class for export '" + interfaceName + "' of bean '" + beanName + "': " + ecnf);
                    }
                }
                interfaces = Iterables.toArray(interfaceBuilder.build(), Class.class);
            } else if (this.hasAnnotation(beanTargetClass, ModuleType.class)) {
                interfaces = beanTargetClass.getAnnotation(ModuleType.class).value();
                serviceProperties = beanTargetClass.getAnnotation(ModuleType.class).properties();
            } else if (this.hasAnnotation(beanTargetClass, ExportAsService.class)) {
                interfaces = beanTargetClass.getAnnotation(ExportAsService.class).value();
                serviceProperties = beanTargetClass.getAnnotation(ExportAsService.class).properties();
            } else if (this.hasAnnotation(beanTargetClass, ExportAsDevService.class)) {
                interfaces = beanTargetClass.getAnnotation(ExportAsDevService.class).value();
                serviceProperties = beanTargetClass.getAnnotation(ExportAsDevService.class).properties();
            }
            if (interfaces.length < 1 && (interfaces = beanTargetClass.getInterfaces()).length < 1) {
                interfaces = new Class[]{beanTargetClass};
            }
            try {
                ServiceRegistration serviceRegistration = this.serviceManager.registerService(this.bundleContext, bean, beanName, this.asMap(serviceProperties), interfaces);
                String serviceName = this.getServiceName(beanName);
                this.beanFactory.initializeBean((Object)serviceRegistration, serviceName);
            }
            catch (Exception e) {
                log.error("Unable to register bean '" + beanName + "' as an OSGi exported service", e);
            }
        }
        return bean;
    }

    private Map<String, Object> asMap(ServiceProperty[] properties) {
        return Arrays.stream(properties).collect(Collectors.toMap(ServiceProperty::key, ServiceProperty::value));
    }

    private boolean isPublicComponent(Class beanTargetClass) {
        return this.hasAnnotation(beanTargetClass, ModuleType.class) || this.hasAnnotation(beanTargetClass, ExportAsService.class) || this.hasAnnotation(beanTargetClass, ExportAsDevService.class) && this.isDevMode;
    }

    private boolean hasAnnotation(Class beanTargetClass, Class<? extends Annotation> annotationClass) {
        return beanTargetClass.isAnnotationPresent(annotationClass);
    }

    private String getServiceName(String beanName) {
        return beanName + OSGI_SERVICE_SUFFIX;
    }
}

