/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.plugins.rest.common.security.AdminOnly;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.LicensedOnly;
import com.atlassian.plugins.rest.common.security.SystemAdminOnly;
import com.atlassian.plugins.rest.common.security.UnlicensedSiteAccess;
import com.atlassian.plugins.rest.common.security.UnrestrictedAccess;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.api.model.AbstractResource;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

enum AccessType {
    EMPTY(new Class[0]),
    SYSTEM_ADMIN_ONLY(SystemAdminOnly.class, com.atlassian.annotations.security.SystemAdminOnly.class),
    ADMIN_ONLY(AdminOnly.class, com.atlassian.annotations.security.AdminOnly.class),
    LICENSED_ONLY(LicensedOnly.class, com.atlassian.annotations.security.LicensedOnly.class),
    UNLICENSED_SITE_ACCESS(UnlicensedSiteAccess.class, com.atlassian.annotations.security.UnlicensedSiteAccess.class),
    ANONYMOUS_SITE_ACCESS(AnonymousSiteAccess.class, com.atlassian.annotations.security.AnonymousSiteAccess.class),
    UNRESTRICTED_ACCESS(UnrestrictedAccess.class, com.atlassian.annotations.security.UnrestrictedAccess.class),
    ANONYMOUS_ALLOWED(AnonymousAllowed.class);

    private static final Map<String, AccessType> VALID_ANNOTATIONS;
    private final Class<? extends Annotation>[] annotationTypes;

    @SafeVarargs
    private AccessType(Class<? extends Annotation> ... annotationTypes) {
        this.annotationTypes = annotationTypes;
    }

    static AccessType getAccessType(AbstractMethod abstractMethod) {
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = abstractMethod::getMethod;
        supplierArray[1] = abstractMethod::getResource;
        supplierArray[2] = () -> AccessType.getPackage(abstractMethod);
        return Stream.of(supplierArray).map(Supplier::get).filter(Objects::nonNull).map(AccessType::extractFromAnnotation).filter(Objects::nonNull).findFirst().orElse(EMPTY);
    }

    private static AnnotatedElement getPackage(AbstractMethod abstractMethod) {
        Method method = abstractMethod.getMethod();
        if (method != null) {
            return method.getDeclaringClass().getPackage();
        }
        AbstractResource resource = abstractMethod.getResource();
        if (resource != null) {
            return resource.getResourceClass().getPackage();
        }
        return null;
    }

    private static AccessType extractFromAnnotation(AnnotatedElement annotatedElement) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = annotatedElement.getAnnotations()) {
            String annotationType = annotation.annotationType().getName();
            if (!VALID_ANNOTATIONS.containsKey(annotationType)) continue;
            return VALID_ANNOTATIONS.get(annotationType);
        }
        return null;
    }

    static {
        VALID_ANNOTATIONS = Arrays.stream(AccessType.values()).filter(accessType -> accessType.annotationTypes != null).flatMap(accessType -> Arrays.stream(accessType.annotationTypes).map(annotationType -> Pair.of((Object)annotationType.getName(), (Object)accessType))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }
}

