/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.rest;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.hivestone.confluence.plugins.hcms.rest.HivestoneFindReplaceBandanaContext;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/book")
public class FindReplaceService {
    private static final Logger LOG = Logger.getLogger(FindReplaceService.class);
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private SpaceManager spaceManager;
    private ApplicationProperties applicationProperties;
    private MultiQueueTaskManager taskManager;
    private UserManager userManager;
    private PluginLicenseManager pluginLicenseManager;
    private BandanaManager bandanaManager;
    private AttachmentManager attachmentManager;
    private ImportExportManager importExportManager;
    private GateKeeper gateKeeper;

    @Autowired
    public FindReplaceService(@ComponentImport PageManager pageManager, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport MultiQueueTaskManager taskManager, @ComponentImport UserManager userManager, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport BandanaManager bandanaManager) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.applicationProperties = applicationProperties;
        this.taskManager = taskManager;
        this.userManager = userManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.bandanaManager = bandanaManager;
    }

    @POST
    @Path(value="/findrequest/post-for-spacekey-searchterm-options/")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response PostFindRequest(@FormParam(value="spacekey") String spaceKey, @FormParam(value="searchterm") String searchterm, @FormParam(value="options") String options, @FormParam(value="pageid") String pageId) {
        LOG.debug((Object)("Got the post find request. Getting status spacekey:searchterm:options " + spaceKey + ":" + searchterm + ":" + options));
        Response res = this.FindRequest(spaceKey, searchterm, options, pageId);
        return res;
    }

    @GET
    @Path(value="/findrequest/for-spacekey-searchterm-options/{spacekey}/{searchterm}/{options}/{pageid}")
    @Produces(value={"application/xml", "application/json"})
    public Response FindRequest(@PathParam(value="spacekey") String spaceKey, @PathParam(value="searchterm") String searchterm, @PathParam(value="options") String options, @PathParam(value="pageid") String pageId) {
        LOG.debug((Object)("Got the find request. Getting status spacekey:searchterm:options " + spaceKey + ":" + searchterm + ":" + options));
        searchterm = searchterm.replaceAll("HIVE_FSLASH", "/");
        searchterm = searchterm.replaceAll("HIVE_BSLASH", "\\\\");
        searchterm = searchterm.replaceAll("HIVE_HASH", "#");
        searchterm = searchterm.replaceAll("HIVE_QMARK", "?");
        searchterm = searchterm.replaceAll("HIVE_AMP", "&");
        String pagelist = "";
        JSONArray hierArray = new JSONArray();
        try {
            Space space = this.spaceManager.getSpace(spaceKey);
            Page homePage = space.getHomePage();
            Page rootPage = this.pageManager.getPage(Long.parseLong(pageId));
            List pageList = rootPage.getSortedChildren();
            JSONObject tree = new JSONObject();
            JSONArray pageArray = new JSONArray();
            JSONObject childObject = new JSONObject();
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
                if (license.getError().isDefined()) {
                    String err = "You do not have valid license for 'Find and Replace Utility' plugin. Please purchase or renew your license.";
                    err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                    JSONObject treeObject = new JSONObject();
                    treeObject.put("title", (Object)err);
                    treeObject.put("id", (Object)"00000");
                    treeObject.put("count", 0);
                    treeObject.put("children", (Object)childObject);
                    pageArray.put((Object)treeObject);
                    pagelist = pageArray.toString();
                    return Response.ok((Object)pagelist).build();
                }
            } else {
                String err = "You does not have valid license for 'Find and Replace Utility' plugin. Please purchase or renew your license.";
                JSONObject treeObject = new JSONObject();
                treeObject.put("title", (Object)err);
                treeObject.put("id", (Object)"0000");
                treeObject.put("count", 0);
                treeObject.put("children", (Object)childObject);
                pageArray.put((Object)treeObject);
                pagelist = pageArray.toString();
                return Response.ok((Object)pagelist).build();
            }
            JSONObject optionObj = new JSONObject(options);
            boolean isCase = optionObj.getBoolean("option-ic");
            boolean isExactWord = optionObj.getBoolean("option-ew");
            boolean ishtmlContent = optionObj.getBoolean("option-sf");
            boolean isPageTitleOnly = optionObj.getBoolean("option-po");
            searchterm = Pattern.quote(searchterm);
            if (isExactWord) {
                searchterm = "\\b" + searchterm + "\\b";
            }
            if (isCase) {
                searchterm = "(?i)" + searchterm;
            }
            String homePageCount = "";
            if (rootPage.isHomePage()) {
                homePageCount = "(Home Page) ";
            }
            tree.put("title", (Object)rootPage.getTitle());
            tree.put("id", rootPage.getId());
            int pageCount = this.findResult(rootPage, searchterm, ishtmlContent, isPageTitleOnly);
            homePageCount = homePageCount + String.valueOf(pageCount);
            tree.put("count", (Object)homePageCount);
            int count = 0;
            for (Page page : pageList) {
                int page_pos = count;
                if (page_pos == count) {
                    childObject = this.getChildren(page, searchterm, ishtmlContent, isPageTitleOnly);
                    pageArray.put((Object)childObject);
                } else {
                    for (Page spage : pageList) {
                        int spage_pos = spage.getPosition();
                        if (spage_pos != count) continue;
                        childObject = this.getChildren(spage, searchterm, ishtmlContent, isPageTitleOnly);
                        pageArray.put((Object)childObject);
                    }
                }
                ++count;
            }
            tree.put("children", (Object)pageArray);
            hierArray.put((Object)tree);
            LOG.debug((Object)("Find Result :" + pagelist));
        }
        catch (JSONException e) {
            LOG.error((Object)"Find : Could not create pagelist JSON", (Throwable)e);
        }
        catch (Exception e1) {
            LOG.error((Object)"ERROR:FindRequest:", (Throwable)e1);
        }
        LOG.debug((Object)"Find request complete . Sending page list");
        return Response.ok((Object)hierArray.toString()).build();
    }

    public JSONObject getChildren(Page page, String searchterm, boolean ishtmlContent, boolean isPageTitleOnly) {
        JSONArray pageArray = new JSONArray();
        JSONObject tree = new JSONObject();
        JSONObject childObject = new JSONObject();
        try {
            tree.put("title", (Object)page.getTitle());
            tree.put("id", page.getId());
            int pageCount = this.findResult(page, searchterm, ishtmlContent, isPageTitleOnly);
            tree.put("count", pageCount);
            if (page.hasChildren()) {
                List pageList = page.getSortedChildren();
                int count = 0;
                for (Page cpage : pageList) {
                    int page_pos = count;
                    if (page_pos == count) {
                        childObject = this.getChildren(cpage, searchterm, ishtmlContent, isPageTitleOnly);
                        pageArray.put((Object)childObject);
                    } else {
                        for (Page spage : pageList) {
                            int spage_pos = spage.getPosition();
                            if (spage_pos != count) continue;
                            childObject = this.getChildren(spage, searchterm, ishtmlContent, isPageTitleOnly);
                            pageArray.put((Object)childObject);
                        }
                    }
                    ++count;
                }
            }
            tree.put("children", (Object)pageArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return tree;
    }

    @POST
    @Path(value="/replacerequest/post-for-spacekey-searchterm-replaceterm-chapterids-options/")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response PostReplaceRequest(@FormParam(value="spacekey") String spaceKey, @FormParam(value="searchterm") String searchterm, @FormParam(value="replaceterm") String replaceterm, @FormParam(value="chapterids") String chapterList, @FormParam(value="options") String options) {
        LOG.debug((Object)("Got the replace POST request. Getting status spacekey:searchterm:replaceterm:chapterids:options " + spaceKey + ":" + searchterm + ":" + replaceterm + ":" + chapterList + ":" + options));
        Response res = this.ReplaceRequest(spaceKey, searchterm, replaceterm, chapterList, options);
        return res;
    }

    @GET
    @Path(value="/replacerequest/for-spacekey-searchterm-replaceterm-chapterids-options/{spacekey}/{searchterm}/{replaceterm}/{chapterids}/{options}")
    @Produces(value={"application/xml", "application/json"})
    public Response ReplaceRequest(@PathParam(value="spacekey") String spaceKey, @PathParam(value="searchterm") String searchterm, @PathParam(value="replaceterm") String replaceterm, @PathParam(value="chapterids") String chapterList, @PathParam(value="options") String options) {
        LOG.debug((Object)("Got the replace request. Getting status spacekey:searchterm:replaceterm:chapterids:options " + spaceKey + ":" + searchterm + ":" + replaceterm + ":" + chapterList + ":" + options));
        searchterm = searchterm.replaceAll("HIVE_FSLASH", "/");
        searchterm = searchterm.replaceAll("HIVE_BSLASH", "\\");
        searchterm = searchterm.replaceAll("HIVE_HASH", "#");
        replaceterm = replaceterm.replaceAll("HIVE_FSLASH", "/");
        replaceterm = replaceterm.replaceAll("HIVE_HASH", "#");
        JSONObject obj = new JSONObject();
        String username = this.userManager.getRemoteUser().getUsername();
        UserProfile user = this.userManager.getUserProfile(username);
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err2 = "You do not have valid license for 'Find and Replace Utility' plugin. Please purchase or renew your license.";
                err2 = err2 + "Error:" + ((LicenseError)license.getError().get()).toString();
                this.licenseError(err2, user, spaceKey);
                try {
                    obj.put("totalcount", 0);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return Response.ok((Object)obj.toString()).build();
            }
        } else {
            String err = "You do not have valid license for 'Find and Replace Utility' plugin. Please purchase or renew your license.";
            this.licenseError(err, user, spaceKey);
            try {
                obj.put("totalcount", 0);
            }
            catch (JSONException err2) {
                // empty catch block
            }
            return Response.ok((Object)obj.toString()).build();
        }
        try {
            int totalReplacement = 0;
            StringBuilder msg = new StringBuilder();
            msg.append("<style>  .text{padding:5px 5px 5px 10px;margin-bottom:4px;color:rgb(72,156,223);}  </style>");
            msg.append("<h3 style=\"text-align:center;\">Find & Replace Summary</h3><br/>");
            msg.append("Spacekey : " + spaceKey + "<br/>Search Text : " + searchterm + "<br/>Replace Text : " + replaceterm);
            HivestoneFindReplaceBandanaContext hfrbc = new HivestoneFindReplaceBandanaContext();
            String key = "__perm_level";
            String key1 = "__option_notify";
            String perm_level = (String)this.bandanaManager.getValue((BandanaContext)hfrbc, key);
            String option_notify = (String)this.bandanaManager.getValue((BandanaContext)hfrbc, key1);
            if (option_notify == null) {
                option_notify = "false";
            }
            if (perm_level == null) {
                perm_level = "edit-perm-user";
            }
            JSONObject optionObj = new JSONObject(options);
            boolean isCase = optionObj.getBoolean("option-ic");
            boolean isExactWord = optionObj.getBoolean("option-ew");
            boolean ishtmlContent = optionObj.getBoolean("option-sf");
            boolean isPageTitleOnly = optionObj.getBoolean("option-po");
            searchterm = Pattern.quote(searchterm);
            if (isExactWord) {
                searchterm = "\\b" + searchterm + "\\b";
            }
            if (isCase) {
                searchterm = "(?i)" + searchterm;
            }
            boolean replace_for_all_subpages = false;
            Space space = this.spaceManager.getSpace(spaceKey);
            int index = 0;
            if (chapterList.contains("replaceall")) {
                replace_for_all_subpages = true;
                String page_id = chapterList.replace("replaceall_", "");
                long pageid = Long.parseLong(page_id.trim());
                Page current_page = this.pageManager.getPage(pageid);
                if (current_page.isHomePage()) {
                    Page homePage = space.getHomePage();
                    for (Page page : homePage.getChildren()) {
                        String p_url;
                        ++index;
                        if (!this.permissionManager.hasPermission((User)((ConfluenceUserImpl)this.userManager.resolve(username)), Permission.EDIT, (Object)page)) {
                            p_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                            msg.append("<h4>" + index + ". " + p_url + " : Total Replacements : 0  NO EDIT PERMISSION</h4>");
                            continue;
                        }
                        if (perm_level.contains("admin-perm") && !this.permissionManager.hasPermission((User)((ConfluenceUserImpl)this.userManager.resolve(username)), Permission.ADMINISTER, (Object)space)) {
                            p_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                            msg.append("<h4>" + index + ". " + p_url + " : Total Replacements : 0  NO ADMIN PERMISSION (Site admin allowed replace only for space admins)</h4>");
                            continue;
                        }
                        String occurences = this.replaceResult(page, searchterm, replaceterm, ishtmlContent, isPageTitleOnly, replace_for_all_subpages);
                        int chapterReplaceCount = 0;
                        if (occurences != null && occurences.length() > 0 && occurences.contains("ReplacementCount")) {
                            Pattern p = Pattern.compile("ReplacementCount : (\\d+?)<ol>");
                            Matcher m = p.matcher(occurences);
                            while (m.find()) {
                                chapterReplaceCount += Integer.valueOf(m.group(1).trim()).intValue();
                            }
                        }
                        String page_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                        msg.append("<h4>" + index + ". " + page_url + " : Total Replacements : " + chapterReplaceCount + "</h4>");
                        LOG.debug((Object)("PageTitle:Occurences:" + page.getTitle() + chapterReplaceCount));
                        msg.append("<ol>" + occurences + "</ol>");
                        totalReplacement += chapterReplaceCount;
                    }
                } else {
                    ++index;
                    Page page = current_page;
                    if (!this.permissionManager.hasPermission((User)((ConfluenceUserImpl)this.userManager.resolve(username)), Permission.EDIT, (Object)page) || perm_level.contains("admin-perm") && !this.permissionManager.hasPermission((User)((ConfluenceUserImpl)this.userManager.resolve(username)), Permission.ADMINISTER, (Object)space)) {
                        if (perm_level.contains("admin-perm")) {
                            String p_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                            msg.append("<h4>" + index + ". " + p_url + " : Total Replacements : 0  NO ADMIN PERMISSION (Site admin allowed replace only for space admins)</h4>");
                        } else {
                            String p_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                            msg.append("<h4>" + index + ". " + p_url + " : Total Replacements : 0  NO EDIT PERMISSION</h4>");
                        }
                    } else {
                        String occurences = this.replaceResult(page, searchterm, replaceterm, ishtmlContent, isPageTitleOnly, replace_for_all_subpages);
                        int chapterReplaceCount = 0;
                        if (occurences != null && occurences.length() > 0 && occurences.contains("ReplacementCount")) {
                            Pattern p = Pattern.compile("ReplacementCount : (\\d+?)<ol>");
                            Matcher m = p.matcher(occurences);
                            while (m.find()) {
                                chapterReplaceCount += Integer.valueOf(m.group(1).trim()).intValue();
                            }
                        }
                        String page_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                        msg.append("<h4>" + index + ". " + page_url + " : Total Replacements : " + chapterReplaceCount + "</h4>");
                        LOG.debug((Object)("PageTitle:Occurences:" + page.getTitle() + chapterReplaceCount));
                        msg.append("<ol>" + occurences + "</ol>");
                        totalReplacement += chapterReplaceCount;
                    }
                }
            } else {
                for (String chapterid : chapterList.split("_")) {
                    ++index;
                    if (chapterid != null && !chapterid.equals("") && chapterid.matches("\\d+")) {
                        String p_url;
                        long pageid = Long.parseLong(chapterid.trim());
                        Page page = this.pageManager.getPage(pageid);
                        if (!this.permissionManager.hasPermission((User)((ConfluenceUserImpl)this.userManager.resolve(username)), Permission.EDIT, (Object)page)) {
                            p_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                            msg.append("<h4>" + index + ". " + p_url + " : Total Replacements : 0  NO EDIT PERMISSION</h4>");
                            continue;
                        }
                        if (perm_level.contains("admin-perm") && !this.permissionManager.hasPermission((User)((ConfluenceUserImpl)this.userManager.resolve(username)), Permission.ADMINISTER, (Object)space)) {
                            p_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                            msg.append("<h4>" + index + ". " + p_url + " : Total Replacements : 0  NO ADMIN PERMISSION (Site admin allowed replace only for space admins)</h4>");
                            continue;
                        }
                        String occurences = this.replaceResult(page, searchterm, replaceterm, ishtmlContent, isPageTitleOnly, replace_for_all_subpages);
                        int chapterReplaceCount = 0;
                        if (occurences != null && occurences.length() > 0 && occurences.contains("ReplacementCount")) {
                            Pattern p = Pattern.compile("ReplacementCount : (\\d+?)<ol>");
                            Matcher m = p.matcher(occurences);
                            while (m.find()) {
                                chapterReplaceCount += Integer.valueOf(m.group(1).trim()).intValue();
                            }
                        }
                        String page_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                        msg.append("<h4>" + index + ". " + page_url + " : Total Replacements : " + chapterReplaceCount + "</h4>");
                        LOG.debug((Object)("PageTitle:Occurences:" + page.getTitle() + chapterReplaceCount));
                        msg.append("<ol>" + occurences + "</ol>");
                        totalReplacement += chapterReplaceCount;
                        continue;
                    }
                    LOG.debug((Object)("Replace : Cannot find page reference for chapter id :" + (String)chapterid));
                }
            }
            obj.put("totalcount", totalReplacement);
            LOG.debug((Object)("Replace : Total Replacement " + totalReplacement));
            String smtp_from = user.getEmail();
            if (smtp_from.contains("@")) {
                smtp_from = smtp_from.substring(smtp_from.indexOf("@"));
                smtp_from = "no-reply" + smtp_from;
            }
            try {
                ConfluenceMailQueueItem findreplacemail = new ConfluenceMailQueueItem(user.getEmail(), "Confluence Find and Replace Summary [" + spaceKey + "]", msg.toString(), "text/html");
                if (option_notify.contains("false")) {
                    this.taskManager.addTask("mail", (Task & Serializable)() -> findreplacemail.send());
                }
                LOG.debug((Object)"Find Replace Mail Sending Done");
            }
            catch (Exception e) {
                ConfluenceMailQueueItem findreplacemail = new ConfluenceMailQueueItem(user.getEmail(), "Confluence Find and Replace Summary [" + spaceKey + "]", msg.toString(), "text/html");
                if (findreplacemail.getFromName() == null || findreplacemail.getFromName().isEmpty()) {
                    findreplacemail.setFromName("Confluence Wiki");
                }
                if (findreplacemail.getFromAddress() == null || findreplacemail.getFromAddress().isEmpty()) {
                    findreplacemail.setFromAddress(user.getEmail());
                }
                this.taskManager.addTask("mail", (Task & Serializable)() -> findreplacemail.send());
                LOG.error((Object)"ERROR:Replace:Error in sending mail", (Throwable)e);
            }
        }
        catch (JSONException e) {
            LOG.error((Object)"Replace : Could not create pagelist JSON", (Throwable)e);
        }
        catch (Exception e1) {
            LOG.error((Object)"ERROR:ReplaceRequest", (Throwable)e1);
        }
        LOG.debug((Object)"Replace operation complete .Sending page list");
        return Response.ok((Object)obj.toString()).build();
    }

    private int findResult(Page page, String searchText, boolean ishtmlContent, boolean isPageTitleOnly) {
        int count = 0;
        try {
            String pageBody = page.getBodyAsString();
            if (isPageTitleOnly) {
                pageBody = page.getTitle();
            }
            if (pageBody != "" && pageBody != null) {
                Pattern p = Pattern.compile(searchText);
                Matcher m = p.matcher(pageBody);
                if (ishtmlContent) {
                    m = p.matcher(pageBody.replaceAll("<[^>!]*>", ""));
                }
                while (m.find()) {
                    ++count;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error in find result for page " + page.getTitle()), (Throwable)e);
        }
        return count;
    }

    @GET
    @Path(value="/findrequest/status")
    @Produces(value={"application/xml", "application/json"})
    public Response Status() {
        JSONObject obj = new JSONObject();
        return Response.ok((Object)obj.toString()).build();
    }

    @GET
    @Path(value="/settings/fetch")
    @Produces(value={"application/xml", "application/json"})
    public Response Settings() {
        JSONObject obj = new JSONObject();
        HivestoneFindReplaceBandanaContext hfrbc = new HivestoneFindReplaceBandanaContext();
        String key = "__perm_level";
        String key1 = "__option_notify";
        String perm_level = (String)this.bandanaManager.getValue((BandanaContext)hfrbc, key);
        String option_notify = (String)this.bandanaManager.getValue((BandanaContext)hfrbc, key1);
        if (perm_level == null) {
            perm_level = "edit-perm-user";
        }
        if (option_notify == null) {
            option_notify = "false";
        }
        try {
            obj.put("replace-perm-user", (Object)perm_level);
            obj.put("option-notify", (Object)option_notify);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return Response.ok((Object)obj.toString()).build();
    }

    @POST
    @Path(value="/settings/save")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response SettingsSave(@FormParam(value="replace-perm-user") String permUser, @FormParam(value="user-perm") String user, @FormParam(value="option-notify") String option_notify, @FormParam(value="opt-notify") String opt_notify) {
        System.out.println("Replace:" + permUser + " User:" + user + " Notify:" + option_notify + " opt:" + opt_notify);
        HivestoneFindReplaceBandanaContext hfrbc = new HivestoneFindReplaceBandanaContext();
        String key = "__perm_level";
        String key1 = "__option_notify";
        this.bandanaManager.setValue((BandanaContext)hfrbc, key, (Object)user);
        this.bandanaManager.setValue((BandanaContext)hfrbc, key1, (Object)opt_notify);
        JSONObject obj = new JSONObject();
        return Response.ok((Object)obj.toString()).build();
    }

    private String replaceResult(Page page, String searchText, String replaceText, boolean ishtmlContent, boolean isPageTitleOnly, boolean replace_for_all_subpages) {
        LOG.debug((Object)("Starting replacement in page: " + page.getTitle() + " HtmlContent: " + ishtmlContent + " PageTitleOnly: " + isPageTitleOnly));
        String mailContent = "";
        try {
            String occurencesText = "";
            String pageBody = page.getBodyAsString();
            if (isPageTitleOnly) {
                pageBody = page.getTitle();
            }
            if (pageBody != null && pageBody != "") {
                Pattern p = Pattern.compile(searchText);
                Matcher m = p.matcher(page.getBodyAsString());
                if (isPageTitleOnly) {
                    m = p.matcher(page.getTitle());
                }
                StringBuffer updatedPageBody = new StringBuffer();
                int count = 0;
                int startindex = 0;
                while (m.find()) {
                    if (ishtmlContent) {
                        int endindex = pageBody.indexOf(m.group(), m.end()) != -1 ? pageBody.indexOf(m.group(), m.end()) : pageBody.length();
                        String pre = pageBody.substring(startindex, endindex);
                        if (pre.matches(".*?(<[^>!]*" + m.group() + ".*>).*$")) {
                            m.appendReplacement(updatedPageBody, m.group());
                        } else {
                            m.appendReplacement(updatedPageBody, replaceText);
                            ++count;
                            try {
                                int area = 150;
                                String surroundingText = pageBody.substring(m.end(), pageBody.length() >= m.end() + area ? m.end() + area : pageBody.length());
                                surroundingText = surroundingText.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                                surroundingText = "<li><div class = \"text\"><span style=\"background-color:yellow\">" + m.group() + "</span>" + surroundingText + "</div></li>";
                                occurencesText = occurencesText + surroundingText;
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Replace : Error in finding surrounding text");
                                LOG.error((Object)("ERROR:Replace:" + e.toString()));
                            }
                        }
                        startindex = m.end();
                        continue;
                    }
                    m.appendReplacement(updatedPageBody, replaceText);
                    ++count;
                    try {
                        int area = 150;
                        String surroundingText = pageBody.substring(m.end(), pageBody.length() >= m.end() + area ? m.end() + area : pageBody.length());
                        surroundingText = surroundingText.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                        surroundingText = "<li><div class = \"text\"><span style=\"background-color:yellow\">" + m.group() + "</span>" + surroundingText + "</div></li>";
                        occurencesText = occurencesText + surroundingText;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Replace : Error in finding surrounding text");
                        LOG.error((Object)("ERROR:Replace:" + e.toString()));
                    }
                }
                m.appendTail(updatedPageBody);
                if (count > 0) {
                    String page_url;
                    try {
                        Page originalPage = (Page)page.clone();
                        if (isPageTitleOnly) {
                            page.setTitle(updatedPageBody.toString());
                        } else {
                            page.setBodyAsString(updatedPageBody.toString());
                        }
                        LOG.debug((Object)"Now saving updated page content");
                        this.pageManager.saveContentEntity((ContentEntityObject)page, (ContentEntityObject)originalPage, null);
                        LOG.debug((Object)("Replace Result : Page updated : " + page.getTitle() + " Total replace count : " + count));
                        page_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                        mailContent = "<li>" + page_url + " : ReplacementCount : " + count + "<ol>" + occurencesText + "</ol>";
                    }
                    catch (Throwable e) {
                        LOG.error((Object)("Error in updating page:" + page.getTitle()), e);
                        page_url = "<a href=\"" + this.applicationProperties.getBaseUrl() + page.getUrlPath() + "\">" + page.getTitle() + "</a>";
                        mailContent = "<li>" + page_url + " : OccurencesCount : " + count + "<ol><li>Error in updating the page during replacement process</ol>";
                    }
                }
            } else {
                LOG.debug((Object)("Page body is empty or null for page " + page.getTitle()));
            }
            if (page.hasChildren() && replace_for_all_subpages) {
                mailContent = mailContent + "<ol><ol>";
                for (Page childPage : page.getChildren()) {
                    String childContent = this.replaceResult(childPage, searchText, replaceText, ishtmlContent, isPageTitleOnly, replace_for_all_subpages);
                    mailContent = mailContent + childContent;
                }
                mailContent = mailContent + "</ol></ol>";
            }
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR:ReplaceResult:", (Throwable)e);
        }
        mailContent = mailContent + "</li>";
        return mailContent.trim();
    }

    private void licenseError(String msg, UserProfile user, String spaceKey) {
        String smtp_from = user.getEmail();
        if (smtp_from.contains("@")) {
            smtp_from = smtp_from.substring(smtp_from.indexOf("@"));
            smtp_from = "no-reply" + smtp_from;
        }
        try {
            ConfluenceMailQueueItem findreplacemail = new ConfluenceMailQueueItem(user.getEmail(), "Find and Replace Summary [" + spaceKey + "]", msg.toString(), "text/html");
            if (findreplacemail.getFromName() == null || findreplacemail.getFromName().isEmpty()) {
                findreplacemail.setFromName("Confluence Wiki");
            }
            if (findreplacemail.getFromAddress() == null || findreplacemail.getFromAddress().isEmpty()) {
                findreplacemail.setFromAddress(smtp_from);
            }
            this.taskManager.addTask("mail", (Task & Serializable)() -> findreplacemail.send());
            LOG.debug((Object)"Find Replace Mail Sending Done");
        }
        catch (Exception e) {
            LOG.error((Object)"ERROR:Find replace report:Error in sending mail", (Throwable)e);
        }
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        LOG.debug((Object)("BandanaManager: " + this.bandanaManager));
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
        LOG.debug((Object)("PageManager: " + this.pageManager));
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
        LOG.debug((Object)("AttachmentManager: " + this.attachmentManager));
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
        LOG.debug((Object)("SpaceManager: " + this.spaceManager));
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        LOG.debug((Object)("PluginLicenseManager: " + this.pluginLicenseManager));
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
        LOG.debug((Object)("ImportExportManager: " + this.importExportManager));
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        LOG.debug((Object)("ApplicationProperties: " + this.applicationProperties));
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
        LOG.debug((Object)("GateKeeper: " + this.gateKeeper));
    }

    public void setMultiQueueTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
        LOG.debug((Object)("TaskManager: " + this.taskManager));
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
        LOG.debug((Object)("UserManager: " + this.userManager));
    }
}

