/*
 * Decompiled with CFR 0.152.
 */
package com.hivestone.confluence.plugins.hcms.rest;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.service.content.AttachmentService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/page_attach")
public class AttachmentsService {
    private static final Logger LOG = LoggerFactory.getLogger(AttachmentService.class);
    private PageManager pageManager;
    private PermissionManager permissionManager;
    private SpacePermissionManager spacePermissionManager;
    private AttachmentManager attachmentManager;
    private AttachmentService attachmentService;
    private SpaceManager spaceManager;
    private ApplicationProperties applicationProperties;
    private MultiQueueTaskManager taskManager;
    private UserManager userManager;
    private PluginLicenseManager pluginLicenseManager;
    private BandanaManager bandanaManager;
    private ImportExportManager importExportManager;
    private GateKeeper gateKeeper;

    public AttachmentsService(PageManager pageManager, PermissionManager permissionManager, SpaceManager spaceManager, ApplicationProperties applicationProperties, MultiQueueTaskManager taskManager, UserManager userManager, PluginLicenseManager pluginLicenseManager, AttachmentManager attachmentManager, SpacePermissionManager spacePermissionManager, AttachmentService attachmentService) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.spacePermissionManager = spacePermissionManager;
        this.spaceManager = spaceManager;
        this.applicationProperties = applicationProperties;
        this.taskManager = taskManager;
        this.userManager = userManager;
        this.pluginLicenseManager = pluginLicenseManager;
        this.attachmentManager = attachmentManager;
        this.attachmentService = attachmentService;
    }

    public AttachmentsService() {
        this.pageManager = OsgiServices.importOsgiService(PageManager.class);
        this.permissionManager = OsgiServices.importOsgiService(PermissionManager.class);
        this.spacePermissionManager = OsgiServices.importOsgiService(SpacePermissionManager.class);
        this.spaceManager = OsgiServices.importOsgiService(SpaceManager.class);
        this.applicationProperties = OsgiServices.importOsgiService(ApplicationProperties.class);
        this.taskManager = OsgiServices.importOsgiService(MultiQueueTaskManager.class);
        this.userManager = OsgiServices.importOsgiService(UserManager.class);
        this.pluginLicenseManager = OsgiServices.importOsgiService(PluginLicenseManager.class);
        this.attachmentManager = OsgiServices.importOsgiService(AttachmentManager.class);
        this.attachmentService = OsgiServices.importOsgiService(AttachmentService.class);
    }

    @GET
    @Path(value="/get_list/{spacekey}/{pageid}")
    @Produces(value={"application/xml", "application/json"})
    public Response GetPageAttachments(@PathParam(value="spacekey") String spaceKey, @PathParam(value="pageid") String pageId) {
        LOG.debug("Got the get_list request. spacekey:pageid " + spaceKey + ":" + pageId);
        JSONArray attachmentArray = new JSONArray();
        JSONArray errorArray = new JSONArray();
        String username = this.userManager.getRemoteUsername();
        UserProfile user = this.userManager.getUserProfile(username);
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            JSONObject errObject = new JSONObject();
            try {
                errObject.put("title", "Invalid License for 'Delete Unused Attachments' plugin");
                errObject.put("id", "1234");
                errorArray.put(errObject);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "You do not have valid license for 'Delete Unused Attachments' plugin. Please purchase or renew your license.";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                this.licenseError(err, user, spaceKey);
                return Response.ok((Object)errorArray.toString()).build();
            }
        } else {
            JSONObject errObject = new JSONObject();
            try {
                errObject.put("title", "Invalid License for 'Delete Unused Attachments' plugin");
                errObject.put("id", "1234");
                errorArray.put(errObject);
            }
            catch (JSONException license) {
                // empty catch block
            }
            String err = "You do not have valid license for 'Delete Unused Attachments' plugin. Please purchase or renew your license.";
            this.licenseError(err, user, spaceKey);
            return Response.ok((Object)errorArray.toString()).build();
        }
        try {
            Space space = this.spaceManager.getSpace(spaceKey);
            Page rootPage = this.pageManager.getPage(Long.parseLong(pageId));
            String body = rootPage.getBodyAsString();
            String body_nomarkup = rootPage.getBodyAsStringWithoutMarkup();
            body_nomarkup = StringEscapeUtils.unescapeHtml4((String)body);
            List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)rootPage);
            for (Attachment a : attachments) {
                String file_withoutext;
                String attach_file_name = a.getFileName();
                String attach_file_id = String.valueOf(a.getId());
                attach_file_name = attach_file_name.replaceAll("&", "&amp;");
                attach_file_name = attach_file_name.replaceAll(">", "&gt;");
                attach_file_name = attach_file_name.replaceAll("<", "&lt;");
                boolean isGliffy = a.getRenderedVersionComment().contains("GLIFFY");
                boolean usedGliffy = false;
                boolean usedId = false;
                if (body.contains(attach_file_id)) {
                    usedId = true;
                }
                if (isGliffy && body.contains(file_withoutext = a.getFileName().replace(".png", ""))) {
                    usedGliffy = true;
                }
                if (body.contains("\"" + attach_file_name + "\"") || body_nomarkup.contains(a.getFileName()) || this.checkPageVersions(rootPage, attach_file_name) || usedGliffy || usedId) continue;
                JSONObject aObject = new JSONObject();
                aObject.put("title", a.getFileName());
                aObject.put("id", String.valueOf(a.getId()));
                attachmentArray.put(aObject);
            }
        }
        catch (JSONException e) {
            LOG.error("ERROR:get_list:", e);
        }
        LOG.debug("get_list request complete . Sending attachment list");
        return Response.ok((Object)attachmentArray.toString()).build();
    }

    @POST
    @Path(value="/post_delete_attach")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response PostDeleteAttachmentRequest(@FormParam(value="spacekey") String spaceKey, @FormParam(value="pageid") String pageId, @FormParam(value="attachids") String attachIdList) {
        Response res = this.DeleteAttachmentRequest(spaceKey, pageId, attachIdList);
        return res;
    }

    @GET
    @Path(value="/delete_attach/{spacekey}/{pageid}/{attachids}")
    @Produces(value={"application/xml", "application/json"})
    public Response DeleteAttachmentRequest(@PathParam(value="spacekey") String spaceKey, @PathParam(value="pageid") String pageId, @PathParam(value="attachids") String attachIdList) {
        LOG.debug("Got the delete attachment request. spacekey:pageid:spageids " + spaceKey + ":" + pageId + ":" + attachIdList);
        JSONObject obj = new JSONObject();
        String username = this.userManager.getRemoteUsername();
        UserProfile user = this.userManager.getUserProfile(username);
        StringBuilder msg = new StringBuilder();
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            PluginLicense license = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            if (license.getError().isDefined()) {
                String err = "You does not have valid license for 'Delete Unused Attachments' plugin. Please purchase or renew your license.";
                err = err + "Error:" + ((LicenseError)license.getError().get()).toString();
                this.licenseError(err, user, spaceKey);
                return Response.status((Response.Status)Response.Status.OK).build();
            }
        } else {
            String err = "You does not have valid license for 'Delete Unused Attachments' plugin. Please purchase or renew your license.";
            this.licenseError(err, user, spaceKey);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        List listPerm = this.spaceManager.getSpace(spaceKey).getPermissions();
        boolean attach_del_perm = false;
        attach_del_perm = this.spacePermissionManager.hasPermission("REMOVEATTACHMENT", this.spaceManager.getSpace(spaceKey), AuthenticatedUserThreadLocal.get());
        if (this.spacePermissionManager.hasPermission("CREATEATTACHMENT", this.spaceManager.getSpace(spaceKey), AuthenticatedUserThreadLocal.get())) {
            attach_del_perm = true;
        }
        for (SpacePermission perm : listPerm) {
            if (!perm.getType().equals("REMOVE_OWN_CONTENT_PERMISSION")) continue;
            if (perm.getGroup() != null && this.userManager.isUserInGroup(username, perm.getGroup())) {
                attach_del_perm = true;
            }
            if (perm.getUserSubject() == null || !perm.getUserSubject().getName().equals(username)) continue;
            attach_del_perm = true;
        }
        String[] result = new String[1];
        msg.append("<style>  .text{padding:5px 5px 5px 10px;margin-bottom:4px;color:rgb(72,156,223);}  </style>");
        msg.append("<h3 style=\"text-align:center;\">Hivestone CMS</h3><br/>");
        msg.append("<h3 style=\"text-align:center;\">Delete Unused Attachments</h3><br/>");
        Page rootPage = this.pageManager.getPage(Long.parseLong(pageId));
        msg.append("Source Page of Attachments: <a href=\"" + this.applicationProperties.getBaseUrl() + rootPage.getUrlPath() + "\">" + rootPage.getTitle() + "</a><br/><br/><br/>");
        result[0] = attach_del_perm ? this.deleteAttachments(rootPage, attachIdList, "&nbsp;&nbsp;") : "\nYou do not have permission to delete page attachments of this space. Please contact your space admin.";
        msg.append(result[0]);
        try {
            ConfluenceMailQueueItem deletereportmail = new ConfluenceMailQueueItem(user.getEmail(), "Delete Unused Attachments [" + spaceKey + "]", msg.toString(), "text/html");
            this.taskManager.addTask("mail", (Task & Serializable)() -> deletereportmail.send());
        }
        catch (Exception e) {
            try {
                ConfluenceMailQueueItem deletereportmail = new ConfluenceMailQueueItem(user.getEmail(), "Delete Unused Attachments [" + spaceKey + "]", msg.toString(), "text/html");
                if (deletereportmail.getFromName() == null) {
                    deletereportmail.setFromName("Confluence Wiki");
                }
                if (deletereportmail.getFromAddress() == null) {
                    deletereportmail.setFromAddress(user.getEmail());
                }
                this.taskManager.addTask("mail", (Task & Serializable)() -> deletereportmail.send());
                LOG.error("ERROR:Delete unused attachments report:Error in sending mail", e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOG.debug("Delete attachments operation complete.");
        return Response.ok((Object)obj.toString()).build();
    }

    public String deleteAttachments(Page rootPage, String attachmentIdList, String indent) {
        String result = "";
        String child_result = "";
        List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)rootPage);
        for (Attachment a : attachments) {
            long id = a.getId();
            if (!attachmentIdList.contains(String.valueOf(id))) continue;
            result = result + indent + a.getFileName();
            try {
                Attachment temp_a = this.attachmentManager.getAttachment(id);
                if (temp_a != null) {
                    this.attachmentManager.trash(temp_a);
                }
                result = result + "    <font color=\"#00ff00\">DELETE Attachment SUCCESS</font><br/> ";
            }
            catch (Exception e) {
                try {
                    Content c_att = (Content)this.attachmentService.find(new Expansion[0]).withId(a.getContentId()).fetchOrNull();
                    if (c_att != null) {
                        this.attachmentService.delete(c_att);
                    }
                    result = result + "    <font color=\"#00ff00\">DELETE Attachment SUCCESS</font><br/> ";
                }
                catch (Exception ee) {
                    result = result + "    <font color=\"ff0000\">ERROR IN DELETE Attachment</font> " + ee.getMessage() + "<br/>";
                }
            }
        }
        if (attachmentIdList.contains("0000000_") && rootPage.hasChildren()) {
            List children = rootPage.getSortedChildren();
            for (Page child : children) {
                result = result + this.deleteChildPageAttachments(child, attachmentIdList, indent);
            }
        }
        return result;
    }

    public String deleteChildPageAttachments(Page rootPage, String attachmentIdList, String indent) {
        String result = "";
        String child_result = "";
        String body = rootPage.getBodyAsString();
        String body_nomarkup = rootPage.getBodyAsStringWithoutMarkup();
        body_nomarkup = StringEscapeUtils.unescapeHtml4((String)body);
        List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)rootPage);
        result = result + "<br/><br/>" + indent + "<a href=\"" + this.applicationProperties.getBaseUrl() + rootPage.getUrlPath() + "\">" + rootPage.getTitle() + "</a><br/>";
        for (Attachment a : attachments) {
            String file_withoutext;
            String attach_file_name = a.getFileName();
            String attach_file_id = String.valueOf(a.getId());
            attach_file_name = attach_file_name.replaceAll("&", "&amp;");
            attach_file_name = attach_file_name.replaceAll(">", "&gt;");
            attach_file_name = attach_file_name.replaceAll("<", "&lt;");
            boolean isGliffy = a.getRenderedVersionComment().contains("GLIFFY");
            boolean usedGliffy = false;
            boolean usedId = false;
            if (body.contains(attach_file_id)) {
                usedId = true;
            }
            if (isGliffy && body.contains(file_withoutext = a.getFileName().replace(".png", ""))) {
                usedGliffy = true;
            }
            if (body.contains("\"" + attach_file_name + "\"") || body_nomarkup.contains(a.getFileName()) || this.checkPageVersions(rootPage, attach_file_name) || usedGliffy || usedId) continue;
            result = result + indent + "&nbsp;&nbsp;" + a.getFileName();
            try {
                Attachment temp_a = this.attachmentManager.getAttachment((ContentEntityObject)rootPage, a.getFileName());
                if (temp_a != null) {
                    this.attachmentManager.trash(temp_a);
                }
                result = result + indent + "    <font color=\"#00ff00\">DELETE Attachment SUCCESS</font><br/> ";
            }
            catch (Exception e) {
                try {
                    Content c_att = (Content)this.attachmentService.find(new Expansion[0]).withId(a.getContentId()).fetchOrNull();
                    if (c_att != null) {
                        this.attachmentService.delete(c_att);
                    }
                    result = result + indent + "    <font color=\"#00ff00\">DELETE Attachment SUCCESS</font><br/> ";
                }
                catch (Exception ee) {
                    result = result + indent + "    <font color=\"ff0000\">ERROR IN DELETE Attachment</font> " + ee.getMessage() + "<br/>";
                }
            }
        }
        if (rootPage.hasChildren()) {
            List children = rootPage.getSortedChildren();
            for (Page child : children) {
                child_result = child_result + this.deleteChildPageAttachments(child, attachmentIdList, indent + "&nbsp;&nbsp;");
            }
        }
        result = result + child_result;
        return result;
    }

    public boolean checkPageVersions(Page latestPage, String attach_file) {
        boolean attach_used = false;
        String file_withoutext = attach_file.replace(".png", "");
        int version = latestPage.getPreviousVersion();
        for (int prev_version_page_count = 0; version > 0 && !attach_used && prev_version_page_count <= 6; ++prev_version_page_count) {
            Page prevPage = (Page)this.pageManager.getPageByVersion((AbstractPage)latestPage, version);
            if (prevPage == null) {
                return attach_used;
            }
            String body = prevPage.getBodyAsString();
            if (body.contains("\"" + attach_file + "\"") || body.contains(">" + file_withoutext + "<")) {
                attach_used = true;
            }
            version = prevPage.getPreviousVersion();
        }
        return attach_used;
    }

    @GET
    @Path(value="/delete/status")
    @Produces(value={"application/xml", "application/json"})
    public Response Status() {
        JSONObject obj = new JSONObject();
        return Response.ok((Object)obj.toString()).build();
    }

    private void licenseError(String msg, UserProfile user, String spaceKey) {
        try {
            ConfluenceMailQueueItem copyreportmail = new ConfluenceMailQueueItem(user.getEmail(), "Delete Unused Attachments [" + spaceKey + "]", msg.toString(), "text/html");
            copyreportmail.setFromName("Confluence Wiki");
            copyreportmail.setFromAddress(user.getEmail());
            this.taskManager.addTask("mail", (Task & Serializable)() -> copyreportmail.send());
            LOG.debug("Delete Unused Attachments Mail Sending Done");
        }
        catch (Exception e) {
            try {
                ConfluenceMailQueueItem copyreportmail = new ConfluenceMailQueueItem(user.getEmail(), "Delete Unused Attachments [" + spaceKey + "]", msg.toString(), "text/html");
                this.taskManager.addTask("mail", (Task & Serializable)() -> copyreportmail.send());
            }
            catch (Exception ee) {
                LOG.error("ERROR:Delete Unused Attachments:Error in sending mail", ee);
            }
        }
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
        LOG.debug("BandanaManager: " + this.bandanaManager);
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
        LOG.debug("PageManager: " + this.pageManager);
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
        LOG.debug("AttachmentManager: " + this.attachmentManager);
    }

    public void setAttachmentService(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
        LOG.debug("AttachmentService: " + this.attachmentService);
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
        LOG.debug("SpaceManager: " + this.spaceManager);
    }

    public void setImportExportManager(ImportExportManager importExportManager) {
        this.importExportManager = importExportManager;
        LOG.debug("ImportExportManager: " + this.importExportManager);
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        LOG.debug("ApplicationProperties: " + this.applicationProperties);
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
        LOG.debug("GateKeeper: " + this.gateKeeper);
    }

    public void setMultiQueueTaskManager(MultiQueueTaskManager taskManager) {
        this.taskManager = taskManager;
        LOG.debug("TaskManager: " + this.taskManager);
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
        LOG.debug("PluginLicenseManager: " + this.pluginLicenseManager);
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
        LOG.debug("UserManager: " + this.userManager);
    }
}

