/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.filter;

import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Provider
public class ExtensionJerseyFilter
implements ContainerRequestFilter {
    private static final String DOT = ".";
    private final Collection<Pattern> pathExcludePatterns;
    static final Map<String, String> EXTENSION_TO_ACCEPT_HEADER = new ImmutableMap.Builder<String, String>().put("txt", "text/plain").put("htm", "text/html").put("html", "text/html").put("json", "application/json").put("xml", "application/xml").put("atom", "application/atom+xml").build();

    public ExtensionJerseyFilter() {
        this.pathExcludePatterns = new LinkedList<Pattern>();
    }

    public ExtensionJerseyFilter(Collection<String> pathExcludePatterns) {
        Validate.notNull(pathExcludePatterns);
        this.pathExcludePatterns = this.compilePatterns(pathExcludePatterns);
    }

    @Override
    public ContainerRequest filter(ContainerRequest request) {
        String absoluteUri = request.getAbsolutePath().toString();
        String extension = StringUtils.substringAfterLast(absoluteUri, DOT);
        if (this.shouldFilter("/" + StringUtils.difference(request.getBaseUri().toString(), absoluteUri), extension)) {
            request.getRequestHeaders().putSingle((Object)"Accept", (Object)EXTENSION_TO_ACCEPT_HEADER.get(extension));
            String absoluteUriWithoutExtension = StringUtils.substringBeforeLast(absoluteUri, DOT);
            request.setUris(request.getBaseUri(), this.getRequestUri(absoluteUriWithoutExtension, (Map<String, List<String>>)request.getQueryParameters()));
        }
        return request;
    }

    private boolean shouldFilter(String restPath, String extension) {
        for (Pattern pattern : this.pathExcludePatterns) {
            if (!pattern.matcher(restPath).matches()) continue;
            return false;
        }
        return EXTENSION_TO_ACCEPT_HEADER.containsKey(extension);
    }

    private URI getRequestUri(String absoluteUriWithoutExtension, Map<String, List<String>> queryParams) {
        UriBuilder requestUriBuilder = UriBuilder.fromUri((String)absoluteUriWithoutExtension);
        for (Map.Entry<String, List<String>> queryParamEntry : queryParams.entrySet()) {
            for (String value : queryParamEntry.getValue()) {
                requestUriBuilder.queryParam(queryParamEntry.getKey(), new Object[]{value});
            }
        }
        return requestUriBuilder.build(new Object[0]);
    }

    private Collection<Pattern> compilePatterns(Collection<String> pathExcludePatterns) {
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        for (String pattern : pathExcludePatterns) {
            patterns.add(Pattern.compile(pattern));
        }
        return patterns;
    }
}

