/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.runtime.impl.util;

import com.atlassian.plugin.spring.scanner.ProductFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductFilterUtil {
    private static ProductFilterUtil INSTANCE;
    @VisibleForTesting
    static final String CLASS_ON_BAMBOO_CLASSPATH = "com.atlassian.bamboo.build.BuildExecutionManager";
    @VisibleForTesting
    static final String CLASS_ON_BITBUCKET_CLASSPATH = "com.atlassian.bitbucket.repository.RepositoryService";
    @VisibleForTesting
    static final String CLASS_ON_CONFLUENCE_CLASSPATH = "com.atlassian.confluence.core.ContentEntityManager";
    @VisibleForTesting
    static final String CLASS_ON_FECRU_CLASSPATH = "com.atlassian.fisheye.spi.services.RepositoryService";
    @VisibleForTesting
    static final String CLASS_ON_JIRA_CLASSPATH = "com.atlassian.jira.bc.issue.IssueService";
    @VisibleForTesting
    static final String CLASS_ON_REFAPP_CLASSPATH = "com.atlassian.refapp.api.ConnectionProvider";
    @VisibleForTesting
    static final String CLASS_ON_STASH_CLASSPATH = "com.atlassian.stash.repository.RepositoryService";
    private static final Logger log;
    private AtomicReference<ProductFilter> filterForProduct = new AtomicReference();
    private static final Map<String, ProductFilter> PRODUCTS_TO_HOSTCLASSES;

    private ProductFilterUtil() {
    }

    public static ProductFilter getFilterForCurrentProduct(@Nullable BundleContext bundleContext) {
        return ProductFilterUtil.getInstance().getFilterForProduct(bundleContext);
    }

    public ProductFilter getFilterForProduct(@Nullable BundleContext bundleContext) {
        ProductFilter productFilter = this.filterForProduct.get();
        if (productFilter == null) {
            this.filterForProduct.compareAndSet(productFilter, this.detectProduct(bundleContext));
            productFilter = this.filterForProduct.get();
        }
        return productFilter;
    }

    private ProductFilter detectProduct(BundleContext bundleContext) {
        if (bundleContext == null) {
            log.warn("Couldn't detect product due to null bundleContext: will use ProductFilter.ALL");
            return ProductFilter.ALL;
        }
        for (Map.Entry<String, ProductFilter> entry : PRODUCTS_TO_HOSTCLASSES.entrySet()) {
            if (!this.detectService(bundleContext, entry.getKey())) continue;
            log.debug("Detected product: " + entry.getValue().name());
            return entry.getValue();
        }
        log.warn("Couldn't detect product, no known services found: will use ProductFilter.ALL");
        return ProductFilter.ALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detectService(BundleContext bundleContext, String serviceClassName) {
        ServiceReference serviceReference = null;
        try {
            serviceReference = bundleContext.getServiceReference(serviceClassName);
            boolean bl = serviceReference != null;
            return bl;
        }
        finally {
            if (serviceReference != null) {
                bundleContext.ungetService(serviceReference);
            }
        }
    }

    private static ProductFilterUtil getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new ProductFilterUtil();
        }
        return INSTANCE;
    }

    static {
        log = LoggerFactory.getLogger(ProductFilterUtil.class);
        PRODUCTS_TO_HOSTCLASSES = ImmutableMap.builder().put(CLASS_ON_BAMBOO_CLASSPATH, ProductFilter.BAMBOO).put(CLASS_ON_BITBUCKET_CLASSPATH, ProductFilter.BITBUCKET).put(CLASS_ON_CONFLUENCE_CLASSPATH, ProductFilter.CONFLUENCE).put(CLASS_ON_FECRU_CLASSPATH, ProductFilter.FECRU).put(CLASS_ON_JIRA_CLASSPATH, ProductFilter.JIRA).put(CLASS_ON_REFAPP_CLASSPATH, ProductFilter.REFAPP).put(CLASS_ON_STASH_CLASSPATH, ProductFilter.STASH).build();
    }
}

