/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.event;

import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EventPredicates {
    private EventPredicates() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " should not be instantiated");
    }

    @Nonnull
    public static Predicate<Event> attributeEquals(String name, @Nullable Object value) {
        Objects.requireNonNull(name, "name");
        return event -> Objects.equals(value, event.getAttribute(name));
    }

    @Nonnull
    public static Predicate<Event> level(EventLevel ... levels) {
        Objects.requireNonNull(levels, "levels");
        if (levels.length == 0) {
            return event -> false;
        }
        ImmutableSet<EventLevel> acceptedLevels = ImmutableSet.copyOf(levels);
        return event -> acceptedLevels.contains(event.getLevel());
    }

    @Nonnull
    public static Predicate<Event> type(EventType type) {
        Objects.requireNonNull(type, "type");
        return event -> type.equals(event.getKey());
    }
}

