/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.RequirePermission;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequirePermission(value={"execute_java"})
public abstract class BaseServletModuleDescriptor<T>
extends AbstractModuleDescriptor<T> {
    protected static final Logger log = LoggerFactory.getLogger(BaseServletModuleDescriptor.class);
    private List<String> paths;
    private Map<String, String> initParams;
    private boolean asyncSupported;

    public BaseServletModuleDescriptor(ModuleFactory moduleCreator) {
        super(moduleCreator);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.checkPermissions();
        List<Element> urlPatterns = element.elements("url-pattern");
        this.paths = new ArrayList<String>(urlPatterns.size());
        for (Element element2 : urlPatterns) {
            this.paths.add(element2.getTextTrim());
        }
        this.initParams = new HashMap<String, String>();
        List<Element> paramsList = element.elements("init-param");
        for (Element initParamEl : paramsList) {
            Element paramNameEl = initParamEl.element("param-name");
            Element paramValueEl = initParamEl.element("param-value");
            this.initParams.put(paramNameEl.getTextTrim(), paramValueEl.getTextTrim());
        }
        Element element3 = element.element("async-supported");
        this.asyncSupported = element3 != null ? Boolean.valueOf(element3.getTextTrim()) : false;
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"url-pattern").withError("There must be at least one path specified")}).rule("init-param", new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"param-name").withError("Parameter name is required"), ValidationPattern.test((String)"param-value").withError("Parameter value is required")});
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }
}

