/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.error.jersey;

import com.atlassian.plugins.rest.common.error.jersey.UncaughtExceptionEntity;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ThrowableExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(ThrowableExceptionMapper.class);
    @Context
    Request request;

    public Response toResponse(Throwable t2) {
        if (t2 instanceof WebApplicationException) {
            WebApplicationException webEx = (WebApplicationException)t2;
            if (webEx.getResponse().getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                log.error("Server Error in REST: " + webEx.getResponse().getStatus() + ": " + webEx.getResponse(), t2);
            } else {
                log.debug("REST response: {}: {}", (Object)webEx.getResponse().getStatus(), (Object)webEx.getResponse());
            }
            return webEx.getResponse();
        }
        String errorId = UUID.randomUUID().toString();
        log.error("Uncaught exception " + errorId + " thrown by REST service: " + t2.getMessage(), t2);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new UncaughtExceptionEntity(t2, errorId)).type(UncaughtExceptionEntity.variantFor(this.request)).build();
    }
}

