/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.upgrade;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class PluginExportCompatibility {
    private final String currentVersion;
    private final String earliestVersion;

    public PluginExportCompatibility(String earliestVersion, String currentVersion) {
        this.currentVersion = Preconditions.checkNotNull(currentVersion);
        this.earliestVersion = Preconditions.checkNotNull(earliestVersion);
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getEarliestVersion() {
        return this.earliestVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginExportCompatibility that = (PluginExportCompatibility)o;
        return Objects.equals(this.currentVersion, that.currentVersion) && Objects.equals(this.earliestVersion, that.earliestVersion);
    }

    public int hashCode() {
        return Objects.hash(this.currentVersion, this.earliestVersion);
    }

    public String toString() {
        return new ToStringBuilder(this).append("currentVersion", this.currentVersion).append("earliestVersion", this.earliestVersion).toString();
    }
}

